/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.datatable;

import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.DataTableListener;
import com.rapidminer.datatable.DataTableRow;
import com.rapidminer.gui.plotter.charts.AbstractChartPanel;
import com.rapidminer.report.Tableable;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.container.Pair;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jfree.data.Range;

public abstract class AbstractDataTable
implements DataTable,
Tableable {
    private List<DataTableListener> listeners = new LinkedList<DataTableListener>();
    private String name;
    private HashSet<String> deselectionSet = new HashSet();
    private int deselectionCount;

    public AbstractDataTable() {
        this("");
    }

    public AbstractDataTable(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String[] getColumnNames() {
        String[] result = new String[this.getNumberOfColumns()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getColumnName(i);
        }
        return result;
    }

    @Override
    public void addDataTableListener(DataTableListener dataTableListener) {
        this.listeners.add(dataTableListener);
    }

    @Override
    public void removeDataTableListener(DataTableListener dataTableListener) {
        this.listeners.remove(dataTableListener);
    }

    protected void fireEvent() {
        Iterator i = new LinkedList<DataTableListener>(this.listeners).iterator();
        while (i.hasNext()) {
            ((DataTableListener)i.next()).dataTableUpdated(this);
        }
    }

    @Override
    public String getValueAsString(DataTableRow row, int column) {
        double value = row.getValue(column);
        if (Double.isNaN(value)) {
            return null;
        }
        if (this.isDate(column)) {
            return Tools.formatDate(new Date((long)value));
        }
        if (this.isDateTime(column)) {
            return Tools.formatDateTime(new Date((long)value));
        }
        if (this.isTime(column)) {
            return Tools.formatTime(new Date((long)value));
        }
        if (this.isNominal(column)) {
            return this.mapIndex(column, (int)value);
        }
        return value + "";
    }

    @Override
    public void write(PrintWriter out) throws IOException {
        out.println("# Generated by " + this.getName() + "[" + this.getClass().getName() + "]");
        for (int j = 0; j < this.getNumberOfColumns(); ++j) {
            out.print((j != 0 ? "\t" : "# ") + this.getColumnName(j));
        }
        out.println();
        for (DataTableRow row : this) {
            for (int j = 0; j < this.getNumberOfColumns(); ++j) {
                out.print((j != 0 ? "\t" : "") + this.getValueAsString(row, j));
            }
            out.println();
        }
        out.flush();
    }

    @Override
    public boolean containsMissingValues() {
        for (DataTableRow row : this) {
            for (int j = 0; j < this.getNumberOfColumns(); ++j) {
                if (!Double.isNaN(row.getValue(j))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getRowNumber() {
        return this.getNumberOfRows();
    }

    @Override
    public int getColumnNumber() {
        return this.getNumberOfColumns();
    }

    @Override
    public String getCell(int row, int column) {
        double value = this.getRow(row).getValue(column);
        if (this.isDate(column)) {
            return Tools.formatDate(new Date((long)value));
        }
        if (this.isDateTime(column)) {
            return Tools.formatDateTime(new Date((long)value));
        }
        if (this.isTime(column)) {
            return Tools.formatTime(new Date((long)value));
        }
        if (this.isNominal(column)) {
            return this.mapIndex(column, (int)value);
        }
        return Tools.formatIntegerIfPossible(value);
    }

    @Override
    public void prepareReporting() {
    }

    @Override
    public void finishReporting() {
    }

    @Override
    public boolean isFirstLineHeader() {
        return false;
    }

    @Override
    public boolean isFirstColumnHeader() {
        return false;
    }

    @Override
    public boolean isDeselected(String id) {
        return this.deselectionSet.contains(id);
    }

    @Override
    public void setSelection(AbstractChartPanel.Selection selection) {
        this.deselectionCount = 0;
        Collection<Pair<String, Range>> delimiters = selection.getDelimiters();
        Iterator<DataTableRow> i = this.iterator();
        this.deselectionSet.clear();
        while (i.hasNext()) {
            String id;
            DataTableRow row = i.next();
            boolean rowSelected = true;
            for (Pair<String, Range> delimiter : delimiters) {
                double value;
                int col = this.getColumnIndex(delimiter.getFirst());
                if (col < 0 || col >= this.getNumberOfColumns() || Double.isNaN(value = row.getValue(col))) continue;
                rowSelected &= delimiter.getSecond().contains(value);
            }
            if (rowSelected || (id = row.getId()) == null) continue;
            this.deselectionSet.add(id);
            ++this.deselectionCount;
        }
        this.fireEvent();
    }

    @Override
    public int getSelectionCount() {
        return this.getNumberOfRows() - this.deselectionCount;
    }
}

