/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer;

import com.rapidminer.Process;
import com.rapidminer.ProcessLocation;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.Folder;
import com.rapidminer.repository.ProcessEntry;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ProgressListener;
import com.rapidminer.tools.XMLException;
import java.io.IOException;

public class RepositoryProcessLocation
implements ProcessLocation {
    private final RepositoryLocation repositoryLocation;

    public RepositoryProcessLocation(RepositoryLocation location) {
        this.repositoryLocation = location;
    }

    private ProcessEntry getEntry() throws IOException {
        Entry entry;
        try {
            entry = this.repositoryLocation.locateEntry();
        }
        catch (RepositoryException e) {
            throw new IOException("Cannot locate entry '" + this.repositoryLocation + "': " + e, e);
        }
        if (entry == null) {
            throw new IOException("No such entry: " + this.repositoryLocation);
        }
        if (!(entry instanceof ProcessEntry)) {
            throw new IOException("No process entry: " + this.repositoryLocation);
        }
        return (ProcessEntry)entry;
    }

    @Override
    public String getRawXML() throws IOException {
        try {
            return this.getEntry().retrieveXML();
        }
        catch (RepositoryException e) {
            throw new IOException("Cannot access entry '" + this.repositoryLocation + "': " + e, e);
        }
    }

    @Override
    public Process load(ProgressListener listener) throws IOException, XMLException {
        if (listener != null) {
            listener.setCompleted(60);
        }
        String xml = this.getRawXML();
        Process process = new Process(xml);
        process.setProcessLocation(this);
        if (listener != null) {
            listener.setCompleted(80);
        }
        return process;
    }

    @Override
    public String toHistoryFileString() {
        return "repository " + this.repositoryLocation.toString();
    }

    @Override
    public void store(Process process, ProgressListener listener) throws IOException {
        try {
            Entry entry = this.repositoryLocation.locateEntry();
            if (entry == null) {
                Folder folder = this.repositoryLocation.parent().createFoldersRecursively();
                folder.createProcessEntry(this.repositoryLocation.getName(), process.getRootOperator().getXML(false));
            } else if (entry instanceof ProcessEntry) {
                ((ProcessEntry)entry).storeXML(process.getRootOperator().getXML(false));
            } else {
                throw new RepositoryException("Entry " + this.repositoryLocation + " is not a process entry.");
            }
            LogService.getRoot().info("Saved process definition at '" + this.repositoryLocation + "'.");
        }
        catch (RepositoryException e) {
            throw new IOException("Cannot store process at " + this.repositoryLocation + ": " + e.getMessage(), e);
        }
    }

    public RepositoryLocation getRepositoryLocation() {
        return this.repositoryLocation;
    }

    @Override
    public String toMenuString() {
        return this.repositoryLocation.toString();
    }

    @Override
    public String toString() {
        return this.toMenuString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof RepositoryProcessLocation)) {
            return false;
        }
        return ((RepositoryProcessLocation)o).repositoryLocation.equals(this.repositoryLocation);
    }

    public int hashCode() {
        return this.repositoryLocation.hashCode();
    }

    @Override
    public String getShortName() {
        return this.repositoryLocation.getName();
    }
}

