/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer;

import com.rapidminer.BreakpointListener;
import com.rapidminer.Process;
import com.rapidminer.RapidMiner;
import com.rapidminer.RepositoryProcessLocation;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.Operator;
import com.rapidminer.parameter.UndefinedParameterError;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.usagestats.OperatorStatisticsValue;
import com.rapidminer.tools.usagestats.UsageStatistics;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;

public class RapidMinerCommandLine
extends RapidMiner
implements BreakpointListener {
    private static final String LICENSE = "RapidMiner version " + RapidMiner.getLongVersion() + ", Copyright (C) 2001-2008" + Tools.getLineSeparator() + "RapidMiner comes with ABSOLUTELY NO WARRANTY; This is free software," + Tools.getLineSeparator() + "and you are welcome to redistribute it under certain conditions;" + Tools.getLineSeparator() + "see license information in the file named LICENSE.";
    private String repositoryLocation = null;
    private boolean readFromFile = false;

    @Override
    public void breakpointReached(Process process, Operator operator, IOContainer container, int location) {
        System.out.println("Results in application " + operator.getApplyCount() + " of " + operator.getName() + ":" + Tools.getLineSeparator() + container);
        System.out.println("Breakpoint reached " + (location == 0 ? "before " : "after ") + operator.getName() + ", press enter...");
        new WaitForKeyThread(process).start();
    }

    @Override
    public void resume() {
    }

    private void parseArguments(String[] argv) {
        this.repositoryLocation = null;
        for (int i = 0; i < argv.length; ++i) {
            if ("-f".equals(argv[i])) {
                this.readFromFile = true;
                continue;
            }
            this.repositoryLocation = argv[i];
        }
        if (this.repositoryLocation == null) {
            RapidMinerCommandLine.printUsage();
        }
    }

    private static void printUsage() {
        System.err.println("Usage: " + RapidMinerCommandLine.class.getName() + " [-f] PROCESS\n" + "  PROCESS   a repository location containing a process\n" + "  -f        interpret PROCESS as a file rather than a repository location (deprecated)");
        System.exit(1);
    }

    private void run() {
        ParameterService.ensureRapidMinerHomeSet();
        RapidMiner.init();
        Process process = null;
        try {
            if (this.readFromFile) {
                process = RapidMiner.readProcessFile(new File(this.repositoryLocation));
            } else {
                RepositoryProcessLocation loc = new RepositoryProcessLocation(new RepositoryLocation(this.repositoryLocation));
                process = loc.load(null);
            }
        }
        catch (Exception e) {
            LogService.getRoot().severe("Cannot read process setup '" + this.repositoryLocation + "': " + e.getMessage());
            RapidMiner.quit(RapidMiner.ExitMode.ERROR);
        }
        if (process != null) {
            try {
                process.addBreakpointListener(this);
                IOContainer results = process.run();
                process.getRootOperator().sendEmail(results, null);
                LogService.getRoot().info("Process finished successfully");
                RapidMiner.quit(RapidMiner.ExitMode.NORMAL);
            }
            catch (Throwable e) {
                UsageStatistics.getInstance().count(process.getCurrentOperator(), OperatorStatisticsValue.FAILURE);
                UsageStatistics.getInstance().count(process.getCurrentOperator(), OperatorStatisticsValue.RUNTIME_EXCEPTION);
                String debugProperty = System.getProperty("rapidminer.general.debugmode");
                boolean debugMode = Tools.booleanValue(debugProperty, false);
                String message = e.getMessage();
                if (!debugMode && e instanceof RuntimeException) {
                    message = e.getMessage() != null ? "operator cannot be executed (" + e.getMessage() + "). Check the log messages..." : "operator cannot be executed. Check the log messages...";
                }
                process.getLogger().log(Level.SEVERE, "Process failed: " + message, e);
                process.getLogger().log(Level.SEVERE, "Here: " + process.getRootOperator().createMarkedProcessTree(10, "==>", process.getCurrentOperator()));
                try {
                    process.getRootOperator().sendEmail(null, e);
                }
                catch (UndefinedParameterError ex) {
                    // empty catch block
                }
                LogService.getRoot().severe("Process not successful");
                RapidMiner.quit(RapidMiner.ExitMode.ERROR);
            }
        }
    }

    public static void main(String[] argv) {
        RapidMinerCommandLine.setExecutionMode(RapidMiner.ExecutionMode.COMMAND_LINE);
        System.out.println(LICENSE);
        RapidMinerCommandLine main = new RapidMinerCommandLine();
        main.parseArguments(argv);
        main.run();
    }

    private static class WaitForKeyThread
    extends Thread {
        private final Process process;

        public WaitForKeyThread(Process process) {
            this.process = process;
        }

        @Override
        public void run() {
            try {
                System.in.read();
            }
            catch (IOException e) {
                LogService.getRoot().log(Level.WARNING, "Error occured while waiting for user input: " + e.getMessage(), e);
            }
            this.process.resume();
        }
    }
}

