/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer;

import com.rapid_i.Launcher;
import com.rapidminer.ConsoleInputHandler;
import com.rapidminer.InputHandler;
import com.rapidminer.Process;
import com.rapidminer.RapidMinerVersion;
import com.rapidminer.gui.renderer.RendererService;
import com.rapidminer.gui.tools.SplashScreen;
import com.rapidminer.gui.tools.VersionNumber;
import com.rapidminer.io.process.XMLImporter;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypePassword;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.repository.RepositoryManager;
import com.rapidminer.tools.I18N;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.ProgressListener;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.XMLException;
import com.rapidminer.tools.XMLSerialization;
import com.rapidminer.tools.cipher.CipherTools;
import com.rapidminer.tools.cipher.KeyGenerationException;
import com.rapidminer.tools.cipher.KeyGeneratorTool;
import com.rapidminer.tools.jdbc.DatabaseService;
import com.rapidminer.tools.jdbc.connection.DatabaseConnectionService;
import com.rapidminer.tools.plugin.Plugin;
import com.rapidminer.tools.usagestats.UsageStatistics;
import java.awt.Frame;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.imageio.ImageIO;

public class RapidMiner {
    public static final String SYSTEM_ENCODING_NAME = "SYSTEM";
    private static ExecutionMode executionMode = ExecutionMode.UNKNOWN;
    private static VersionNumber version = new RapidMinerVersion();
    public static final String PROPERTY_RAPIDMINER_VERSION = "rapidminer.version";
    public static final String PROPERTY_DEVELOPER_MODE = "rapidminer.developermode";
    public static final String PROPERTY_RAPIDMINER_OPERATORS_ADDITIONAL = "rapidminer.operators.additional";
    public static final String PROPERTY_RAPIDMINER_OBJECTS_ADDITIONAL = "rapidminer.objects.additional";
    public static final String PROPERTY_RAPIDMINER_RC_FILE = "rapidminer.rcfile";
    public static final String PROPERTY_RAPIDMINER_GLOBAL_LOG_FILE = "rapidminer.global.logging.file";
    public static final String PROPERTY_RAPIDMINER_GLOBAL_LOG_VERBOSITY = "rapidminer.global.logging.verbosity";
    public static final String PROPERTY_RAPIDMINER_INIT_OPERATORS = "rapidminer.init.operators";
    public static final String PROPERTY_RAPIDMINER_INIT_LOCALE_LANGUAGE = "rapidminer.init.locale.language";
    public static final String PROPERTY_RAPIDMINER_INIT_LOCALE_COUNTRY = "rapidminer.init.locale.country";
    public static final String PROPERTY_RAPIDMINER_INIT_LOCALE_VARIANT = "rapidminer.init.locale.variant";
    public static final String PROPERTY_RAPIDMINER_INIT_PLUGINS = "rapidminer.init.plugins";
    public static final String PROPERTY_RAPIDMINER_INIT_PLUGINS_LOCATION = "rapidminer.init.plugins.location";
    public static final String PROPERTY_RAPIDMINER_GENERAL_FRACTIONDIGITS_NUMBERS = "rapidminer.general.fractiondigits.numbers";
    public static final String PROPERTY_RAPIDMINER_GENERAL_FRACTIONDIGITS_PERCENT = "rapidminer.general.fractiondigits.percent";
    public static final String PROPERTY_RAPIDMINER_GENERAL_MAX_META_DATA_ATTRIBUTES = "rapidminer.general.md_attributes_limit";
    public static final String PROPERTY_RAPIDMINER_GENERAL_MAX_NOMINAL_VALUES = "rapidminer.general.md_nominal_values_limit";
    public static final String PROPERTY_RAPIDMINER_GENERAL_MAX_TEST_ROWS = "rapidminer.general.max_rows_used_for_guessing";
    public static final String PROPERTY_RAPIDMINER_TOOLS_EDITOR = "rapidminer.tools.editor";
    public static final String PROPERTY_RAPIDMINER_TOOLS_MAIL_METHOD = "rapidminer.tools.mail.method";
    public static final String[] PROPERTY_RAPIDMINER_TOOLS_MAIL_METHOD_VALUES = new String[]{"sendmail", "SMTP"};
    public static final int PROPERTY_RAPIDMINER_TOOLS_MAIL_METHOD_SENDMAIL = 0;
    public static final int PROPERTY_RAPIDMINER_TOOLS_MAIL_METHOD_SMTP = 1;
    public static final String PROPERTY_RAPIDMINER_TOOLS_MAIL_DEFAULT_RECIPIENT = "rapidminer.tools.mail.default_recipient";
    public static final String PROPERTY_RAPIDMINER_TOOLS_MAIL_DEFAULT_PROCESS_DURATION_FOR_MAIL = "rapidminer.tools.mail.process_duration_for_mail";
    public static final String PROPERTY_RAPIDMINER_TOOLS_SENDMAIL_COMMAND = "rapidminer.tools.sendmail.command";
    public static final String PROPERTY_RAPIDMINER_TOOLS_SMTP_HOST = "rapidminer.tools.smtp.host";
    public static final String PROPERTY_RAPIDMINER_TOOLS_SMTP_PORT = "rapidminer.tools.smtp.port";
    public static final String PROPERTY_RAPIDMINER_TOOLS_SMTP_USER = "rapidminer.tools.smtp.user";
    public static final String PROPERTY_RAPIDMINER_TOOLS_SMTP_PASSWD = "rapidminer.tools.smtp.passwd";
    public static final String PROPERTY_RAPIDMINER_TOOLS_DB_ONLY_STANDARD_TABLES = "rapidminer.tools.db.assist.show_only_standard_tables";
    public static final String PROPERTY_RAPIDMINER_GENERAL_LOGFILE_FORMAT = "rapidminer.general.logfile.format";
    public static final String PROPERTY_RAPIDMINER_GENERAL_DEBUGMODE = "rapidminer.general.debugmode";
    public static final String PROPERTY_RAPIDMINER_GENERAL_DEFAULT_ENCODING = "rapidminer.general.encoding";
    public static final String PROPERTY_RAPIDMINER_GENERAL_TIME_ZONE = "rapidminer.general.timezone";
    public static final String PROPERTY_RAPIDMINER_HTTP_PROXY_SET = "http.proxySet";
    public static final String PROPERTY_RAPIDMINER_HTTP_PROXY_HOST = "http.proxyHost";
    public static final String PROPERTY_RAPIDMINER_HTTP_PROXY_PORT = "http.proxyPort";
    public static final String PROPERTY_RAPIDMINER_HTTP_PROXY_NON_PROXY_HOSTS = "http.nonProxyHosts";
    public static final String PROPERTY_RAPIDMINER_HTTP_PROXY_USERNAME = "http.proxyUsername";
    public static final String PROPERTY_RAPIDMINER_HTTP_PROXY_PASSWORD = "http.proxyPassword";
    public static final String PROPERTY_RAPIDMINER_HTTPS_PROXY_SET = "https.proxySet";
    public static final String PROPERTY_RAPIDMINER_HTTPS_PROXY_HOST = "https.proxyHost";
    public static final String PROPERTY_RAPIDMINER_HTTPS_PROXY_PORT = "https.proxyPort";
    public static final String PROPERTY_RAPIDMINER_FTP_PROXY_SET = "ftp.proxySet";
    public static final String PROPERTY_RAPIDMINER_FTP_PROXY_HOST = "ftp.proxyHost";
    public static final String PROPERTY_RAPIDMINER_FTP_PROXY_PORT = "ftp.proxyPort";
    public static final String PROPERTY_RAPIDMINER_FTP_PROXY_NON_PROXY_HOSTS = "ftp.nonProxyHosts";
    public static final String PROPERTY_RAPIDMINER_SOCKS_PROXY_HOST = "socksProxyHost";
    public static final String PROPERTY_RAPIDMINER_SOCKS_PROXY_PORT = "socksProxyPort";
    private static final Set<ParameterType> PROPERTY_TYPES = new TreeSet<ParameterType>();
    public static final String PROCESS_FILE_EXTENSION = "rmp";
    private static InputHandler inputHandler;
    private static SplashScreen splashScreen;
    private static final List<Runnable> shutdownHooks;
    public static final String PROPERTY_HOME_REPOSITORY_URL = "rapidminer.homerepository.url";
    public static final String PROPERTY_HOME_REPOSITORY_USER = "rapidminer.homerepository.user";

    public static String getShortVersion() {
        return version.getShortVersion();
    }

    public static String getLongVersion() {
        return version.getLongVersion();
    }

    public static VersionNumber getVersion() {
        return version;
    }

    @Deprecated
    public static Process readExperimentFile(File experimentfile) throws XMLException, IOException, InstantiationException, IllegalAccessException {
        return RapidMiner.readProcessFile(experimentfile);
    }

    public static Process readProcessFile(File processFile) throws XMLException, IOException, InstantiationException, IllegalAccessException {
        return RapidMiner.readProcessFile(processFile, null);
    }

    public static Process readProcessFile(File processFile, ProgressListener progressListener) throws XMLException, IOException, InstantiationException, IllegalAccessException {
        try {
            LogService.getRoot().fine("Reading process file '" + processFile + "'.");
            if (!processFile.exists() || !processFile.canRead()) {
                LogService.getRoot().severe("Cannot read process definition file '" + processFile + "'!");
            }
            return new Process(processFile, progressListener);
        }
        catch (XMLException e) {
            throw new XMLException(processFile.getName() + ":" + e.getMessage(), e);
        }
    }

    public static void init() {
        String localeLanguage = System.getProperty(PROPERTY_RAPIDMINER_INIT_LOCALE_LANGUAGE);
        String localeCountry = System.getProperty(PROPERTY_RAPIDMINER_INIT_LOCALE_COUNTRY);
        String localeVariant = System.getProperty(PROPERTY_RAPIDMINER_INIT_LOCALE_VARIANT);
        if (localeLanguage != null) {
            Locale locale = localeVariant != null && localeCountry != null ? new Locale(localeLanguage, localeCountry, localeVariant) : (localeCountry != null ? new Locale(localeLanguage, localeCountry) : new Locale(localeLanguage));
            Locale.setDefault(locale);
            LogService.getRoot().config("Set default locale to " + locale);
        } else {
            Locale.setDefault(Locale.US);
            LogService.getRoot().config("Locale not specified explicitly. Set default locale to US.");
        }
        RapidMiner.splashMessage("init_i18n");
        I18N.getErrorBundle();
        RapidMiner.splashMessage("rm_home");
        ParameterService.ensureRapidMinerHomeSet();
        RapidMiner.splashMessage("init_parameter_service");
        ParameterService.init();
        RapidMiner.splashMessage("register_plugins");
        Plugin.initAll();
        Plugin.initPluginSplashTexts(splashScreen);
        RapidMiner.showSplashInfos();
        RapidMiner.splashMessage("init_ops");
        OperatorService.init();
        UsageStatistics.getInstance();
        RapidMiner.splashMessage("xml_transformer");
        XMLImporter.init();
        RapidMiner.splashMessage("load_jdbc_drivers");
        DatabaseService.init();
        DatabaseConnectionService.init();
        RapidMiner.splashMessage("init_repository");
        RepositoryManager.init();
        RapidMiner.splashMessage("xml_serialization");
        XMLSerialization.init(Plugin.getMajorClassLoader());
        RapidMiner.splashMessage("xml_alias");
        OperatorService.defineXMLAliasPairs();
        if (!CipherTools.isKeyAvailable()) {
            RapidMiner.splashMessage("gen_key");
            try {
                KeyGeneratorTool.createAndStoreKey();
            }
            catch (KeyGenerationException e) {
                LogService.getRoot().log(Level.WARNING, "Cannot generate encryption key: " + e.getMessage(), e);
            }
        }
        RapidMiner.splashMessage("init_renderers");
        RendererService.init();
    }

    private static void showSplashInfos() {
        if (RapidMiner.getSplashScreen() != null) {
            RapidMiner.getSplashScreen().setInfosVisible(true);
        }
    }

    public static SplashScreen showSplash() {
        URL url = Tools.getResource("rapidminer_logo.png");
        BufferedImage logo = null;
        try {
            if (url != null) {
                logo = ImageIO.read(url);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return RapidMiner.showSplash(logo);
    }

    public static SplashScreen showSplash(Image productLogo) {
        splashScreen = new SplashScreen(RapidMiner.getShortVersion(), productLogo);
        splashScreen.showSplashScreen();
        return splashScreen;
    }

    public static void hideSplash() {
        splashScreen.dispose();
    }

    public static void splashMessage(String messageKey) {
        if (splashScreen != null) {
            splashScreen.setMessage(I18N.getMessage(I18N.getGUIBundle(), "gui.splash." + messageKey, new Object[0]));
        } else {
            LogService.getRoot().config(I18N.getMessage(I18N.getGUIBundle(), "gui.splash." + messageKey, new Object[0]));
        }
    }

    public static void splashMessage(String messageKey, Object ... args) {
        if (splashScreen != null) {
            splashScreen.setMessage(I18N.getMessage(I18N.getGUIBundle(), "gui.splash." + messageKey, args));
        }
    }

    public static SplashScreen getSplashScreen() {
        return splashScreen;
    }

    public static Frame getSplashScreenFrame() {
        if (splashScreen != null) {
            return splashScreen.getSplashScreenFrame();
        }
        return null;
    }

    public static void setInputHandler(InputHandler inputHandler) {
        RapidMiner.inputHandler = inputHandler;
    }

    public static InputHandler getInputHandler() {
        return inputHandler;
    }

    @Deprecated
    public static Set<ParameterType> getYaleProperties() {
        return RapidMiner.getRapidMinerProperties();
    }

    public static Set<ParameterType> getRapidMinerProperties() {
        return PROPERTY_TYPES;
    }

    @Deprecated
    public static void registerYaleProperty(ParameterType type) {
        RapidMiner.registerRapidMinerProperty(type);
    }

    public static void registerRapidMinerProperty(ParameterType type) {
        PROPERTY_TYPES.add(type);
    }

    public static String getRapidMinerPropertyValue(String property) {
        return System.getProperty(property);
    }

    public static void setRapidMinerPropertyValue(String property, String value) {
        System.setProperty(property, value);
    }

    public static synchronized void addShutdownHook(Runnable runnable) {
        shutdownHooks.add(runnable);
    }

    public static synchronized void quit(ExitMode exitMode) {
        for (Runnable hook : shutdownHooks) {
            try {
                hook.run();
            }
            catch (Exception e) {
                LogService.getRoot().log(Level.WARNING, "Error executing shutdown hook: " + e.getMessage(), e);
            }
        }
        try {
            Runtime.getRuntime().runFinalization();
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.WARNING, "Error during finalization: " + e.getMessage(), e);
        }
        switch (exitMode) {
            case NORMAL: {
                System.exit(0);
                break;
            }
            case ERROR: {
                System.exit(1);
                break;
            }
            case RELAUNCH: {
                Launcher.relaunch();
            }
        }
    }

    public static ExecutionMode getExecutionMode() {
        return executionMode;
    }

    public static void setExecutionMode(ExecutionMode executionMode) {
        RapidMiner.executionMode = executionMode;
    }

    public static void setLocale(String language, String country, String variant) {
        System.setProperty(PROPERTY_RAPIDMINER_INIT_LOCALE_LANGUAGE, language);
        System.setProperty(PROPERTY_RAPIDMINER_INIT_LOCALE_COUNTRY, country);
        System.setProperty(PROPERTY_RAPIDMINER_INIT_LOCALE_VARIANT, variant);
    }

    static {
        System.setProperty(PROPERTY_RAPIDMINER_VERSION, RapidMiner.getLongVersion());
        RapidMiner.registerRapidMinerProperty(new ParameterTypeInt(PROPERTY_RAPIDMINER_GENERAL_FRACTIONDIGITS_NUMBERS, "The number of fraction digits of formatted numbers.", 0, Integer.MAX_VALUE, 3));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeInt(PROPERTY_RAPIDMINER_GENERAL_FRACTIONDIGITS_PERCENT, "The number of fraction digits of formatted percent values.", 0, Integer.MAX_VALUE, 2));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeInt(PROPERTY_RAPIDMINER_GENERAL_MAX_NOMINAL_VALUES, "The number of nominal values to use for meta data transformation, 0 for unlimited. (Changing this value requires a cache refresh of the meta data for the current process, e.g. by changing the 'location' parameter of a 'Retrieve' operator.)", 0, Integer.MAX_VALUE, 100));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeInt(PROPERTY_RAPIDMINER_GENERAL_MAX_TEST_ROWS, "The number of lines read during input operations to guess the value type of certain columns if not specified. If set to 0, all rows will be used", 0, Integer.MAX_VALUE, 100));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeString(PROPERTY_RAPIDMINER_TOOLS_EDITOR, "Path to external Java editor. %f is replaced by filename and %l by the linenumber.", true));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeCategory(PROPERTY_RAPIDMINER_TOOLS_MAIL_METHOD, "Method to send outgoing mails. Either SMTP or sendmail.", PROPERTY_RAPIDMINER_TOOLS_MAIL_METHOD_VALUES, 0));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeString(PROPERTY_RAPIDMINER_TOOLS_MAIL_DEFAULT_RECIPIENT, "Default recipient for outgoing mails.", true));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeInt(PROPERTY_RAPIDMINER_TOOLS_MAIL_DEFAULT_PROCESS_DURATION_FOR_MAIL, "Default process duration time necessary to send notification emails (in minutes).", 0, Integer.MAX_VALUE, 30));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeString(PROPERTY_RAPIDMINER_TOOLS_SENDMAIL_COMMAND, "Path to sendmail. Used for email notifications.", true));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeString(PROPERTY_RAPIDMINER_TOOLS_SMTP_HOST, "SMTP host. Used for email notifications.", true));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeString(PROPERTY_RAPIDMINER_TOOLS_SMTP_PORT, "SMTP port, defaults to 25. Used for email notifications.", true));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeString(PROPERTY_RAPIDMINER_TOOLS_SMTP_USER, "SMTP user name. Used for email notifications.", true));
        RapidMiner.registerRapidMinerProperty(new ParameterTypePassword(PROPERTY_RAPIDMINER_TOOLS_SMTP_PASSWD, "SMTP password, if required. Used for email notifications."));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeBoolean(PROPERTY_RAPIDMINER_GENERAL_LOGFILE_FORMAT, "Use unix special characters for logfile highlighting (requires new RapidMiner instance).", false));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeBoolean(PROPERTY_RAPIDMINER_GENERAL_DEBUGMODE, "Indicates if RapidMiner should be used in debug mode (print exception stacks and shows more technical error messages)", false));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeString(PROPERTY_RAPIDMINER_GENERAL_DEFAULT_ENCODING, "The default encoding used for file operations (default: 'SYSTEM' uses the underlying system encoding, 'UTF-8' or 'ISO-8859-1' are other common options)", SYSTEM_ENCODING_NAME));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeCategory(PROPERTY_RAPIDMINER_GENERAL_TIME_ZONE, "The default time zone used for displaying date and time information (default: 'SYSTEM' uses the underlying system encoding, 'UCT', 'GMT' or 'CET' are other common options)", Tools.getAllTimeZones(), 0));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeBoolean(PROPERTY_RAPIDMINER_TOOLS_DB_ONLY_STANDARD_TABLES, "If checked, assistants and query builders will only show standard database tables, hiding system tables, views, etc.", true));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeBoolean("rapidminer.general.capabilities.warn", "Indicates if only a warning should be made if learning capabilities are not fulfilled (instead of breaking the process).", false));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeBoolean(PROPERTY_RAPIDMINER_INIT_PLUGINS, "Initialize pluigins?", true));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeFile(PROPERTY_RAPIDMINER_INIT_PLUGINS_LOCATION, "Directory to scan for plugin jars.", null, true));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeBoolean(PROPERTY_RAPIDMINER_HTTP_PROXY_SET, "Determines whether a proxy is used for HTTP connections.", false));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeString(PROPERTY_RAPIDMINER_HTTP_PROXY_HOST, "The proxy host to use for HTTP.", true));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeInt(PROPERTY_RAPIDMINER_HTTP_PROXY_PORT, "The proxy port to use for HTTP.", 0, 65535, true));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeString(PROPERTY_RAPIDMINER_HTTP_PROXY_NON_PROXY_HOSTS, "List of regular expressions separated by '|' determining hosts to be connected directly bypassing the proxy.", true));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeString(PROPERTY_RAPIDMINER_HTTP_PROXY_USERNAME, "The user name for the proxy server in cases where it needs authentication.", true));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeString(PROPERTY_RAPIDMINER_HTTP_PROXY_PASSWORD, "The password for the proxy server in cases where it needs authentication.", true));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeBoolean(PROPERTY_RAPIDMINER_HTTPS_PROXY_SET, "Determines whether a proxy is used for HTTPS connections.", true));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeString(PROPERTY_RAPIDMINER_HTTPS_PROXY_HOST, "The proxy host to use for HTTPS.", true));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeInt(PROPERTY_RAPIDMINER_HTTPS_PROXY_PORT, "The proxy port to use for HTTPS.", 0, 65535, true));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeBoolean(PROPERTY_RAPIDMINER_FTP_PROXY_SET, "Determines whether a proxy is used for FTPconnections.", false));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeString(PROPERTY_RAPIDMINER_FTP_PROXY_HOST, "The proxy host to use for FTP.", true));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeInt(PROPERTY_RAPIDMINER_FTP_PROXY_PORT, "The proxy port to use for FTP.", 0, 65535, true));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeString(PROPERTY_RAPIDMINER_FTP_PROXY_NON_PROXY_HOSTS, "List of regular expressions separated by '|' determining hosts to be connected directly bypassing the proxy.", true));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeString(PROPERTY_RAPIDMINER_SOCKS_PROXY_HOST, "The proxy host to use for SOCKS.", true));
        RapidMiner.registerRapidMinerProperty(new ParameterTypeInt(PROPERTY_RAPIDMINER_SOCKS_PROXY_PORT, "The proxy port to use for SOCKS.", 0, 65535, true));
        inputHandler = new ConsoleInputHandler();
        shutdownHooks = new LinkedList<Runnable>();
    }

    public static enum ExecutionMode {
        UNKNOWN(true, false, false, true),
        COMMAND_LINE(true, true, false, true),
        UI(false, true, true, true),
        APPSERVER(true, false, false, false),
        APPLET(false, true, true, false),
        EMBEDDED_WITH_UI(false, true, false, false),
        EMBEDDED_WITHOUT_UI(true, true, false, false),
        EMBEDDED_AS_APPLET(false, false, false, false),
        WEBSTART(false, true, true, true),
        TEST(true, false, false, true);

        private final boolean isHeadless;
        private final boolean canAccessFilesystem;
        private final boolean hasMainFrame;
        private final boolean loadManagedExtensions;

        private ExecutionMode(boolean isHeadless, boolean canAccessFilesystem, boolean hasMainFrame, boolean loadManagedExtensions) {
            this.isHeadless = isHeadless;
            this.canAccessFilesystem = canAccessFilesystem;
            this.hasMainFrame = hasMainFrame;
            this.loadManagedExtensions = loadManagedExtensions;
        }

        public boolean isHeadless() {
            return this.isHeadless;
        }

        public boolean canAccessFilesystem() {
            return this.canAccessFilesystem;
        }

        public boolean hasMainFrame() {
            return this.hasMainFrame;
        }

        public boolean isLoadingManagedExtensions() {
            return this.loadManagedExtensions;
        }
    }

    public static enum ExitMode {
        NORMAL,
        ERROR,
        RELAUNCH;

    }
}

