/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer;

import com.rapidminer.tools.AbstractObservable;
import com.rapidminer.tools.container.Pair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ProcessContext
extends AbstractObservable<ProcessContext>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<String> inputRepositoryLocations = new ArrayList<String>();
    private List<String> outputRepositoryLocations = new ArrayList<String>();
    private List<Pair<String, String>> macros = new LinkedList<Pair<String, String>>();

    public List<String> getInputRepositoryLocations() {
        return Collections.unmodifiableList(this.inputRepositoryLocations);
    }

    public void setInputRepositoryLocations(List<String> inputRepositoryLocations) {
        if (inputRepositoryLocations.contains(null)) {
            throw new NullPointerException("Null elements not allowed");
        }
        this.inputRepositoryLocations = inputRepositoryLocations;
        this.fireUpdate(this);
    }

    public List<String> getOutputRepositoryLocations() {
        return Collections.unmodifiableList(this.outputRepositoryLocations);
    }

    public void setOutputRepositoryLocations(List<String> outputRepositoryLocations) {
        if (outputRepositoryLocations.contains(null)) {
            throw new NullPointerException("Null elements not allowed");
        }
        this.outputRepositoryLocations = outputRepositoryLocations;
        this.fireUpdate(this);
    }

    public List<Pair<String, String>> getMacros() {
        return this.macros;
    }

    public void addMacro(Pair<String, String> macro) {
        this.macros.add(macro);
        this.fireUpdate(this);
    }

    public void setMacros(List<Pair<String, String>> macros) {
        this.macros = macros;
        this.fireUpdate(this);
    }

    public void setOutputRepositoryLocation(int index, String location) {
        if (location == null) {
            throw new NullPointerException("Null location not allowed");
        }
        while (this.outputRepositoryLocations.size() <= index) {
            this.outputRepositoryLocations.add("");
        }
        this.outputRepositoryLocations.set(index, location);
        this.fireUpdate();
    }

    public void setInputRepositoryLocation(int index, String location) {
        if (location == null) {
            throw new NullPointerException("Null location not allowed");
        }
        while (this.inputRepositoryLocations.size() <= index) {
            this.inputRepositoryLocations.add("");
        }
        this.inputRepositoryLocations.set(index, location);
        this.fireUpdate();
    }

    public void removeOutputLocation(int rowIndex) {
        this.outputRepositoryLocations.remove(rowIndex);
    }

    public void removeInputLocation(int rowIndex) {
        this.inputRepositoryLocations.remove(rowIndex);
    }

    public void addOutputLocation(String location) {
        if (location == null) {
            throw new NullPointerException("Location must not be null");
        }
        this.outputRepositoryLocations.add(location);
    }

    public void addInputLocation(String location) {
        if (location == null) {
            throw new NullPointerException("Location must not be null");
        }
        this.inputRepositoryLocations.add(location);
    }

    public void superimpose(ProcessContext other) {
        String loc;
        int i;
        if (other == null) {
            return;
        }
        for (Pair<String, String> macro : other.macros) {
            this.macros.add(macro);
        }
        for (i = 0; i < other.inputRepositoryLocations.size(); ++i) {
            loc = other.inputRepositoryLocations.get(i);
            if (loc == null || loc.isEmpty()) continue;
            this.setInputRepositoryLocation(i, loc);
        }
        for (i = 0; i < other.outputRepositoryLocations.size(); ++i) {
            loc = other.outputRepositoryLocations.get(i);
            if (loc == null || loc.isEmpty()) continue;
            this.setOutputRepositoryLocation(i, loc);
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Macros: ").append(this.getMacros());
        b.append("; Input: ").append(this.getInputRepositoryLocations());
        b.append("; Output: ").append(this.getOutputRepositoryLocations());
        return b.toString();
    }
}

