/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer;

import com.rapidminer.BreakpointListener;
import com.rapidminer.FileProcessLocation;
import com.rapidminer.LoggingListener;
import com.rapidminer.MacroHandler;
import com.rapidminer.ProcessContext;
import com.rapidminer.ProcessLocation;
import com.rapidminer.ProcessSetupListener;
import com.rapidminer.RepositoryProcessLocation;
import com.rapidminer.datatable.DataTable;
import com.rapidminer.datatable.SimpleDataTable;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.io.process.XMLImporter;
import com.rapidminer.operator.Annotations;
import com.rapidminer.operator.DebugMode;
import com.rapidminer.operator.ExecutionMode;
import com.rapidminer.operator.ExecutionUnit;
import com.rapidminer.operator.IOContainer;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.ProcessRootOperator;
import com.rapidminer.operator.ProcessStoppedException;
import com.rapidminer.operator.UnknownParameterInformation;
import com.rapidminer.operator.UserError;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.report.ReportStream;
import com.rapidminer.repository.Entry;
import com.rapidminer.repository.IOObjectEntry;
import com.rapidminer.repository.MalformedRepositoryLocationException;
import com.rapidminer.repository.RepositoryAccessor;
import com.rapidminer.repository.RepositoryException;
import com.rapidminer.repository.RepositoryLocation;
import com.rapidminer.repository.RepositoryManager;
import com.rapidminer.tools.AbstractObservable;
import com.rapidminer.tools.LoggingHandler;
import com.rapidminer.tools.Observable;
import com.rapidminer.tools.Observer;
import com.rapidminer.tools.OperatorService;
import com.rapidminer.tools.ProgressListener;
import com.rapidminer.tools.RandomGenerator;
import com.rapidminer.tools.ResultService;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.WrapperLoggingHandler;
import com.rapidminer.tools.XMLException;
import com.rapidminer.tools.container.Pair;
import com.rapidminer.tools.usagestats.OperatorStatisticsValue;
import com.rapidminer.tools.usagestats.UsageStatistics;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.event.EventListenerList;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Process
extends AbstractObservable<Process>
implements Cloneable {
    public static final int PROCESS_STATE_UNKNOWN = -1;
    public static final int PROCESS_STATE_STOPPED = 0;
    public static final int PROCESS_STATE_PAUSED = 1;
    public static final int PROCESS_STATE_RUNNING = 2;
    private ProcessRootOperator rootOperator = null;
    private Operator currentOperator;
    private ProcessLocation processLocation;
    private boolean isProcessConverted = false;
    private final List<UnknownParameterInformation> unknownParameterInformation = new LinkedList<UnknownParameterInformation>();
    private final List<BreakpointListener> breakpointListeners = new LinkedList<BreakpointListener>();
    private final List<LoggingListener> loggingListeners = new LinkedList<LoggingListener>();
    private final MacroHandler macroHandler = new MacroHandler(this);
    private Map<String, Operator> operatorNameMap = new HashMap<String, Operator>();
    private final Map<String, DataTable> dataTableMap = new HashMap<String, DataTable>();
    private final Map<String, ReportStream> reportStreamMap = new HashMap<String, ReportStream>();
    private final Map<String, IOObject> storageMap = new HashMap<String, IOObject>();
    private int processState = 0;
    private transient ExecutionMode executionMode = ExecutionMode.ALWAYS;
    private transient DebugMode debugMode = DebugMode.DEBUG_OFF;
    private final transient Logger logger = this.makeLogger();
    @Deprecated
    private final transient LoggingHandler logService = new WrapperLoggingHandler(this.logger);
    private ProcessContext context = new ProcessContext();
    private String importMessage;
    private final Annotations annotations = new Annotations();
    private RepositoryAccessor repositoryAccessor;
    private final Object breakpointLock = new Object();
    private final EventListenerList processSetupListeners = new EventListenerList();
    private final Observer<ProcessContext> delegatingContextObserver = new Observer<ProcessContext>(){

        @Override
        public void update(Observable<ProcessContext> observable, ProcessContext arg) {
            Process.this.fireUpdate();
        }
    };
    private final Observer<Operator> delegatingOperatorObserver = new Observer<Operator>(){

        @Override
        public void update(Observable<Operator> observable, Operator arg) {
            Process.this.fireUpdate();
        }
    };

    public Process() {
        try {
            ProcessRootOperator root = OperatorService.createOperator(ProcessRootOperator.class);
            root.rename(root.getOperatorDescription().getName());
            this.setRootOperator(root);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot initialize root operator of the process: " + e.getMessage(), e);
        }
        this.initContext();
    }

    public Process(File file) throws IOException, XMLException {
        this(file, null);
    }

    public Process(File file, ProgressListener progressListener) throws IOException, XMLException {
        this.processLocation = new FileProcessLocation(file);
        this.initContext();
        Reader in = null;
        try {
            in = new InputStreamReader((InputStream)new FileInputStream(file), Process.getEncoding(null));
            this.readProcess(in, progressListener);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public Process(String xml, Process process) throws IOException, XMLException {
        this(xml);
        this.processLocation = process.processLocation;
    }

    public Process(String xmlString) throws IOException, XMLException {
        this.initContext();
        StringReader in = new StringReader(xmlString);
        this.readProcess(in);
        in.close();
    }

    public Process(Reader in) throws IOException, XMLException {
        this.initContext();
        this.readProcess(in);
    }

    public Process(InputStream in) throws IOException, XMLException {
        this.initContext();
        this.readProcess(new InputStreamReader(in, XMLImporter.PROCESS_FILE_CHARSET));
    }

    public Process(URL url) throws IOException, XMLException {
        this.initContext();
        InputStreamReader in = new InputStreamReader(url.openStream(), Process.getEncoding(null));
        this.readProcess(in);
        ((Reader)in).close();
    }

    protected Logger makeLogger() {
        return Logger.getLogger(Process.class.getName());
    }

    private void initContext() {
        this.getContext().addObserver(this.delegatingContextObserver, false);
    }

    private Process(Process other) {
        this();
        this.setRootOperator((ProcessRootOperator)other.rootOperator.cloneOperator(other.rootOperator.getName(), false));
        this.currentOperator = null;
        this.processLocation = other.processLocation != null ? other.processLocation : null;
    }

    private void initLogging(int logVerbosity) {
        if (logVerbosity >= 0) {
            this.logger.setLevel(WrapperLoggingHandler.LEVELS[logVerbosity]);
        } else {
            this.logger.setLevel(Level.INFO);
        }
    }

    public Object clone() {
        return new Process(this);
    }

    @Deprecated
    public synchronized void setExperimentState(int state) {
        this.setProcessState(state);
    }

    private void setProcessState(int state) {
        this.processState = state;
    }

    @Deprecated
    public synchronized int getExperimentState() {
        return this.getProcessState();
    }

    public int getProcessState() {
        return this.processState;
    }

    public LoggingHandler getLog() {
        return this.logService;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public MacroHandler getMacroHandler() {
        return this.macroHandler;
    }

    public void clearMacros() {
        this.macroHandler.clear();
    }

    public void store(String name, IOObject object) {
        this.storageMap.put(name, object);
    }

    public IOObject retrieve(String name, boolean remove) {
        if (remove) {
            return this.storageMap.remove(name);
        }
        return this.storageMap.get(name);
    }

    public void clearStorage() {
        this.storageMap.clear();
    }

    public void addLoggingListener(LoggingListener loggingListener) {
        this.loggingListeners.add(loggingListener);
    }

    public void removeLoggingListener(LoggingListener loggingListener) {
        this.loggingListeners.remove(loggingListener);
    }

    public boolean dataTableExists(String name) {
        return this.dataTableMap.get(name) != null;
    }

    public void addDataTable(DataTable table) {
        this.dataTableMap.put(table.getName(), table);
        for (LoggingListener listener : this.loggingListeners) {
            listener.addDataTable(table);
        }
    }

    public void clearDataTable(String name) {
        DataTable table = this.getDataTable(name);
        if (table != null && table instanceof SimpleDataTable) {
            ((SimpleDataTable)table).clear();
        }
    }

    public void deleteDataTable(String name) {
        if (this.dataTableExists(name)) {
            DataTable table = this.dataTableMap.remove(name);
            for (LoggingListener listener : this.loggingListeners) {
                listener.removeDataTable(table);
            }
        }
    }

    public DataTable getDataTable(String name) {
        return this.dataTableMap.get(name);
    }

    public Collection<DataTable> getDataTables() {
        return this.dataTableMap.values();
    }

    private void clearDataTables() {
        this.dataTableMap.clear();
    }

    public void addReportStream(ReportStream stream) {
        this.reportStreamMap.put(stream.getName(), stream);
    }

    public ReportStream getReportStream(String name) {
        if (name == null || name.length() == 0) {
            if (this.reportStreamMap.size() == 1) {
                return this.reportStreamMap.values().iterator().next();
            }
            return null;
        }
        return this.reportStreamMap.get(name);
    }

    public void removeReportStream(String name) {
        this.reportStreamMap.remove(name);
    }

    public void clearReportStreams() {
        this.reportStreamMap.clear();
    }

    public void setRootOperator(ProcessRootOperator root) {
        if (this.rootOperator != null) {
            this.rootOperator.removeObserver(this.delegatingOperatorObserver);
        }
        this.rootOperator = root;
        this.rootOperator.addObserver(this.delegatingOperatorObserver, false);
        this.operatorNameMap.clear();
        this.rootOperator.setProcess(this);
    }

    public ProcessRootOperator getRootOperator() {
        return this.rootOperator;
    }

    public Operator getOperator(String name) {
        return this.operatorNameMap.get(name);
    }

    public Operator getCurrentOperator() {
        return this.currentOperator;
    }

    public Collection<Operator> getAllOperators() {
        List<Operator> result = this.rootOperator.getAllInnerOperators();
        result.add(0, this.rootOperator);
        return result;
    }

    public Collection<String> getAllOperatorNames() {
        LinkedList<String> allNames = new LinkedList<String>();
        for (Operator o : this.getAllOperators()) {
            allNames.add(o.getName());
        }
        return allNames;
    }

    public void setCurrentOperator(Operator operator) {
        this.currentOperator = operator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause(Operator operator, IOContainer iocontainer, int breakpointType) {
        this.setProcessState(1);
        this.fireBreakpointEvent(operator, iocontainer, breakpointType);
        while (this.getProcessState() == 1) {
            Object object = this.breakpointLock;
            synchronized (object) {
                try {
                    this.breakpointLock.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        this.setProcessState(2);
        Object object = this.breakpointLock;
        synchronized (object) {
            this.breakpointLock.notifyAll();
        }
        this.fireResumeEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.setProcessState(0);
        Object object = this.breakpointLock;
        synchronized (object) {
            this.breakpointLock.notifyAll();
        }
    }

    public void pause() {
        this.setProcessState(1);
    }

    public boolean shouldStop() {
        return this.getProcessState() == 0;
    }

    public boolean shouldPause() {
        return this.getProcessState() == 1;
    }

    public void addBreakpointListener(BreakpointListener listener) {
        this.breakpointListeners.add(listener);
    }

    public void removeBreakpointListener(BreakpointListener listener) {
        this.breakpointListeners.remove(listener);
    }

    private void fireBreakpointEvent(Operator operator, IOContainer ioContainer, int location) {
        for (BreakpointListener l : this.breakpointListeners) {
            l.breakpointReached(this, operator, ioContainer, location);
        }
    }

    public void fireResumeEvent() {
        Iterator<BreakpointListener> i = this.breakpointListeners.iterator();
        while (i.hasNext()) {
            i.next().resume();
        }
    }

    public List<UnknownParameterInformation> getUnknownParameters() {
        return this.unknownParameterInformation;
    }

    public void clearUnknownParameters() {
        this.unknownParameterInformation.clear();
    }

    @Deprecated
    public boolean checkExperiment(IOContainer inputContainer) {
        return this.checkProcess(inputContainer);
    }

    public boolean checkProcess(IOContainer inputContainer) {
        this.rootOperator.checkAll();
        return true;
    }

    private final void prepareRun(int logVerbosity) throws OperatorException {
        this.initLogging(logVerbosity);
        this.setProcessState(2);
        this.getLogger().fine("Initialising process setup.");
        RandomGenerator.init(this);
        ResultService.init(this);
        this.clearDataTables();
        this.clearReportStreams();
        this.clearMacros();
        this.clearStorage();
        if (this.getExecutionMode() != ExecutionMode.ONLY_DIRTY) {
            this.getRootOperator().clear(4);
        }
        AttributeFactory.resetNameCounters();
        this.getLogger().fine("Process initialised.");
    }

    protected void loadInitialData() throws UserError {
        ProcessContext context = this.getContext();
        if (context.getInputRepositoryLocations().isEmpty()) {
            return;
        }
        this.getLogger().info("Loading initial data.");
        for (int i = 0; i < context.getInputRepositoryLocations().size(); ++i) {
            RepositoryLocation loc;
            String location = context.getInputRepositoryLocations().get(i);
            if (location == null || location.length() == 0) {
                this.getLogger().fine("Input #" + (i + 1) + " not specified.");
                continue;
            }
            if (i >= this.rootOperator.getSubprocess(0).getInnerSources().getNumberOfPorts()) {
                this.getLogger().warning("No input port available for process input #" + (i + 1) + ": " + location);
                continue;
            }
            OutputPort port = (OutputPort)this.rootOperator.getSubprocess(0).getInnerSources().getPortByIndex(i);
            try {
                loc = this.resolveRepositoryLocation(location);
            }
            catch (MalformedRepositoryLocationException e1) {
                throw e1.makeUserError(this.rootOperator);
            }
            try {
                Entry entry = loc.locateEntry();
                if (entry == null) {
                    throw new UserError((Operator)this.rootOperator, 312, loc, "Entry " + loc + " does not exist.");
                }
                if (!(entry instanceof IOObjectEntry)) {
                    this.getLogger().info("Cannot assigning " + loc + " to input port " + port.getSpec() + ": Repository location does not reference an IOObject entry.");
                    throw new UserError((Operator)this.rootOperator, 312, loc, "Not an IOObject entry.");
                }
                this.getLogger().info("Assigning " + loc + " to input port " + port.getSpec() + ".");
                port.deliver(((IOObjectEntry)entry).retrieveData(null));
                continue;
            }
            catch (RepositoryException e) {
                throw new UserError((Operator)this.rootOperator, (Throwable)e, 312, loc, e.getMessage());
            }
        }
    }

    protected void saveResults() throws UserError {
        ProcessContext context = this.getContext();
        if (context.getOutputRepositoryLocations().isEmpty()) {
            return;
        }
        this.getLogger().info("Saving results.");
        for (int i = 0; i < context.getOutputRepositoryLocations().size(); ++i) {
            RepositoryLocation location;
            String locationStr = context.getOutputRepositoryLocations().get(i);
            if (locationStr == null || locationStr.length() == 0) {
                this.getLogger().fine("Output #" + (i + 1) + " not specified.");
                continue;
            }
            if (i >= this.rootOperator.getSubprocess(0).getInnerSinks().getNumberOfPorts()) {
                this.getLogger().warning("No output port corresponding to process output #" + (i + 1) + ": " + locationStr);
                continue;
            }
            InputPort port = (InputPort)this.rootOperator.getSubprocess(0).getInnerSinks().getPortByIndex(i);
            try {
                location = this.rootOperator.getProcess().resolveRepositoryLocation(locationStr);
            }
            catch (MalformedRepositoryLocationException e1) {
                throw e1.makeUserError(this.rootOperator);
            }
            Object data = port.getDataOrNull();
            if (data == null) {
                this.getLogger().warning("Nothing to store at " + location + ": No results produced at " + port.getSpec() + ".");
                continue;
            }
            try {
                RepositoryAccessor repositoryAccessor = this.getRepositoryAccessor();
                location.setAccessor(repositoryAccessor);
                RepositoryManager.getInstance(repositoryAccessor).store((IOObject)data, location, this.rootOperator);
                continue;
            }
            catch (RepositoryException e) {
                throw new UserError((Operator)this.rootOperator, (Throwable)e, 315, location, e.getMessage());
            }
        }
    }

    public void applyContextMacros() {
        for (Pair<String, String> macro : this.context.getMacros()) {
            this.getLogger().fine("Defining context macro: " + macro.getFirst() + " = " + macro.getSecond() + ".");
            this.getMacroHandler().addMacro(macro.getFirst(), macro.getSecond());
        }
    }

    public final IOContainer run() throws OperatorException {
        return this.run(new IOContainer());
    }

    public final IOContainer run(int logVerbosity) throws OperatorException {
        return this.run(new IOContainer(), logVerbosity);
    }

    public final IOContainer run(IOContainer input) throws OperatorException {
        return this.run(input, -1);
    }

    public final IOContainer run(IOContainer input, int logVerbosity) throws OperatorException {
        return this.run(input, logVerbosity, null);
    }

    @Deprecated
    public final IOContainer run(IOContainer input, boolean unused) throws OperatorException {
        return this.run(input, -1);
    }

    @Deprecated
    public final IOContainer run(IOContainer input, int logVerbosity, boolean cleanUp) throws OperatorException {
        return this.run(input, logVerbosity, null);
    }

    @Deprecated
    public final IOContainer run(IOContainer input, int logVerbosity, boolean cleanUp, Map<String, String> macroMap) throws OperatorException {
        return this.run(input, logVerbosity, macroMap);
    }

    public final IOContainer run(IOContainer input, int logVerbosity, Map<String, String> macroMap) throws OperatorException {
        String name = null;
        if (this.getProcessLocation() != null) {
            name = ((Object)this.getProcessLocation()).toString();
        }
        int myVerbosity = this.rootOperator.getParameterAsInt("logverbosity");
        if (logVerbosity == -1) {
            logVerbosity = 9;
        }
        logVerbosity = Math.min(logVerbosity, myVerbosity);
        this.getLogger().setLevel(WrapperLoggingHandler.LEVELS[logVerbosity]);
        String logFilename = this.rootOperator.getParameter("logfile");
        FileHandler logHandler = null;
        if (logFilename != null) {
            try {
                logHandler = new FileHandler(logFilename);
                logHandler.setFormatter(new SimpleFormatter());
                logHandler.setLevel(Level.ALL);
                this.getLogger().config("Logging process to file " + logFilename);
            }
            catch (Exception e) {
                this.getLogger().warning("Cannot create log file '" + logFilename + "': " + e);
            }
        }
        if (logHandler != null) {
            this.getLogger().addHandler(logHandler);
        }
        this.setProcessState(2);
        this.prepareRun(logVerbosity);
        this.loadInitialData();
        this.applyContextMacros();
        if (macroMap != null) {
            for (Map.Entry<String, String> entry : macroMap.entrySet()) {
                this.getMacroHandler().addMacro(entry.getKey(), entry.getValue());
            }
        }
        long start = System.currentTimeMillis();
        if (name != null) {
            this.getLogger().info("Process " + name + " starts");
        } else {
            this.getLogger().info("Process starts");
        }
        this.getLogger().fine("Process:" + Tools.getLineSeparator() + this.getRootOperator().createProcessTree(3));
        this.rootOperator.processStarts();
        try {
            UsageStatistics.getInstance().count(this, OperatorStatisticsValue.EXECUTION);
            if (input != null) {
                this.rootOperator.deliverInput(Arrays.asList(input.getIOObjects()));
            }
            this.rootOperator.execute();
            this.saveResults();
            IOContainer result = this.rootOperator.getResults();
            long end = System.currentTimeMillis();
            this.getLogger().fine("Process:" + Tools.getLineSeparator() + this.getRootOperator().createProcessTree(3));
            if (name != null) {
                this.getLogger().info("Process " + name + " finished successfully after " + Tools.formatDuration(end - start));
            } else {
                this.getLogger().info("Process finished successfully after " + Tools.formatDuration(end - start));
            }
            IOContainer iOContainer = result;
            return iOContainer;
        }
        catch (OperatorException e) {
            if (e instanceof ProcessStoppedException) {
                Operator op = this.getOperator(((ProcessStoppedException)e).getOperatorName());
                UsageStatistics.getInstance().count(op, OperatorStatisticsValue.STOPPED);
            } else {
                UsageStatistics.getInstance().count(this.getCurrentOperator(), OperatorStatisticsValue.FAILURE);
                if (e instanceof UserError) {
                    UsageStatistics.getInstance().count(((UserError)e).getOperator(), OperatorStatisticsValue.USER_ERROR);
                } else {
                    UsageStatistics.getInstance().count(this.getCurrentOperator(), OperatorStatisticsValue.OPERATOR_EXCEPTION);
                }
            }
            throw e;
        }
        finally {
            this.stop();
            this.tearDown();
            if (logHandler != null) {
                this.getLogger().removeHandler(logHandler);
                ((Handler)logHandler).close();
            }
        }
    }

    private void tearDown() {
        try {
            this.rootOperator.processFinished();
        }
        catch (OperatorException e) {
            this.getLogger().log(Level.WARNING, "Problem during finishing the process: " + e.getMessage(), e);
        }
        this.clearMacros();
        this.clearReportStreams();
        this.clearStorage();
        this.clearUnknownParameters();
        ResultService.close();
    }

    public static Charset getEncoding(String encoding) {
        if (encoding == null && ((encoding = System.getProperty("rapidminer.general.encoding")) == null || encoding.trim().length() == 0)) {
            encoding = "SYSTEM";
        }
        Charset result = null;
        if ("SYSTEM".equals(encoding)) {
            result = Charset.defaultCharset();
        } else {
            try {
                result = Charset.forName(encoding);
            }
            catch (IllegalCharsetNameException e) {
                result = Charset.defaultCharset();
            }
            catch (UnsupportedCharsetException e) {
                result = Charset.defaultCharset();
            }
            catch (IllegalArgumentException e) {
                result = Charset.defaultCharset();
            }
        }
        return result;
    }

    public void save() throws IOException {
        if (this.processLocation == null) {
            throw new IOException("No process location is specified.");
        }
        this.isProcessConverted = false;
        this.processLocation.store(this, null);
    }

    public void save(File file) throws IOException {
        new FileProcessLocation(file).store(this, null);
    }

    public File resolveFileName(String name) {
        File absolute = new File(name);
        if (absolute.isAbsolute()) {
            return absolute;
        }
        if (this.processLocation instanceof FileProcessLocation) {
            File processFile = ((FileProcessLocation)this.processLocation).getFile();
            return Tools.getFile(processFile.getParentFile(), name);
        }
        String resolvedir = System.getProperty("rapidminer.test.resolvedir");
        String homeName = resolvedir == null ? System.getProperty("user.home") : resolvedir;
        if (homeName != null) {
            File file = new File(new File(homeName), name);
            this.getLogger().warning("Process not attached to a file. Resolving against user directory: '" + file + "'.");
            return file;
        }
        this.getLogger().warning("Process not attached to a file. Trying abolute filename '" + name + "'.");
        return new File(name);
    }

    public void readProcess(Reader in) throws XMLException, IOException {
        this.readProcess(in, null);
    }

    public void readProcess(Reader in, ProgressListener progressListener) throws XMLException, IOException {
        Map<String, Operator> nameMapBackup = this.operatorNameMap;
        this.operatorNameMap = new HashMap<String, Operator>();
        if (progressListener != null) {
            progressListener.setTotal(120);
            progressListener.setCompleted(0);
        }
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(in));
            if (progressListener != null) {
                progressListener.setCompleted(20);
            }
            this.unknownParameterInformation.clear();
            XMLImporter xmlImporter = new XMLImporter(progressListener);
            xmlImporter.parse(document, this, this.unknownParameterInformation);
            nameMapBackup = this.operatorNameMap;
            this.rootOperator.clear(31);
        }
        catch (ParserConfigurationException e) {
            throw new XMLException(e.toString(), e);
        }
        catch (SAXException e) {
            throw new XMLException("Cannot parse document: " + e.getMessage(), e);
        }
        finally {
            this.operatorNameMap = nameMapBackup;
            if (progressListener != null) {
                progressListener.complete();
            }
        }
    }

    public String registerName(String name, Operator operator) {
        if (this.operatorNameMap.get(name) != null) {
            String baseName = name;
            int index = baseName.indexOf(" (");
            if (index >= 0) {
                baseName = baseName.substring(0, index);
            }
            int i = 2;
            while (this.operatorNameMap.get(baseName + " (" + i + ")") != null) {
                ++i;
            }
            String newName = baseName + " (" + i + ")";
            this.operatorNameMap.put(newName, operator);
            return newName;
        }
        this.operatorNameMap.put(name, operator);
        return name;
    }

    public void unregisterName(String name) {
        this.operatorNameMap.remove(name);
    }

    public void notifyRenaming(String oldName, String newName) {
        this.rootOperator.notifyRenaming(oldName, newName);
    }

    public String toString() {
        if (this.rootOperator == null) {
            return "empty process";
        }
        return "Process:" + Tools.getLineSeparator() + this.rootOperator.getXML(true);
    }

    public void addProcessSetupListener(ProcessSetupListener listener) {
        this.processSetupListeners.add(ProcessSetupListener.class, listener);
    }

    public void removeProcessSetupListener(ProcessSetupListener listener) {
        this.processSetupListeners.remove(ProcessSetupListener.class, listener);
    }

    public void fireOperatorAdded(Operator operator) {
        for (ProcessSetupListener l : (ProcessSetupListener[])this.processSetupListeners.getListeners(ProcessSetupListener.class)) {
            l.operatorAdded(operator);
        }
    }

    public void fireOperatorChanged(Operator operator) {
        for (ProcessSetupListener l : (ProcessSetupListener[])this.processSetupListeners.getListeners(ProcessSetupListener.class)) {
            l.operatorChanged(operator);
        }
    }

    public void fireOperatorRemoved(Operator operator, int oldIndex, int oldIndexAmongEnabled) {
        for (ProcessSetupListener l : (ProcessSetupListener[])this.processSetupListeners.getListeners(ProcessSetupListener.class)) {
            l.operatorRemoved(operator, oldIndex, oldIndexAmongEnabled);
        }
    }

    public void fireExecutionOrderChanged(ExecutionUnit unit) {
        for (ProcessSetupListener l : (ProcessSetupListener[])this.processSetupListeners.getListeners(ProcessSetupListener.class)) {
            l.executionOrderChanged(unit);
        }
    }

    public ExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    public void setExecutionMode(ExecutionMode mode) {
        this.executionMode = mode;
    }

    public DebugMode getDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(DebugMode mode) {
        this.debugMode = mode;
        if (mode == DebugMode.DEBUG_OFF) {
            this.getRootOperator().clear(16);
        }
    }

    public RepositoryLocation resolveRepositoryLocation(String loc) throws UserError, MalformedRepositoryLocationException {
        if (RepositoryLocation.isAbsolute(loc)) {
            RepositoryLocation repositoryLocation = new RepositoryLocation(loc);
            repositoryLocation.setAccessor(this.getRepositoryAccessor());
            return repositoryLocation;
        }
        RepositoryLocation repositoryLocation = this.getRepositoryLocation();
        if (repositoryLocation != null) {
            RepositoryLocation repositoryLocation2 = new RepositoryLocation(repositoryLocation.parent(), loc);
            repositoryLocation2.setAccessor(this.getRepositoryAccessor());
            return repositoryLocation2;
        }
        throw new UserError(null, 317, loc);
    }

    public String makeRelativeRepositoryLocation(RepositoryLocation loc) {
        RepositoryLocation repositoryLocation = this.getRepositoryLocation();
        if (repositoryLocation != null) {
            return loc.makeRelative(repositoryLocation.parent());
        }
        return loc.getAbsoluteLocation();
    }

    public void setContext(ProcessContext context) {
        if (this.context != null) {
            this.context.removeObserver(this.delegatingContextObserver);
        }
        this.context = context;
        this.context.addObserver(this.delegatingContextObserver, false);
        this.fireUpdate();
    }

    public ProcessContext getContext() {
        return this.context;
    }

    public void setImportMessage(String importMessage) {
        this.importMessage = importMessage;
    }

    public boolean isProcessConverted() {
        return this.isProcessConverted;
    }

    public void setProcessConverted(boolean isProcessConverted) {
        this.isProcessConverted = isProcessConverted;
    }

    public String getImportMessage() {
        return this.importMessage;
    }

    public boolean hasSaveDestination() {
        return this.processLocation != null;
    }

    @Deprecated
    public File getExperimentFile() {
        return this.getProcessFile();
    }

    @Deprecated
    public File getProcessFile() {
        if (this.processLocation instanceof FileProcessLocation) {
            return ((FileProcessLocation)this.processLocation).getFile();
        }
        return null;
    }

    @Deprecated
    public void setExperimentFile(File file) {
        this.setProcessLocation(new FileProcessLocation(file));
    }

    public void setProcessFile(File file) {
        this.setProcessLocation(new FileProcessLocation(file));
    }

    public void setProcessLocation(ProcessLocation processLocation) {
        if (this.processLocation != null && !this.processLocation.equals(processLocation)) {
            this.isProcessConverted = false;
        }
        if (this.processLocation != null) {
            this.getLogger().info("Decoupling process from location " + this.processLocation + ". Process is now associated with file " + processLocation + ".");
            this.processLocation = null;
        }
        this.processLocation = processLocation;
        this.fireUpdate();
    }

    public ProcessLocation getProcessLocation() {
        return this.processLocation;
    }

    public RepositoryLocation getRepositoryLocation() {
        if (this.processLocation instanceof RepositoryProcessLocation) {
            return ((RepositoryProcessLocation)this.processLocation).getRepositoryLocation();
        }
        return null;
    }

    public void updateNotify() {
        this.fireUpdate(this);
    }

    public RepositoryAccessor getRepositoryAccessor() {
        return this.repositoryAccessor;
    }

    public void setRepositoryAccessor(RepositoryAccessor repositoryAccessor) {
        this.repositoryAccessor = repositoryAccessor;
    }

    public Annotations getAnnotations() {
        return this.annotations;
    }
}

