/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer;

import com.rapidminer.Process;
import com.rapidminer.ProcessLocation;
import com.rapidminer.io.process.XMLImporter;
import com.rapidminer.io.process.XMLTools;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ProgressListener;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.XMLException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import org.w3c.dom.Document;

public class FileProcessLocation
implements ProcessLocation {
    private final File file;

    public FileProcessLocation(File file) {
        this.file = file;
    }

    @Override
    public Process load(ProgressListener l) throws IOException, XMLException {
        if (!this.file.exists()) {
            throw new IOException("Process file '" + this.file + "' does not exist.");
        }
        if (!this.file.canRead()) {
            throw new IOException("Process file '" + this.file + "' is not readable.");
        }
        return new Process(this.file, l);
    }

    @Override
    public String toHistoryFileString() {
        return "file " + this.file.getAbsolutePath();
    }

    @Override
    public String getRawXML() throws IOException {
        return Tools.readOutput(new BufferedReader(new FileReader(this.file)));
    }

    @Override
    public void store(Process process, ProgressListener listener) throws IOException {
        OutputStream out = null;
        try {
            if (listener != null) {
                listener.setCompleted(33);
            }
            Document document = process.getRootOperator().getDOMRepresentation();
            out = new FileOutputStream(this.file);
            XMLTools.stream(document, out, XMLImporter.PROCESS_FILE_CHARSET);
            if (listener != null) {
                listener.setCompleted(100);
            }
            LogService.getRoot().info("Saved process definition file at '" + this.file + "'.");
        }
        catch (XMLException e) {
            throw new IOException("Cannot save process: " + e, e);
        }
        finally {
            if (listener != null) {
                listener.setCompleted(100);
                listener.complete();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public String toMenuString() {
        return this.file.getName();
    }

    public boolean equals(Object o) {
        if (!(o instanceof FileProcessLocation)) {
            return false;
        }
        return ((FileProcessLocation)o).file.equals(this.file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    @Override
    public String toString() {
        return this.file.toString();
    }

    @Override
    public String getShortName() {
        return this.file.getName();
    }
}

