/*
 * Decompiled with CFR 0.152.
 */
package com.rapid_i.deployment.update.client;

import com.rapid_i.Launcher;
import com.rapid_i.deployment.update.client.InMemoryZipFile;
import com.rapid_i.deployment.update.client.ManagedExtension;
import com.rapid_i.deployment.update.client.ProgressReportingInputStream;
import com.rapid_i.deployment.update.client.UpdateDialog;
import com.rapidminer.RapidMiner;
import com.rapidminer.deployment.client.wsimport.PackageDescriptor;
import com.rapidminer.deployment.client.wsimport.UpdateService;
import com.rapidminer.deployment.client.wsimport.UpdateServiceException_Exception;
import com.rapidminer.deployment.client.wsimport.UpdateServiceService;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.io.process.XMLTools;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.ProgressListener;
import com.rapidminer.tools.Tools;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;

public class UpdateManager {
    public static final String PARAMETER_UPDATE_INCREMENTALLY = "rapidminer.update.incremental";
    public static final String PARAMETER_UPDATE_URL = "rapidminer.update.url";
    public static final String PARAMETER_INSTALL_TO_HOME = "rapidminer.update.to_home";
    public static final String UPDATESERVICE_URL = "http://rapidupdate.de:80/UpdateServer";
    private final UpdateService service;
    static final String COMMERCIAL_LICENSE_NAME = "RIC";
    private static UpdateService theService = null;
    private static URI lastUsedUri = null;

    public UpdateManager(UpdateService service) {
        this.service = service;
    }

    public void performUpdates(List<PackageDescriptor> downloadList, ProgressListener progressListener) throws IOException, UpdateServiceException_Exception {
        int i = 0;
        OutputStream out = null;
        try {
            for (PackageDescriptor desc : downloadList) {
                String urlString = this.service.getDownloadURL(desc.getPackageId(), desc.getVersion(), desc.getPlatformName());
                int minProgress = 20 + 80 * i / downloadList.size();
                int maxProgress = 20 + 80 * (i + 1) / downloadList.size();
                boolean incremental = UpdateManager.isIncrementalUpdate();
                if (desc.getPackageTypeName().equals("RAPIDMINER_PLUGIN")) {
                    ManagedExtension extension;
                    String baseVersion;
                    URL url = UpdateManager.getUpdateServerURI(urlString + ((incremental &= (baseVersion = (extension = ManagedExtension.getOrCreate(desc.getPackageId(), desc.getName(), desc.getLicenseName())).getLatestInstalledVersionBefore(desc.getVersion())) != null) ? "?baseVersion=" + URLEncoder.encode(baseVersion, "UTF-8") : "")).toURL();
                    if (incremental) {
                        LogService.getRoot().info("Updating " + desc.getPackageId() + " incrementally.");
                        this.updatePluginIncrementally(extension, this.openStream(url, progressListener, minProgress, maxProgress), baseVersion, desc.getVersion());
                    } else {
                        LogService.getRoot().info("Updating " + desc.getPackageId() + ".");
                        this.updatePlugin(extension, this.openStream(url, progressListener, minProgress, maxProgress), desc.getVersion());
                    }
                    extension.addAndSelectVersion(desc.getVersion());
                } else {
                    URL url = UpdateManager.getUpdateServerURI(urlString + (incremental ? "?baseVersion=" + URLEncoder.encode(RapidMiner.getLongVersion(), "UTF-8") : "")).toURL();
                    LogService.getRoot().info("Updating RapidMiner core.");
                    this.updateRapidMiner(this.openStream(url, progressListener, minProgress, maxProgress), desc.getVersion());
                }
                progressListener.setCompleted(20 + 80 * ++i / downloadList.size());
            }
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        finally {
            progressListener.complete();
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private InputStream openStream(URL url, ProgressListener listener, int minProgress, int maxProgress) throws IOException {
        InputStream urlIn;
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setDoInput(true);
        con.setDoOutput(false);
        String lengthStr = con.getHeaderField("Content-Length");
        try {
            urlIn = con.getInputStream();
        }
        catch (IOException e) {
            throw new IOException(con.getResponseCode() + ": " + con.getResponseMessage(), e);
        }
        if (lengthStr == null || lengthStr.isEmpty()) {
            LogService.getRoot().warning("Server did not send content length.");
            return urlIn;
        }
        try {
            int length = Integer.parseInt(lengthStr);
            return new ProgressReportingInputStream(urlIn, listener, minProgress, maxProgress, length);
        }
        catch (NumberFormatException e) {
            LogService.getRoot().log(Level.WARNING, "Server sent illegal content length: " + lengthStr, e);
            return urlIn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePlugin(ManagedExtension extension, InputStream updateIn, String newVersion) throws IOException {
        File outFile = extension.getDestinationFile(newVersion);
        FileOutputStream out = new FileOutputStream(outFile);
        try {
            Tools.copyStreamSynchronously(updateIn, out, true);
        }
        finally {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException e) {}
        }
    }

    private void updateRapidMiner(InputStream openStream, String version) throws IOException {
        File updateDir = new File(ParameterService.getRapidMinerHome(), "update");
        if (!updateDir.exists() && !updateDir.mkdir()) {
            throw new IOException("Cannot create update directory. Please ensure you have administrator permissions.");
        }
        if (!updateDir.canWrite()) {
            throw new IOException("Cannot write to update directory. Please ensure you have administrator permissions.");
        }
        File updateFile = new File(updateDir, "rmupdate-" + version + ".jar");
        Tools.copyStreamSynchronously(openStream, new FileOutputStream(updateFile), true);
        File ruInstall = new File(ParameterService.getRapidMinerHome(), "RUinstall");
        ZipFile zip = new ZipFile(updateFile);
        Enumeration<? extends ZipEntry> en = zip.entries();
        while (en.hasMoreElements()) {
            File dest;
            File parent;
            ZipEntry entry = en.nextElement();
            if (entry.isDirectory()) continue;
            String name = entry.getName();
            if ("META-INF/UPDATE".equals(name)) {
                Tools.copyStreamSynchronously(zip.getInputStream(entry), new FileOutputStream(new File(updateDir, "UPDATE")), true);
                continue;
            }
            if (name.startsWith("rapidminer/")) {
                name = name.substring("rapidminer/".length());
            }
            if ((parent = (dest = new File(ruInstall, name)).getParentFile()) != null && !parent.exists()) {
                parent.mkdirs();
            }
            Tools.copyStreamSynchronously(zip.getInputStream(entry), new FileOutputStream(dest), true);
        }
        zip.close();
        updateFile.delete();
        LogService.getRoot().info("Prepared RapidMiner for update. Restart required.");
    }

    private void updatePluginIncrementally(ManagedExtension extension, InputStream diffJarIn, String fromVersion, String newVersion) throws IOException {
        String line;
        ByteArrayOutputStream diffJarBuffer = new ByteArrayOutputStream();
        Tools.copyStreamSynchronously(diffJarIn, diffJarBuffer, true);
        LogService.getRoot().fine("Downloaded incremental zip.");
        InMemoryZipFile diffJar = new InMemoryZipFile(diffJarBuffer.toByteArray());
        HashSet<String> toDelete = new HashSet<String>();
        byte[] updateEntry = diffJar.getContents("META-INF/UPDATE");
        if (updateEntry == null) {
            throw new IOException("META-INFO/UPDATE entry missing");
        }
        BufferedReader updateReader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(updateEntry), "UTF-8"));
        while ((line = updateReader.readLine()) != null) {
            String[] split = line.split(" ", 2);
            if (split.length != 2) {
                throw new IOException("Illegal entry in update script: " + line);
            }
            if ("DELETE".equals(split[0])) {
                toDelete.add(split[1].trim());
                continue;
            }
            throw new IOException("Illegal entry in update script: " + line);
        }
        LogService.getRoot().fine("Extracted update script, " + toDelete.size() + " items to delete.");
        HashSet<String> allNames = new HashSet<String>();
        allNames.addAll(diffJar.entryNames());
        Enumeration<JarEntry> e = extension.findArchive(fromVersion).entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            allNames.add(entry.getName());
        }
        LogService.getRoot().info("Extracted entry names, " + allNames.size() + " entries in total.");
        File newFile = extension.getDestinationFile(newVersion);
        ZipOutputStream newJar = new ZipOutputStream(new FileOutputStream(newFile));
        JarFile oldArchive = extension.findArchive();
        for (String name : allNames) {
            if (toDelete.contains(name)) {
                LogService.getRoot().finest("DELETE " + name);
                continue;
            }
            newJar.putNextEntry(new ZipEntry(name));
            if (diffJar.containsEntry(name)) {
                newJar.write(diffJar.getContents(name));
                LogService.getRoot().finest("UPDATE " + name);
            } else {
                ZipEntry oldEntry = ((ZipFile)oldArchive).getEntry(name);
                Tools.copyStreamSynchronously(((ZipFile)oldArchive).getInputStream(oldEntry), newJar, false);
                LogService.getRoot().finest("STORE " + name);
            }
            newJar.closeEntry();
        }
        newJar.finish();
        newJar.close();
    }

    public static String getBaseUrl() {
        String property = System.getProperty(PARAMETER_UPDATE_URL);
        if (property == null) {
            return UPDATESERVICE_URL;
        }
        return property;
    }

    public static URI getUpdateServerURI(String suffix) throws URISyntaxException {
        String property = System.getProperty(PARAMETER_UPDATE_URL);
        if (property == null) {
            return new URI(UPDATESERVICE_URL + suffix);
        }
        return new URI(property + suffix);
    }

    public static boolean isIncrementalUpdate() {
        return !"false".equals(System.getProperty(PARAMETER_UPDATE_INCREMENTALLY));
    }

    public static synchronized UpdateService getService() throws MalformedURLException, URISyntaxException {
        URI uri = UpdateManager.getUpdateServerURI("/UpdateServiceService?wsdl");
        if (theService == null || lastUsedUri != null && !lastUsedUri.equals(uri)) {
            UpdateServiceService uss = new UpdateServiceService(uri.toURL(), new QName("http://ws.update.deployment.rapid_i.com/", "UpdateServiceService"));
            theService = uss.getUpdateServicePort();
        }
        lastUsedUri = uri;
        return theService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveLastUpdateCheckDate() {
        File file = ParameterService.getUserConfigFile("updatecheck.date");
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(file));
            out.println(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Date loadLastUpdateCheckDate() {
        Date date;
        File file = ParameterService.getUserConfigFile("updatecheck.date");
        if (!file.exists()) {
            return null;
        }
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(file));
            String date2 = in.readLine();
            if (date2 == null) {
                Date date3 = null;
                return date3;
            }
            date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(date2);
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.WARNING, "Cannot read last date of update check.", e);
            Date date4 = null;
            return date4;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return date;
    }

    public static void checkForUpdates() {
        String updateProperty = System.getProperty("rapidminer.update.check");
        if (Tools.booleanValue(updateProperty, true)) {
            if (Launcher.isDevelopmentBuild()) {
                LogService.getRoot().config("This is a development build. Ignoring update check.");
                return;
            }
            if (RapidMiner.getExecutionMode() == RapidMiner.ExecutionMode.WEBSTART) {
                LogService.getRoot().config("Ignoring update check in Webstart mode.");
                return;
            }
            boolean check = true;
            final Date lastCheckDate = UpdateManager.loadLastUpdateCheckDate();
            if (lastCheckDate != null) {
                Calendar lastCheck = Calendar.getInstance();
                lastCheck.setTime(lastCheckDate);
                Calendar currentDate = Calendar.getInstance();
                currentDate.add(6, -2);
                if (!lastCheck.before(currentDate)) {
                    check = false;
                    LogService.getRoot().config("Ignoring update check. Last update check was on " + lastCheckDate);
                }
            }
            if (check) {
                new ProgressThread("check_for_updates"){

                    @Override
                    public void run() {
                        boolean updatesExist;
                        XMLGregorianCalendar xmlGregorianCalendar;
                        LogService.getRoot().info("Checking for updates.");
                        if (lastCheckDate != null) {
                            try {
                                xmlGregorianCalendar = XMLTools.getXMLGregorianCalendar(lastCheckDate);
                            }
                            catch (Exception e) {
                                LogService.getRoot().log(Level.WARNING, "Error checking for updates: " + e, e);
                                return;
                            }
                        } else {
                            xmlGregorianCalendar = null;
                        }
                        try {
                            updatesExist = UpdateManager.getService().anyUpdatesSince(xmlGregorianCalendar);
                        }
                        catch (Exception e) {
                            LogService.getRoot().log(Level.WARNING, "Error checking for updates: " + e, e);
                            return;
                        }
                        if (updatesExist) {
                            if (SwingTools.showConfirmDialog("updates_exist", 0, new Object[0]) == 0) {
                                UpdateDialog.showUpdateDialog(new String[0]);
                            } else {
                                UpdateManager.saveLastUpdateCheckDate();
                            }
                        } else {
                            LogService.getRoot().info("No updates since " + lastCheckDate + ".");
                            UpdateManager.saveLastUpdateCheckDate();
                        }
                    }
                }.start();
            }
        }
    }
}

