/*
 * Decompiled with CFR 0.152.
 */
package com.rapid_i.deployment.update.client;

import com.rapid_i.deployment.update.client.ManagedExtension;
import com.rapid_i.deployment.update.client.UpdateDialog;
import com.rapid_i.deployment.update.client.UpdateListCellRenderer;
import com.rapid_i.deployment.update.client.UpdateManager;
import com.rapidminer.RapidMiner;
import com.rapidminer.deployment.client.wsimport.PackageDescriptor;
import com.rapidminer.gui.tools.ExtendedHTMLJEditorPane;
import com.rapidminer.gui.tools.ExtendedJScrollPane;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.tools.Tools;
import com.rapidminer.tools.plugin.Dependency;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class UpdateListPanel
extends JPanel {
    private final Map<PackageDescriptor, Boolean> selectionMap = new HashMap<PackageDescriptor, Boolean>();
    private final Map<PackageDescriptor, List<Dependency>> dependencyMap = new HashMap<PackageDescriptor, List<Dependency>>();
    private final Set<String> purchasedPackages = new HashSet<String>();
    private final UpdateDialog updateDialog;
    private static final long serialVersionUID = 1L;
    private final ExtendedHTMLJEditorPane displayPane = new ExtendedHTMLJEditorPane("text/html", "<html></html>");
    private final JList updateList;
    private final JToggleButton installButton = new JToggleButton(new ResourceAction("update.select", new Object[0]){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent arg0) {
            UpdateListPanel.this.toggleSelection();
        }
    });
    private final PackageListModel listModel = new PackageListModel();
    private final List<PackageDescriptor> descriptors;
    private final JLabel sizeLabel = new JLabel();

    public UpdateListPanel(UpdateDialog dialog, List<PackageDescriptor> descriptors, String[] preselectedExtensions) {
        for (String pE : preselectedExtensions) {
            for (PackageDescriptor desc : descriptors) {
                if (!desc.getPackageId().equals(pE)) continue;
                this.selectionMap.put(desc, true);
            }
        }
        for (PackageDescriptor desc : descriptors) {
            List<Dependency> dep;
            if (desc.getDependencies() == null || (dep = Dependency.parse(desc.getDependencies())).isEmpty()) continue;
            this.dependencyMap.put(desc, dep);
        }
        this.updateDialog = dialog;
        this.displayPane.installDefaultStylesheet();
        this.displayPane.setEditable(false);
        this.descriptors = descriptors;
        this.updateList = new JList(this.listModel);
        this.updateList.setCellRenderer(new UpdateListCellRenderer(this));
        this.updateList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PackageDescriptor desc;
                if (!e.getValueIsAdjusting() && (desc = (PackageDescriptor)UpdateListPanel.this.updateList.getSelectedValue()) != null) {
                    UpdateListPanel.this.displayPane.setText(UpdateListPanel.this.toString(desc));
                    UpdateListPanel.this.installButton.setSelected(UpdateListPanel.this.isSelected(desc));
                }
            }
        });
        this.updateList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    UpdateListPanel.this.toggleSelection();
                }
            }
        });
        this.displayPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
                    try {
                        Desktop.getDesktop().browse(e.getURL().toURI());
                    }
                    catch (Exception e1) {
                        SwingTools.showVerySimpleErrorMessage("cannot_open_browser", new Object[0]);
                    }
                }
            }
        });
        this.updateSize();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 1;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.weighty = 0.3;
        c.insets = new Insets(0, 0, 6, 0);
        ExtendedJScrollPane updateListPane = new ExtendedJScrollPane(this.updateList);
        updateListPane.setPreferredSize(new Dimension(400, 300));
        updateListPane.setBorder(ButtonDialog.createTitledBorder("Available Updates"));
        this.add((Component)updateListPane, c);
        c.weighty = 0.7;
        ExtendedJScrollPane jScrollPane = new ExtendedJScrollPane(this.displayPane);
        jScrollPane.setPreferredSize(new Dimension(400, 300));
        jScrollPane.setBorder(ButtonDialog.createTitledBorder("Description"));
        this.add((Component)jScrollPane, c);
        c.weighty = 0.0;
        this.add((Component)this.sizeLabel, c);
    }

    public AbstractButton getInstallButton() {
        return this.installButton;
    }

    private String toString(PackageDescriptor descriptor) {
        StringBuilder b = new StringBuilder("<html>");
        b.append("<h2>").append(descriptor.getName() + "</h2>");
        Date date = new Date(descriptor.getCreationTime().toGregorianCalendar().getTimeInMillis());
        b.append("<hr noshade=\"true\"/><strong>").append(descriptor.getVersion()).append(", released ").append(Tools.formatDate(date));
        b.append(", ").append(Tools.formatBytes(descriptor.getSize())).append("</strong>");
        if (descriptor.getDependencies() != null && !descriptor.getDependencies().isEmpty()) {
            b.append("<br/>Depends on: " + descriptor.getDependencies());
        }
        b.append("<p>").append(descriptor.getDescription()).append("</p>");
        if ("RIC".equals(descriptor.getLicenseName())) {
            if (this.isPurchased(descriptor)) {
                b.append("<p>You have purchased this package. However, you cannot install this extension with this version of RapidMiner. Please upgrade first.</p>");
            } else {
                try {
                    b.append("<p><a href=" + UpdateManager.getUpdateServerURI("/shop/" + descriptor.getPackageId()).toString() + ">Order this extension.</a></p><p>You cannot install this extension with this pre-release of RapidMiner. Please upgrade first.</p>");
                }
                catch (URISyntaxException e) {
                    // empty catch block
                }
            }
        }
        b.append("</html>");
        return b.toString();
    }

    public boolean isSelected(PackageDescriptor desc) {
        Boolean selected = this.selectionMap.get(desc);
        return selected != null && selected != false;
    }

    private void updateSize() {
        int totalSize = this.getTotalSize();
        if (totalSize > 0) {
            this.sizeLabel.setText("Total download size: " + Tools.formatBytes(totalSize) + " (This may be less, if incremental updates are possible.)");
        } else {
            this.sizeLabel.setText(" ");
        }
    }

    private int getTotalSize() {
        int totalSize = 0;
        for (Map.Entry<PackageDescriptor, Boolean> entry : this.selectionMap.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            totalSize += entry.getKey().getSize();
        }
        return totalSize;
    }

    public void startUpdate() {
        LinkedList<PackageDescriptor> downloadList = new LinkedList<PackageDescriptor>();
        for (Map.Entry<PackageDescriptor, Boolean> entry : this.selectionMap.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            downloadList.add(entry.getKey());
        }
        this.updateDialog.startUpdate(downloadList);
    }

    private boolean isUpToDate(PackageDescriptor desc) {
        ManagedExtension ext = ManagedExtension.get(desc.getPackageId());
        if (ext != null) {
            String remoteVersion = ManagedExtension.normalizeVersion(desc.getVersion());
            String myVersion = ManagedExtension.normalizeVersion(ext.getLatestInstalledVersion());
            return myVersion != null && remoteVersion.compareTo(myVersion) <= 0;
        }
        return false;
    }

    private void toggleSelection() {
        PackageDescriptor desc = (PackageDescriptor)this.updateList.getSelectedValue();
        if (desc != null) {
            boolean select;
            boolean bl = select = !this.isSelected(desc);
            if (this.isUpToDate(desc)) {
                select = false;
            }
            if (desc.getPackageTypeName().equals("RAPIDMINER_PLUGIN")) {
                if (select) {
                    this.resolveDependencies(desc);
                }
            } else if (desc.getPackageTypeName().equals("STAND_ALONE")) {
                String longVersion = RapidMiner.getLongVersion();
                String myVersion = ManagedExtension.normalizeVersion(longVersion);
                String remoteVersion = ManagedExtension.normalizeVersion(desc.getVersion());
                if (myVersion != null && remoteVersion.compareTo(myVersion) <= 0) {
                    select = false;
                }
            }
            if ("RIC".equals(desc.getLicenseName()) && !this.isPurchased(desc)) {
                select = false;
                SwingTools.showMessageDialog("purchase_package", desc.getName());
            }
            this.selectionMap.put(desc, select);
            this.listModel.update(desc);
        }
        this.updateSize();
    }

    private void resolveDependencies(PackageDescriptor desc) {
        List<Dependency> deps = this.dependencyMap.get(desc);
        if (deps != null) {
            block0: for (Dependency dep : deps) {
                for (PackageDescriptor other : this.descriptors) {
                    if (!other.getPackageId().equals(dep.getPluginExtensionId())) continue;
                    Boolean selected = this.selectionMap.get(other);
                    boolean selectedB = selected != null && selected != false;
                    if (selectedB || this.isUpToDate(other)) continue block0;
                    this.selectionMap.put(other, true);
                    this.resolveDependencies(other);
                    continue block0;
                }
            }
        }
    }

    public boolean isPurchased(PackageDescriptor desc) {
        return this.purchasedPackages.contains(desc.getPackageId());
    }

    private final class PackageListModel
    extends AbstractListModel {
        private static final long serialVersionUID = 1L;

        private PackageListModel() {
        }

        @Override
        public Object getElementAt(int index) {
            return UpdateListPanel.this.descriptors.get(index);
        }

        @Override
        public int getSize() {
            return UpdateListPanel.this.descriptors.size();
        }

        private void update(PackageDescriptor descr) {
            int index = UpdateListPanel.this.descriptors.indexOf(descr);
            this.fireContentsChanged(this, index, index);
        }
    }
}

