/*
 * Decompiled with CFR 0.152.
 */
package com.rapid_i.deployment.update.client;

import com.rapid_i.deployment.update.client.ManagedExtension;
import com.rapid_i.deployment.update.client.UpdateListPanel;
import com.rapidminer.RapidMiner;
import com.rapidminer.deployment.client.wsimport.PackageDescriptor;
import com.rapidminer.gui.tools.SwingTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

final class UpdateListCellRenderer
extends JPanel
implements ListCellRenderer {
    private static final Icon SELECTED_ICON = SwingTools.createIcon("16/checkbox.png");
    private static final Icon NON_SELECTED_ICON = SwingTools.createIcon("16/checkbox_unchecked.png");
    private final UpdateListPanel packageDescriptorListPanel;
    private static final long serialVersionUID = 1L;
    private final JLabel selectedLabel = new JLabel();
    private final JLabel label = new JLabel();
    private Map<String, Icon> icons = new HashMap<String, Icon>();

    UpdateListCellRenderer(UpdateListPanel updateListPanel) {
        this.packageDescriptorListPanel = updateListPanel;
        this.setLayout(new FlowLayout(0));
        this.add(this.selectedLabel);
        this.add(this.label);
        this.setOpaque(true);
    }

    private Icon getIcon(PackageDescriptor pd) {
        if (pd.getIcon() == null) {
            return null;
        }
        Icon result = this.icons.get(pd.getPackageId());
        if (result == null) {
            result = new ImageIcon(pd.getIcon());
            this.icons.put(pd.getPackageId(), result);
        }
        return result;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (isSelected) {
            this.setBackground(SwingTools.LIGHT_BLUE);
        } else if (index % 2 == 0) {
            this.setBackground(Color.WHITE);
        } else {
            this.setBackground(SwingTools.LIGHTEST_BLUE);
        }
        PackageDescriptor desc = (PackageDescriptor)value;
        String text = "<html><strong>" + desc.getName() + "</strong> " + desc.getVersion() + "<br/>";
        ManagedExtension ext = ManagedExtension.get(desc.getPackageId());
        boolean upToDate = false;
        if (desc.getPackageTypeName().equals("RAPIDMINER_PLUGIN")) {
            if (ext == null) {
                text = text + "Not installed";
            } else {
                String installed = ext.getLatestInstalledVersion();
                String selected = ext.getSelectedVersion();
                if (installed != null) {
                    boolean bl = upToDate = installed.compareTo(desc.getVersion()) >= 0;
                    text = upToDate ? text + "This package is up to date." : (installed.equals(selected) ? text + "Installed version: " + ext.getSelectedVersion() : text + "Installed version: " + ext.getSelectedVersion() + " (selected version: " + selected + ")");
                } else {
                    text = text + "No version installed.";
                }
            }
        } else if (desc.getPackageTypeName().equals("STAND_ALONE")) {
            String myVersion = RapidMiner.getLongVersion();
            upToDate = ManagedExtension.normalizeVersion(myVersion).compareTo(ManagedExtension.normalizeVersion(desc.getVersion())) >= 0;
            text = upToDate ? text + "This package is up to date." : text + "Installed version: " + myVersion;
        }
        text = text + "</html>";
        this.label.setText(text);
        this.label.setIcon(this.getIcon(desc));
        boolean selected = this.packageDescriptorListPanel.isSelected(desc);
        this.selectedLabel.setIcon(selected ? SELECTED_ICON : NON_SELECTED_ICON);
        SwingTools.setEnabledRecursive(this, !upToDate);
        if ("COMMERCIAL".equals(desc.getLicenseName())) {
            if (this.packageDescriptorListPanel.isPurchased(desc)) {
                this.selectedLabel.setEnabled(true);
            } else {
                this.selectedLabel.setEnabled(false);
            }
        }
        this.label.setForeground(upToDate ? Color.GRAY : Color.BLACK);
        return this;
    }
}

