/*
 * Decompiled with CFR 0.152.
 */
package com.rapid_i.deployment.update.client;

import com.rapid_i.Launcher;
import com.rapid_i.deployment.update.client.ConfirmLicenseDialog;
import com.rapid_i.deployment.update.client.UpdateListPanel;
import com.rapid_i.deployment.update.client.UpdateManager;
import com.rapidminer.deployment.client.wsimport.PackageDescriptor;
import com.rapidminer.deployment.client.wsimport.UpdateService;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.PasswordDialog;
import com.rapidminer.gui.tools.ProgressThread;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import com.rapidminer.tools.GlobalAuthenticator;
import com.rapidminer.tools.LogService;
import java.awt.event.ActionEvent;
import java.net.PasswordAuthentication;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class UpdateDialog
extends ButtonDialog {
    protected static final String PACKAGEID_RAPIDMINER = "rapidminer";
    private static final long serialVersionUID = 1L;
    public static final Action UPDATE_ACTION = new ResourceAction("update_manager", new Object[0]){
        private static final long serialVersionUID = 1L;
        {
            this.setCondition(9, 0);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            UpdateDialog.showUpdateDialog(new String[0]);
        }
    };
    private final UpdateService service;
    private final UpdateListPanel ulp;

    public UpdateDialog(UpdateService service, List<PackageDescriptor> descriptors, String[] preselectedExtensions) {
        super("update", new Object[0]);
        this.service = service;
        this.ulp = new UpdateListPanel(this, descriptors, preselectedExtensions);
        this.layoutDefault((JComponent)this.ulp, this.ulp.getInstallButton(), this.makeOkButton("update.install"), this.makeCloseButton());
    }

    public static void showUpdateDialog(final String ... preselectedExtensions) {
        new ProgressThread("fetching_updates", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                UpdateService serviceTmp;
                this.getProgressListener().setTotal(100);
                this.getProgressListener().setCompleted(10);
                try {
                    serviceTmp = UpdateManager.getService();
                }
                catch (Exception e) {
                    SwingTools.showSimpleErrorMessage("failed_update_server", (Throwable)e, UpdateManager.getBaseUrl());
                    this.getProgressListener().complete();
                    return;
                }
                finally {
                    this.getProgressListener().complete();
                }
                final UpdateService service = serviceTmp;
                try {
                    this.getProgressListener().setCompleted(20);
                    final LinkedList<PackageDescriptor> descriptors = new LinkedList<PackageDescriptor>();
                    if (Launcher.isDevelopmentBuild()) {
                        LogService.getRoot().config("This is a development build. Ignoring update check.");
                    } else {
                        String rmPlatform = Launcher.getPlatform();
                        String latestRMVersion = service.getLatestVersion(UpdateDialog.PACKAGEID_RAPIDMINER, rmPlatform);
                        PackageDescriptor packageInfo = service.getPackageInfo(UpdateDialog.PACKAGEID_RAPIDMINER, latestRMVersion, rmPlatform);
                        if (packageInfo != null) {
                            descriptors.add(packageInfo);
                        }
                    }
                    this.getProgressListener().setCompleted(30);
                    String targetPlatform = "ANY";
                    List<String> extensions = service.getExtensions(UpdateDialog.PACKAGEID_RAPIDMINER);
                    int i = 0;
                    for (String extension : extensions) {
                        String version = service.getLatestVersion(extension, targetPlatform);
                        PackageDescriptor packageInfo = service.getPackageInfo(extension, version, targetPlatform);
                        descriptors.add(packageInfo);
                        this.getProgressListener().setCompleted(30 + 70 * ++i / extensions.size());
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UpdateManager.saveLastUpdateCheckDate();
                            new UpdateDialog(service, descriptors, preselectedExtensions).setVisible(true);
                        }
                    });
                }
                catch (Exception e) {
                    SwingTools.showSimpleErrorMessage("error_during_update", (Throwable)e, e.getMessage());
                }
                finally {
                    this.getProgressListener().complete();
                }
            }
        }.start();
    }

    public void startUpdate(final List<PackageDescriptor> downloadList) {
        new ProgressThread("installing_updates", true){

            @Override
            public void run() {
                try {
                    this.getProgressListener().setTotal(100);
                    this.getProgressListener().setCompleted(10);
                    HashMap<String, String> licenses = new HashMap<String, String>();
                    for (PackageDescriptor desc : downloadList) {
                        String license = (String)licenses.get(desc.getLicenseName());
                        if (license != null) continue;
                        license = UpdateDialog.this.service.getLicenseText(desc.getLicenseName());
                        licenses.put(desc.getLicenseName(), license);
                    }
                    this.getProgressListener().setCompleted(20);
                    LinkedList<PackageDescriptor> acceptedList = new LinkedList<PackageDescriptor>();
                    for (PackageDescriptor desc : downloadList) {
                        if (!ConfirmLicenseDialog.confirm(desc, (String)licenses.get(desc.getLicenseName()))) continue;
                        acceptedList.add(desc);
                    }
                    if (!acceptedList.isEmpty()) {
                        UpdateManager um = new UpdateManager(UpdateDialog.this.service);
                        um.performUpdates(acceptedList, this.getProgressListener());
                        this.getProgressListener().complete();
                        UpdateDialog.this.dispose();
                        if (SwingTools.showConfirmDialog("update.complete_restart", 0, new Object[0]) == 0) {
                            RapidMinerGUI.getMainFrame().exit(true);
                        }
                    } else {
                        this.getProgressListener().complete();
                    }
                }
                catch (Exception e) {
                    SwingTools.showSimpleErrorMessage("error_installing_update", (Throwable)e, e.getMessage());
                }
            }
        }.start();
    }

    @Override
    protected void ok() {
        this.ulp.startUpdate();
    }

    static {
        GlobalAuthenticator.register(new GlobalAuthenticator.URLAuthenticator(){

            @Override
            public PasswordAuthentication getAuthentication(URL url) {
                try {
                    if (url.toString().startsWith(UpdateManager.getUpdateServerURI("").toString())) {
                        return PasswordDialog.getPasswordAuthentication(url.toString(), false, false);
                    }
                    return null;
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }

            @Override
            public String getName() {
                return "UpdateService authenticator.";
            }
        });
    }
}

