/*
 * Decompiled with CFR 0.152.
 */
package com.rapid_i.deployment.update.client;

import com.rapidminer.tools.ProgressListener;
import com.rapidminer.tools.Tools;
import java.io.IOException;
import java.io.OutputStream;

public class ProgressReportingOutputStream
extends OutputStream {
    private OutputStream parent;
    private ProgressListener listener;
    private int showMin;
    private int showMax;
    private int streamLength;
    private int readBytes = 0;
    private int lastReportedValue = Integer.MIN_VALUE;

    public ProgressReportingOutputStream(OutputStream out, ProgressListener listener, int minProgress, int maxProgress, int streamLength) {
        this.parent = out;
        this.listener = listener;
        this.showMin = minProgress;
        this.showMax = maxProgress;
        this.streamLength = streamLength;
    }

    private void report(int increment) {
        if (increment > 0) {
            this.readBytes += increment;
            int completed = this.showMin + (this.showMax - this.showMin) * this.readBytes / this.streamLength;
            if (completed != this.lastReportedValue) {
                this.listener.setCompleted(completed);
                this.listener.setMessage(Tools.formatBytes(this.readBytes) + "/" + Tools.formatBytes(this.streamLength));
                this.lastReportedValue = completed;
            }
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.parent.write(b);
        this.report(1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        int chunkSize = 4096;
        for (int offset = 0; offset < b.length; offset += chunkSize) {
            int chunkLength = Math.min(chunkSize, b.length - offset);
            this.write(b, offset, chunkLength);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.parent.write(b, off, len);
        this.report(len);
    }

    @Override
    public void flush() throws IOException {
        this.parent.flush();
    }

    @Override
    public void close() throws IOException {
        this.parent.close();
    }
}

