/*
 * Decompiled with CFR 0.152.
 */
package com.rapid_i.deployment.update.client;

import com.rapidminer.tools.ProgressListener;
import com.rapidminer.tools.Tools;
import java.io.IOException;
import java.io.InputStream;

public class ProgressReportingInputStream
extends InputStream {
    private InputStream parent;
    private ProgressListener listener;
    private int showMin;
    private int showMax;
    private int streamLength;
    private int readBytes = 0;
    private int lastReportedValue = Integer.MIN_VALUE;

    public ProgressReportingInputStream(InputStream in, ProgressListener listener, int minProgress, int maxProgress, int streamLength) {
        this.parent = in;
        this.listener = listener;
        this.showMin = minProgress;
        this.showMax = maxProgress;
        this.streamLength = streamLength;
    }

    @Override
    public int read() throws IOException {
        int b = this.parent.read();
        this.report(1);
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.parent.read(b, off, len);
        this.report(result);
        return result;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int result = this.parent.read(b);
        this.report(result);
        return result;
    }

    private void report(int increment) {
        if (increment > 0) {
            this.readBytes += increment;
            int completed = this.showMin + (this.showMax - this.showMin) * this.readBytes / this.streamLength;
            if (completed != this.lastReportedValue) {
                if (this.listener != null) {
                    this.listener.setCompleted(completed);
                    this.listener.setMessage(Tools.formatBytes(this.readBytes) + "/" + Tools.formatBytes(this.streamLength));
                }
                this.lastReportedValue = completed;
            }
        }
    }
}

