/*
 * Decompiled with CFR 0.152.
 */
package com.rapid_i.deployment.update.client;

import com.rapid_i.deployment.update.client.LicenseConflictDialog;
import com.rapidminer.io.process.XMLTools;
import com.rapidminer.tools.LogService;
import com.rapidminer.tools.ParameterService;
import com.rapidminer.tools.plugin.Plugin;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.jar.JarFile;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ManagedExtension {
    private static final Map<String, ManagedExtension> MANAGED_EXTENSIONS = new HashMap<String, ManagedExtension>();
    private final SortedSet<String> installedVersions = new TreeSet<String>(new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return ManagedExtension.normalizeVersion(o1).compareTo(ManagedExtension.normalizeVersion(o2));
        }
    });
    private final String packageID;
    private final String name;
    private String selectedVersion;
    private boolean active;
    private boolean installedInHomeDir;
    private final String license;

    private ManagedExtension(Element element, boolean homeDir) {
        this.installedInHomeDir = homeDir;
        this.packageID = XMLTools.getTagContents(element, "id");
        this.name = XMLTools.getTagContents(element, "name");
        this.license = XMLTools.getTagContents(element, "license");
        this.active = Boolean.parseBoolean(XMLTools.getTagContents(element, "active"));
        this.selectedVersion = XMLTools.getTagContents(element, "selected-version");
        NodeList versions = element.getElementsByTagName("installed-version");
        for (int i = 0; i < versions.getLength(); ++i) {
            this.installedVersions.add(((Element)versions.item(i)).getTextContent());
        }
    }

    private ManagedExtension(String id, String name, String license) {
        this.packageID = id;
        this.name = name;
        this.license = license;
        this.selectedVersion = null;
        this.setActive(true);
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getName() {
        return this.name;
    }

    private File findFile() {
        return this.findFile(this.selectedVersion);
    }

    private File findFile(String version) {
        for (File dir : ManagedExtension.getManagedExtensionsDirectories()) {
            File file = new File(dir, this.packageID + "-" + version + ".jar");
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    public JarFile findArchive() throws IOException {
        File findFile = this.findFile();
        return new JarFile(findFile);
    }

    public JarFile findArchive(String version) throws IOException {
        File findFile = this.findFile(version);
        return new JarFile(findFile);
    }

    public String getSelectedVersion() {
        return this.selectedVersion;
    }

    private static File[] getManagedExtensionsDirectories() {
        File local = ManagedExtension.getUserExtensionsDir();
        try {
            File global = ManagedExtension.getGlobalExtensionsDir();
            return new File[]{global, local};
        }
        catch (IOException e) {
            LogService.getRoot().warning("None of the properties rapidminer.init.plugins and rapidminer.home is set. No globally installed extensions will be loaded.");
            return new File[]{local};
        }
    }

    private static File getGlobalExtensionsDir() throws IOException {
        return new File(Plugin.getPluginLocation(), "managed");
    }

    public static File getUserExtensionsDir() {
        return ParameterService.getUserConfigFile("managed");
    }

    private Element toXML(Document doc) {
        Element result = doc.createElement("extension");
        XMLTools.setTagContents(result, "id", this.packageID);
        XMLTools.setTagContents(result, "name", this.name);
        XMLTools.setTagContents(result, "active", "" + this.active);
        XMLTools.setTagContents(result, "license", this.license);
        XMLTools.setTagContents(result, "selected-version", this.getSelectedVersion());
        for (String v : this.installedVersions) {
            Element elem = doc.createElement("installed-version");
            result.appendChild(elem);
            elem.appendChild(doc.createTextNode(v));
        }
        return result;
    }

    private static Document toXML(boolean inHomeDir) throws ParserConfigurationException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element root = doc.createElement("extensions");
        doc.appendChild(root);
        for (ManagedExtension ext : MANAGED_EXTENSIONS.values()) {
            if (ext.installedInHomeDir != inHomeDir) continue;
            root.appendChild(ext.toXML(doc));
        }
        return doc;
    }

    public static void saveConfiguration() {
        try {
            File localDir = ManagedExtension.getUserExtensionsDir();
            if (!localDir.exists()) {
                localDir.mkdirs();
            }
            XMLTools.stream(ManagedExtension.toXML(true), new File(localDir, "extensions.xml"), Charset.forName("UTF-8"));
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.WARNING, "Cannot save local user extensions: " + e, e);
        }
        try {
            File globalDir = ManagedExtension.getGlobalExtensionsDir();
            if (!globalDir.exists()) {
                globalDir.mkdirs();
            }
            XMLTools.stream(ManagedExtension.toXML(false), new File(globalDir, "extensions.xml"), Charset.forName("UTF-8"));
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.WARNING, "Cannot save global extensions: " + e, e);
        }
        LogService.getRoot().config("Saved extension state.");
    }

    private static void readConfiguration() {
        File file;
        MANAGED_EXTENSIONS.clear();
        try {
            file = new File(ManagedExtension.getUserExtensionsDir(), "extensions.xml");
            if (file.exists()) {
                ManagedExtension.parse(XMLTools.parse(file), true);
            }
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.WARNING, "Failed to read local extension state: " + e, e);
        }
        try {
            file = new File(ManagedExtension.getGlobalExtensionsDir(), "extensions.xml");
            if (file.exists()) {
                ManagedExtension.parse(XMLTools.parse(file), false);
            }
        }
        catch (Exception e) {
            LogService.getRoot().log(Level.WARNING, "Failed to read global extension state: " + e, e);
        }
        LogService.getRoot().config("Read extension state.");
    }

    private static void parse(Document parse, boolean inHomeDir) {
        NodeList extensions = parse.getDocumentElement().getElementsByTagName("extension");
        for (int i = 0; i < extensions.getLength(); ++i) {
            ManagedExtension.register(new ManagedExtension((Element)extensions.item(i), inHomeDir));
        }
    }

    private static void register(ManagedExtension ext) {
        MANAGED_EXTENSIONS.put(ext.packageID, ext);
    }

    public static List<File> getActivePluginJars() {
        LinkedList<File> result = new LinkedList<File>();
        for (ManagedExtension ext : MANAGED_EXTENSIONS.values()) {
            File file;
            if (!ext.isActive() || (file = ext.findFile()) == null) continue;
            result.add(file);
        }
        return result;
    }

    public static ManagedExtension get(String packageId) {
        return MANAGED_EXTENSIONS.get(packageId);
    }

    public static ManagedExtension getOrCreate(String packageId, String packageName, String license) {
        ManagedExtension ext = MANAGED_EXTENSIONS.get(packageId);
        if (ext == null) {
            ext = new ManagedExtension(packageId, packageName, license);
            ext.installedInHomeDir = ManagedExtension.isInstallToHome();
            MANAGED_EXTENSIONS.put(packageId, ext);
            ManagedExtension.saveConfiguration();
        }
        return ext;
    }

    public String getPackageId() {
        return this.packageID;
    }

    public void addAndSelectVersion(String version) {
        this.selectedVersion = version;
        this.installedVersions.add(version);
        ManagedExtension.saveConfiguration();
    }

    public File getDestinationFile(String version) throws IOException {
        if (this.installedInHomeDir) {
            return new File(ManagedExtension.getUserExtensionsDir(), this.packageID + "-" + version + ".jar");
        }
        ManagedExtension.makeGlobalManagedExtensionsDir();
        return new File(ManagedExtension.getGlobalExtensionsDir(), this.packageID + "-" + version + ".jar");
    }

    private static void makeGlobalManagedExtensionsDir() throws IOException {
        File managedDir = ManagedExtension.getGlobalExtensionsDir();
        if (!managedDir.exists() && !managedDir.mkdirs()) {
            throw new IOException("Cannot create directory " + managedDir + ". Make sure you have administrator privileges or check property " + "rapidminer.update.to_home" + " in the preferences.");
        }
    }

    private static boolean isInstallToHome() {
        return !"false".equals(System.getProperty("rapidminer.update.to_home"));
    }

    public static void init() {
        ManagedExtension.readConfiguration();
    }

    public static Collection<ManagedExtension> getAll() {
        return MANAGED_EXTENSIONS.values();
    }

    public Set<String> getInstalledVersions() {
        return this.installedVersions;
    }

    public void setSelectedVersion(String version) {
        this.selectedVersion = version;
    }

    public String getLatestInstalledVersionBefore(String version) {
        SortedSet<String> head = this.installedVersions.headSet(version);
        return head.isEmpty() ? null : head.last();
    }

    public String getLatestInstalledVersion() {
        return this.installedVersions.isEmpty() ? null : this.installedVersions.last();
    }

    public static String normalizeVersion(String version) {
        int i;
        if (version == null) {
            return null;
        }
        String[] split = version.split("\\.");
        if (split.length < 3) {
            String[] newSplit = new String[3];
            System.arraycopy(split, 0, newSplit, 0, split.length);
            for (i = split.length; i < newSplit.length; ++i) {
                newSplit[i] = "0";
            }
            split = newSplit;
        }
        StringBuilder result = new StringBuilder();
        for (i = 0; i < split.length; ++i) {
            int desiredLength;
            int lastDigit;
            for (lastDigit = split[i].length() - 1; lastDigit >= 0 && !Character.isDigit(split[i].charAt(lastDigit)); --lastDigit) {
            }
            String letters = split[i].substring(lastDigit + 1);
            String digits = split[i].substring(0, lastDigit + 1);
            int n = desiredLength = i == split.length - 1 ? 3 : 2;
            while (digits.length() < desiredLength) {
                digits = "0" + digits;
            }
            if (i != 0) {
                result.append('.');
            }
            result.append(digits).append(letters);
        }
        return result.toString();
    }

    private static Collection<ManagedExtension> getActiveByLicense(String license) {
        LinkedList<ManagedExtension> result = new LinkedList<ManagedExtension>();
        for (ManagedExtension ext : MANAGED_EXTENSIONS.values()) {
            if (!ext.isActive() || ext.license == null || !ext.license.equals(license)) continue;
            result.add(ext);
        }
        return result;
    }

    static void checkForLicenseConflicts() {
        Collection<ManagedExtension> lgpl = ManagedExtension.getActiveByLicense("GPL");
        Collection<ManagedExtension> comm = ManagedExtension.getActiveByLicense("RIC");
        if (!lgpl.isEmpty() && !comm.isEmpty()) {
            new LicenseConflictDialog(lgpl, comm).setVisible(true);
        }
    }

    public boolean uninstallActiveVersion() {
        File file = this.findFile(this.selectedVersion);
        if (file != null && file.exists()) {
            file.delete();
        }
        this.installedVersions.remove(this.selectedVersion);
        this.selectedVersion = null;
        this.active = false;
        if (this.installedVersions.isEmpty()) {
            MANAGED_EXTENSIONS.remove(this.getPackageId());
        }
        ManagedExtension.saveConfiguration();
        return true;
    }
}

