/*
 * Decompiled with CFR 0.152.
 */
package com.rapid_i.deployment.update.client;

import com.rapid_i.deployment.update.client.ManagedExtension;
import com.rapidminer.gui.RapidMinerGUI;
import com.rapidminer.gui.tools.ResourceAction;
import com.rapidminer.gui.tools.ResourceLabel;
import com.rapidminer.gui.tools.SwingTools;
import com.rapidminer.gui.tools.dialogs.ButtonDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ExtensionDialog
extends ButtonDialog {
    public static final Action MANAGE_EXTENSIONS = new ResourceAction("manage_extensions", new Object[0]){
        private static final long serialVersionUID = 1L;
        {
            this.setCondition(9, 0);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new ExtensionDialog().setVisible(true);
        }
    };
    private static final long serialVersionUID = 1L;
    private boolean changed = false;

    public ExtensionDialog() {
        super("manage_extensions", new Object[0]);
        Collection<ManagedExtension> allExtensions = ManagedExtension.getAll();
        if (allExtensions.isEmpty()) {
            ResourceLabel label = new ResourceLabel("no_extensions_installed", new Object[0]);
            label.setPreferredSize(new Dimension(300, 100));
            this.layoutDefault((JComponent)label, this.makeCloseButton());
        } else {
            final JPanel main = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 23;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            for (final ManagedExtension ext : allExtensions) {
                c.gridwidth = 1;
                c.weightx = 0.7;
                final JCheckBox activate = new JCheckBox(ext.getName());
                main.add((Component)activate, c);
                c.weightx = 0.3;
                c.gridwidth = -1;
                final JComboBox<Object> versionCombo = new JComboBox<Object>(ext.getInstalledVersions().toArray());
                main.add(versionCombo, c);
                final JButton deleteButton = new JButton();
                ResourceAction uninstallAction = new ResourceAction(true, "uninstall_extension", new Object[0]){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (SwingTools.showConfirmDialog("really_uninstall_extension", 0, ext.getName() + " v." + ext.getSelectedVersion()) == 0) {
                            String selectedVersion = ext.getSelectedVersion();
                            if (ext.uninstallActiveVersion()) {
                                activate.setSelected(false);
                                versionCombo.removeItem(selectedVersion);
                                versionCombo.setSelectedIndex(-1);
                                if (ManagedExtension.get(ext.getPackageId()) == null) {
                                    main.remove(activate);
                                    main.remove(versionCombo);
                                    main.remove(deleteButton);
                                }
                            } else {
                                SwingTools.showVerySimpleErrorMessage("error_uninstalling_extension", new Object[0]);
                            }
                            ExtensionDialog.this.changed = true;
                        }
                    }
                };
                deleteButton.setAction(uninstallAction);
                c.gridwidth = 0;
                c.weightx = 0.0;
                main.add((Component)deleteButton, c);
                activate.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ExtensionDialog.this.changed = true;
                        versionCombo.setEnabled(activate.isSelected());
                        ext.setActive(activate.isSelected());
                    }
                });
                versionCombo.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ExtensionDialog.this.changed = true;
                        ext.setSelectedVersion((String)versionCombo.getSelectedItem());
                    }
                });
                activate.setSelected(ext.isActive());
                versionCombo.setEnabled(ext.isActive());
                versionCombo.setSelectedItem(ext.getSelectedVersion());
            }
            c.gridwidth = 0;
            c.weighty = 1.0;
            main.add((Component)new JPanel(), c);
            JScrollPane mainScrollPane = new JScrollPane(main);
            if (mainScrollPane.getPreferredSize().getHeight() < 50.0) {
                mainScrollPane.setPreferredSize(new Dimension((int)mainScrollPane.getPreferredSize().getWidth(), 50));
            }
            this.layoutDefault((JComponent)mainScrollPane, this.makeCloseButton());
        }
        this.changed = false;
    }

    @Override
    protected void close() {
        if (this.changed) {
            ManagedExtension.saveConfiguration();
            if (SwingTools.showConfirmDialog("manage_extensions.restart", 0, new Object[0]) == 0) {
                RapidMinerGUI.getMainFrame().exit(true);
            }
        }
        super.close();
    }
}

