/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.xml;

import com.gentlyweb.properties.Properties;
import com.gentlyweb.properties.PropertyException;
import com.gentlyweb.utils.StringUtils;
import com.gentlyweb.xml.JDOMUtils;
import com.gentlyweb.xml.Xml2HtmlFilter;
import com.gentlyweb.xml.Xml2HtmlModifier;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.StringTokenizer;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;

public class Xml2Html {
    private String elementClass = "element";
    private String attributeClass = "attr";
    private String attrValueClass = "attrValue";
    private String commentClass = "comment";
    private String contentClass = "content";
    private String namespaceClass = "namespace";
    private String piClass = "pi";
    private boolean replaceWhitespace = false;
    private Xml2HtmlFilter filter = null;
    private Xml2HtmlModifier modifier = null;
    private int modifierTypes = 0;
    private Element parentEl = null;

    public Xml2Html() {
    }

    public Xml2Html(Properties props) throws IllegalAccessException, InvocationTargetException, PropertyException {
        if (props == null) {
            return;
        }
        Properties.setPropertiesInObject(this, null, props);
    }

    public String getAsHTML(String str) throws IOException, JDOMException {
        Element root = JDOMUtils.getStringAsElement(str);
        return this.getAsHTML(root);
    }

    public static String htmlizeXML(String str, Properties props) throws IOException, JDOMException, IllegalAccessException, InvocationTargetException, PropertyException {
        Xml2Html htmlizer = new Xml2Html(props);
        return htmlizer.getAsHTML(str);
    }

    public void setModifier(Xml2HtmlModifier modifier, int types) {
        this.modifier = modifier;
        this.modifierTypes = types;
    }

    public void setXml2HtmlModifierTypes(String types) {
        StringTokenizer t = new StringTokenizer(types, ",");
        while (t.hasMoreTokens()) {
            String tok = t.nextToken();
            if (tok.equals("ATTRIBUTE_VALUE")) {
                ++this.modifierTypes;
            }
            if (tok.equals("CONTENT")) {
                this.modifierTypes += 2;
            }
            if (!tok.equals("COMMENT")) continue;
            this.modifierTypes += 4;
        }
    }

    public void setXml2HtmlModifierClassname(String clss) throws ClassCastException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> c = Class.forName(clss);
        Object o = c.newInstance();
        this.modifier = (Xml2HtmlModifier)o;
    }

    public void setXml2HtmlFilterClassname(String clss) throws ClassCastException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> c = Class.forName(clss);
        Object o = c.newInstance();
        this.filter = (Xml2HtmlFilter)o;
    }

    public Xml2HtmlModifier getModifier() {
        return this.modifier;
    }

    public void setFilter(Xml2HtmlFilter filter) {
        this.filter = filter;
    }

    public Xml2HtmlFilter getFilter() {
        return this.filter;
    }

    public boolean isReplaceWhitespace() {
        return this.replaceWhitespace;
    }

    public void setReplaceWhitespace(boolean val) {
        this.replaceWhitespace = val;
    }

    public String getProcessingInstructionClass() {
        return this.piClass;
    }

    public void setProcessingInstructionClass(String c) {
        this.piClass = c;
    }

    public String getNamespaceClass() {
        return this.namespaceClass;
    }

    public void setNamespaceClass(String c) {
        this.namespaceClass = c;
    }

    public String getContentClass() {
        return this.contentClass;
    }

    public void setContentClass(String c) {
        this.contentClass = c;
    }

    public String getCommentClass() {
        return this.commentClass;
    }

    public void setCommentClass(String c) {
        this.commentClass = c;
    }

    public String getAttributeValueClass() {
        return this.attrValueClass;
    }

    public void setAttributeValueClass(String c) {
        this.attrValueClass = c;
    }

    public String getAttributeClass() {
        return this.attributeClass;
    }

    public void setAttributeClass(String c) {
        this.attributeClass = c;
    }

    public String getElementClass() {
        return this.elementClass;
    }

    public void setElementClass(String c) {
        this.elementClass = c;
    }

    public String getAsHTML(File file, String zipExtension) throws IOException, JDOMException {
        Element el = JDOMUtils.getFileAsElement(file, zipExtension);
        return this.getAsHTML(el.getDocument());
    }

    public String getAsHTML(Document doc) {
        StringBuffer buf = new StringBuffer();
        DocType docType = doc.getDocType();
        if (docType != null) {
            buf.append(this.getAsHTML(docType));
            buf.append("<br />");
        }
        List content = doc.getContent();
        for (int i = 0; i < content.size(); ++i) {
            Object o = content.get(i);
            if (o instanceof ProcessingInstruction) {
                buf.append(this.getAsHTML((ProcessingInstruction)o));
                buf.append("<br />");
            }
            if (o instanceof Element) {
                buf.append(this.getAsHTML((Element)o));
            }
            if (!(o instanceof Comment)) continue;
            buf.append(this.getAsHTML((Comment)o));
            buf.append("<br />");
        }
        return buf.toString();
    }

    public String getAsHTML(DocType t) {
        StringBuffer buf = new StringBuffer();
        buf.append("<b>&lt;!DOCTYPE</b> <span class=\"");
        buf.append(this.elementClass);
        buf.append("\">");
        buf.append(t.getElementName());
        buf.append("</span> <b>");
        if (!t.getSystemID().equals("")) {
            buf.append("SYSTEM \"");
            buf.append(t.getSystemID());
        }
        if (!t.getPublicID().equals("")) {
            buf.append("PUBLIC \"");
            buf.append(t.getPublicID());
        }
        buf.append("\"></b>");
        return buf.toString();
    }

    public String getAsHTML(Element el) {
        List attrs;
        int i;
        if (this.filter != null && !this.filter.accept(el)) {
            return "";
        }
        this.parentEl = el;
        StringBuffer buf = new StringBuffer();
        buf.append("<b>&lt;</b>");
        if (!el.getNamespacePrefix().equals("")) {
            buf.append("<span class=\"");
            buf.append(this.namespaceClass);
            buf.append("\">");
            buf.append(el.getNamespacePrefix());
            buf.append("</span><b>:</b>");
        }
        buf.append("<span class=\"");
        buf.append(this.elementClass);
        buf.append("\">");
        buf.append(el.getName());
        buf.append("</span>");
        if (el.isRootElement()) {
            List ns = el.getAdditionalNamespaces();
            if (ns.size() > 0) {
                buf.append("&#160;");
            }
            for (i = 0; i < ns.size(); ++i) {
                Namespace n = (Namespace)ns.get(i);
                buf.append("<span class=\"");
                buf.append(this.namespaceClass);
                buf.append("\">xmlns<b>:</b></span><span class=\"");
                buf.append(this.attributeClass);
                buf.append("\">");
                buf.append(n.getPrefix());
                buf.append("</span><b>=\"</b><span class=\"");
                buf.append(this.attrValueClass);
                buf.append("\">");
                buf.append(n.getURI());
                buf.append("</span><b>\"</b>");
                if (i >= ns.size() - 1) continue;
                buf.append("&#160;");
            }
        }
        if ((attrs = el.getAttributes()).size() > 0) {
            buf.append("&#160;");
        }
        for (i = 0; i < attrs.size(); ++i) {
            Attribute a = (Attribute)attrs.get(i);
            buf.append(this.getAsHTML(a));
            if (i >= attrs.size() - 1) continue;
            buf.append("&#160;");
        }
        List content = el.getContent();
        if (content.size() == 0) {
            buf.append(" <b>/</b>");
        }
        buf.append("<b>&gt;</b>");
        for (int i2 = 0; i2 < content.size(); ++i2) {
            Object o = content.get(i2);
            if (o instanceof EntityRef) {
                buf.append(this.getAsHTML((EntityRef)o));
            }
            if (o instanceof CDATA) {
                buf.append(this.getAsHTML((CDATA)o));
            }
            if (o instanceof Element) {
                buf.append(this.getAsHTML((Element)o));
            }
            if (o instanceof Comment) {
                buf.append(this.getAsHTML((Comment)o));
            }
            if (o instanceof ProcessingInstruction) {
                buf.append(this.getAsHTML((ProcessingInstruction)o));
            }
            if (!(o instanceof String)) continue;
            String s = (String)o;
            buf.append("<span class=\"");
            buf.append(this.contentClass);
            buf.append("\">");
            if (this.modifier != null) {
                if ((this.modifierTypes & 2) == 2) {
                    buf.append(this.modifier.modifyContent(s, el));
                } else {
                    buf.append(this.escapeText(s));
                }
            } else {
                buf.append(this.escapeText(s));
            }
            buf.append("</span>");
        }
        if (content.size() > 0) {
            buf.append("<b>&lt;/</b>");
            if (!el.getNamespacePrefix().equals("")) {
                buf.append("<span class=\"");
                buf.append(this.namespaceClass);
                buf.append("\">");
                buf.append(el.getNamespacePrefix());
                buf.append("</span><b>:</b>");
            }
            buf.append("<span class=\"");
            buf.append(this.elementClass);
            buf.append("\">");
            buf.append(el.getName());
            buf.append("</span><b>&gt;</b>");
        }
        this.parentEl = null;
        return buf.toString();
    }

    public String getAsHTML(Attribute a) {
        if (this.filter != null && !this.filter.accept(a)) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        if (!a.getNamespacePrefix().equals("")) {
            buf.append("<span class=\"");
            buf.append(this.namespaceClass);
            buf.append("\">");
            buf.append(a.getNamespacePrefix());
            buf.append("</span><b>:</b>");
        }
        buf.append("<span class=\"");
        buf.append(this.attributeClass);
        buf.append("\">");
        buf.append(a.getName());
        buf.append("</span><b>=\"</b><span class=\"");
        buf.append(this.attrValueClass);
        buf.append("\">");
        if (this.modifier != null) {
            if ((this.modifierTypes & 1) == 1) {
                buf.append(this.modifier.modifyAttributeValue(a.getValue(), a));
            } else {
                buf.append(a.getValue());
            }
        } else {
            buf.append(a.getValue());
        }
        buf.append("</span><b>\"</b>");
        return buf.toString();
    }

    public String getAsHTML(CDATA c) {
        StringBuffer buf = new StringBuffer();
        buf.append("<b>&lt;[</b><span class=\"");
        buf.append(this.elementClass);
        buf.append("\">CDATA</span>");
        buf.append("<b>[</b><span class=\"");
        buf.append(this.contentClass);
        buf.append("\">");
        if (this.modifier != null) {
            if ((this.modifierTypes & 2) == 2) {
                buf.append(this.modifier.modifyContent(c.getText(), this.parentEl));
            } else {
                buf.append(this.escapeText(c.getText()));
            }
        } else {
            buf.append(this.escapeText(c.getText()));
        }
        buf.append("</span><b>]]&gt;</b>");
        this.parentEl = null;
        return buf.toString();
    }

    public String escapeText(String s) {
        String ss = new String(s);
        ss = StringUtils.replaceString(ss, "<", "&lt;");
        ss = StringUtils.replaceString(ss, ">", "&gt;");
        if (this.replaceWhitespace) {
            ss = StringUtils.replaceString(ss, String.valueOf(' '), "&#160;");
            ss = StringUtils.replaceString(ss, String.valueOf('\n'), "<br />");
        }
        return ss;
    }

    public String getAsHTML(ProcessingInstruction pi) {
        StringBuffer buf = new StringBuffer();
        buf.append("<b>&lt;?</b><span class=\"");
        buf.append(this.piClass);
        buf.append("\">");
        buf.append(pi.getTarget());
        buf.append(' ');
        buf.append(pi.getData());
        buf.append("</span><b>?&gt;</b>");
        return buf.toString();
    }

    public String getAsHTML(Comment c) {
        StringBuffer buf = new StringBuffer();
        buf.append("<b>&lt;!--</b> <span class=\"");
        buf.append(this.commentClass);
        buf.append("\">");
        if (this.modifier != null) {
            if ((this.modifierTypes & 4) == 4) {
                Element parent = (Element)c.getParent();
                if (parent != null) {
                    buf.append(this.modifier.modifyComment(c.getText(), parent));
                } else {
                    Document d = c.getDocument();
                    buf.append(this.modifier.modifyComment(c.getText(), d));
                }
            } else {
                buf.append(this.escapeText(c.getText()));
            }
        } else {
            buf.append(this.escapeText(c.getText()));
        }
        buf.append("</span> <b>--></b>");
        return buf.toString();
    }

    public String getAsHTML(EntityRef e) {
        return "";
    }
}

