/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.xml;

import com.gentlyweb.xml.DefaultXmlConverter;
import com.gentlyweb.xml.JDOMXmlOutputter;
import com.gentlyweb.xml.XmlConversionException;
import com.gentlyweb.xml.XmlListConverter;
import com.gentlyweb.xml.XmlMapConverter;
import com.gentlyweb.xml.XmlOutputterException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class JDOMUtils {
    public static final String ID = "id";
    public static final String FIRST = "first";
    public static final String LAST = "last";
    static /* synthetic */ Class class$com$gentlyweb$xml$JDOMXmlOutputter;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$jdom$Element;

    public static String compressXML(String s) throws IOException, JDOMException {
        Element root = JDOMUtils.getStringAsElement(s);
        XMLOutputter out = new XMLOutputter();
        Format f = out.getFormat();
        f.setTextMode(Format.TextMode.TRIM_FULL_WHITE);
        f.setIndent(null);
        StringWriter o = new StringWriter();
        out.output(root, (Writer)o);
        return o.toString();
    }

    public static String prettifyXML(String s) throws IOException, JDOMException {
        Element root = JDOMUtils.getStringAsElement(s);
        XMLOutputter out = new XMLOutputter();
        Format f = out.getFormat();
        f.setTextMode(Format.TextMode.TRIM_FULL_WHITE);
        f.setIndent(null);
        StringWriter o = new StringWriter();
        out.output(root, (Writer)o);
        return o.toString();
    }

    public static String getValueForXPath(Element e, String path) throws JDOMException {
        StringTokenizer t = new StringTokenizer(path, "/");
        String token = "";
        while (t.hasMoreTokens()) {
            token = t.nextToken();
        }
        if (token.startsWith("@")) {
            Attribute attr = JDOMUtils.getAttributeForPath(e, path);
            if (attr == null) {
                return null;
            }
            return attr.getValue();
        }
        Element el = JDOMUtils.getElementForPath(e, path);
        if (el == null) {
            return null;
        }
        return JDOMUtils.getChildContent(el);
    }

    public static void writeObjectToFile(Object o, File file, boolean overWrite) throws IllegalArgumentException, IOException, XmlOutputterException {
        if (o.getClass().isAssignableFrom(class$com$gentlyweb$xml$JDOMXmlOutputter == null ? (class$com$gentlyweb$xml$JDOMXmlOutputter = JDOMUtils.class$("com.gentlyweb.xml.JDOMXmlOutputter")) : class$com$gentlyweb$xml$JDOMXmlOutputter)) {
            throw new IllegalArgumentException("Object does not implement the: " + (class$com$gentlyweb$xml$JDOMXmlOutputter == null ? (class$com$gentlyweb$xml$JDOMXmlOutputter = JDOMUtils.class$("com.gentlyweb.xml.JDOMXmlOutputter")) : class$com$gentlyweb$xml$JDOMXmlOutputter).getName() + " interface.");
        }
        JDOMXmlOutputter obj = (JDOMXmlOutputter)o;
        JDOMUtils.writeElementToFile(obj.getAsJDOMElement(), file, overWrite);
    }

    public static void writeElementToFile(Element root, File file, boolean overWrite) throws IOException {
        if (file.exists() && !overWrite) {
            return;
        }
        XMLOutputter out = new XMLOutputter();
        Format f = out.getFormat();
        f.setEncoding("UTF-8");
        f.setTextMode(Format.TextMode.TRIM_FULL_WHITE);
        f.setIndent(null);
        out.output(root, (OutputStream)new BufferedOutputStream(new FileOutputStream(file)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element getFileAsElement(File file, String zipExtension) throws IOException, JDOMException {
        if (file == null) {
            throw new NullPointerException("No file specified.");
        }
        FilterInputStream fin = null;
        fin = file.getName().endsWith(zipExtension) ? new GZIPInputStream(new BufferedInputStream(new FileInputStream(file))) : new BufferedInputStream(new FileInputStream(file));
        try {
            Element element = new SAXBuilder().build((InputStream)fin).getRootElement();
            return element;
        }
        finally {
            if (fin != null) {
                ((InputStream)fin).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element getStringAsElement(String str) throws IOException, JDOMException {
        BufferedReader bin = new BufferedReader(new StringReader(str));
        try {
            Element element = new SAXBuilder().build((Reader)bin).getRootElement();
            return element;
        }
        finally {
            bin.close();
        }
    }

    public static String getElementAsString(Element el) throws IOException {
        StringWriter sout = new StringWriter();
        PrintWriter pout = new PrintWriter(new BufferedWriter(sout));
        XMLOutputter xout = new XMLOutputter();
        xout.setFormat(Format.getPrettyFormat());
        xout.output(el, (Writer)pout);
        pout.flush();
        pout.close();
        return sout.toString();
    }

    public static Date getAttributeValueAsDate(Element parent, String attrname) throws JDOMException {
        return JDOMUtils.getAttributeValueAsDate(parent, attrname, true);
    }

    public static Date getAttributeValueAsDate(Element parent, String attrname, boolean mustBePresent) throws JDOMException {
        String value = JDOMUtils.getAttributeValue(parent, attrname, mustBePresent);
        if (value.equals("")) {
            return null;
        }
        try {
            return new Date(Long.parseLong(value));
        }
        catch (NumberFormatException nfe) {
            throw new JDOMException(value + " value of attribute: " + JDOMUtils.getPath(parent.getAttribute(attrname)) + " is not a long and cannot be converted to a Date");
        }
    }

    public static boolean getAttributeValueAsBoolean(Element parent, String attrname) throws JDOMException {
        return JDOMUtils.getAttributeValueAsBoolean(parent, attrname, true);
    }

    public static boolean getAttributeValueAsBoolean(Element parent, String attrname, boolean mustBePresent) throws JDOMException {
        String value = JDOMUtils.getAttributeValue(parent, attrname, mustBePresent);
        if (!value.equals("")) {
            return new Boolean(value);
        }
        return false;
    }

    public static int getAttributeValueAsInt(Element parent, String attrname) throws JDOMException {
        return JDOMUtils.getAttributeValueAsInt(parent, attrname, true);
    }

    public static int getAttributeValueAsInt(Element parent, String attrname, boolean mustBePresent) throws JDOMException {
        String value = JDOMUtils.getAttributeValue(parent, attrname, mustBePresent);
        if (value.equals("")) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            throw new JDOMException(value + " value of attribute: " + JDOMUtils.getPath(parent.getAttribute(attrname)) + " is not an integer.");
        }
    }

    public static double getAttributeValueAsDouble(Element parent, String attrname) throws JDOMException {
        return JDOMUtils.getAttributeValueAsDouble(parent, attrname, true);
    }

    public static double getAttributeValueAsDouble(Element parent, String attrname, boolean mustBePresent) throws JDOMException {
        String value = JDOMUtils.getAttributeValue(parent, attrname, mustBePresent);
        if (value.equals("")) {
            return 0.0;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException nfe) {
            throw new JDOMException(value + " value of attribute: " + JDOMUtils.getPath(parent.getAttribute(attrname)) + " is not a double.");
        }
    }

    public static float getAttributeValueAsFloat(Element parent, String attrname, boolean mustBePresent) throws JDOMException {
        String value = JDOMUtils.getAttributeValue(parent, attrname, mustBePresent);
        if (value.equals("")) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException nfe) {
            throw new JDOMException(value + " value of attribute: " + JDOMUtils.getPath(parent.getAttribute(attrname)) + " is not a float.");
        }
    }

    public static float getAttributeValueAsFloat(Element parent, String attrname) throws JDOMException {
        return JDOMUtils.getAttributeValueAsFloat(parent, attrname, true);
    }

    public static String getAttributeValue(Element parent, String attrname) throws JDOMException {
        return JDOMUtils.getAttributeValue(parent, attrname, true);
    }

    public static Attribute getAttribute(Element parent, String attrname, String namespacePrefix, boolean mustBePresent) throws JDOMException {
        List attrs = parent.getAttributes();
        for (int i = 0; i < attrs.size(); ++i) {
            Attribute a = (Attribute)attrs.get(i);
            if (!a.getName().equals(attrname) || !a.getNamespacePrefix().equals(namespacePrefix)) continue;
            return a;
        }
        if (mustBePresent) {
            String err = "";
            if (!namespacePrefix.equals("")) {
                err = ":" + namespacePrefix;
            }
            throw new JDOMException("Element: " + JDOMUtils.getPath(parent) + " does not contain a: " + err + attrname + " attribute");
        }
        return null;
    }

    public static Attribute getAttribute(Element parent, String attrname) throws JDOMException {
        return JDOMUtils.getAttribute(parent, attrname, true);
    }

    public static Attribute getAttribute(Element parent, String attrname, boolean mustBePresent) throws JDOMException {
        String ns = "";
        String n = new String(attrname);
        int index = attrname.indexOf(58);
        if (index != -1) {
            ns = attrname.substring(0, index);
            n = attrname.substring(index + 1);
        }
        return JDOMUtils.getAttribute(parent, n, ns, mustBePresent);
    }

    public static String getAttributeValue(Element parent, String attrname, boolean mustBePresent) throws JDOMException {
        Attribute attr = JDOMUtils.getAttribute(parent, attrname, mustBePresent);
        String attrval = "";
        if (attr != null && (attrval = attr.getValue().trim()).equals("")) {
            throw new JDOMException("Attribute: " + JDOMUtils.getPath(attr) + " does not have a value");
        }
        return attrval;
    }

    public static int getChildElementContentAsInt(Element root, String elname) throws JDOMException {
        String content = JDOMUtils.getChildElementContent(root, elname);
        try {
            return Integer.parseInt(content);
        }
        catch (NumberFormatException nfe) {
            throw new JDOMException(content + " value of: " + JDOMUtils.getPath(root) + " is not an integer");
        }
    }

    public static String getChildContent(Element el) throws JDOMException {
        String content = el.getTextTrim();
        if (content.equals("")) {
            throw new JDOMException("Element: " + JDOMUtils.getPath(el) + " contains no content");
        }
        return content;
    }

    public static String getChildElementContent(Element root, String elname, String namespacePrefix, boolean mustBePresent) throws JDOMException {
        Element el = JDOMUtils.getChildElement(root, elname, namespacePrefix, mustBePresent);
        if (el != null) {
            String content = el.getTextTrim();
            if (content.equals("") && mustBePresent) {
                throw new JDOMException(JDOMUtils.getPath(el) + " contains no content");
            }
            return content;
        }
        return "";
    }

    public static String getChildElementContent(Element root, String elname, boolean mustBePresent) throws JDOMException {
        String ns = "";
        String name = elname;
        int index = elname.indexOf(58);
        if (index != -1) {
            ns = elname.substring(0, index);
            name = elname.substring(index + 1);
        }
        return JDOMUtils.getChildElementContent(root, name, ns, mustBePresent);
    }

    public static String getChildElementContent(Element root, String elname) throws JDOMException {
        return JDOMUtils.getChildElementContent(root, elname, true);
    }

    public static Element getChildElement(Element root, String elname, String namespacePrefix, boolean mustBePresent) throws JDOMException {
        Element el = null;
        List content = root.getContent();
        for (int i = 0; i < content.size(); ++i) {
            Element e;
            Object o = content.get(i);
            if (!(o instanceof Element) || !(e = (Element)o).getName().equals(elname) || !e.getNamespacePrefix().equals(namespacePrefix)) continue;
            el = e;
            break;
        }
        if (el == null && mustBePresent) {
            throw new JDOMException("No: " + elname + " in element: " + JDOMUtils.getPath(root));
        }
        return el;
    }

    public static Element getChildElement(Element root, String elname) throws JDOMException {
        return JDOMUtils.getChildElement(root, elname, true);
    }

    public static Element getChildElement(Element root, String elname, boolean mustBePresent) throws JDOMException {
        String ns = "";
        String name = new String(elname);
        int index = elname.indexOf(58);
        if (index != -1) {
            ns = elname.substring(0, index);
            name = elname.substring(index + 1);
        }
        return JDOMUtils.getChildElement(root, name, ns, mustBePresent);
    }

    public static List getChildElements(Element root, String elname, String namespacePrefix, boolean nonZero) throws JDOMException {
        ArrayList<Element> retData = new ArrayList<Element>();
        List children = root.getContent();
        for (int i = 0; i < children.size(); ++i) {
            Element e;
            Object o = children.get(i);
            if (!(o instanceof Element) || !(e = (Element)o).getName().equals(elname) || !e.getNamespacePrefix().equals(namespacePrefix)) continue;
            retData.add(e);
        }
        if (nonZero && retData.size() == 0) {
            String pref = "";
            if (!namespacePrefix.equals("")) {
                pref = namespacePrefix + ":";
            }
            throw new JDOMException("No: " + pref + elname + " child elements in parent: " + JDOMUtils.getPath(root));
        }
        return retData;
    }

    public static List getChildElements(Element root, String elname, boolean nonZero) throws JDOMException {
        String ns = "";
        String name = new String(elname);
        int index = elname.indexOf(58);
        if (index != -1) {
            ns = elname.substring(0, index);
            name = elname.substring(index + 1);
        }
        return JDOMUtils.getChildElements(root, name, ns, nonZero);
    }

    public static List getChildElementsContent(Element root, String elname, String namespacePrefix, boolean nonZero) throws JDOMException {
        List children = JDOMUtils.getChildElements(root, elname, namespacePrefix, nonZero);
        ArrayList<String> retData = new ArrayList<String>();
        for (int i = 0; i < children.size(); ++i) {
            Element e = (Element)children.get(i);
            retData.add(e.getTextTrim());
        }
        return retData;
    }

    public static List getChildElementsContent(Element root, String elname, boolean nonZero) throws JDOMException {
        String ns = "";
        String name = new String(elname);
        int index = elname.indexOf(58);
        if (index != -1) {
            ns = elname.substring(0, index);
            name = elname.substring(index + 1);
        }
        return JDOMUtils.getChildElementsContent(root, name, ns, nonZero);
    }

    public static List getChildElementSet(Element root, String parentName, String elname, boolean nonZero) throws JDOMException {
        Element el = JDOMUtils.getChildElement(root, parentName, false);
        if (el == null) {
            return new ArrayList();
        }
        List children = JDOMUtils.getChildElements(el, elname, nonZero);
        return children;
    }

    public static List getChildElementContentSet(Element root, String parentName, String elname, boolean nonZero) throws JDOMException {
        Element el = JDOMUtils.getChildElement(root, parentName);
        List children = JDOMUtils.getChildElements(el, elname, nonZero);
        ArrayList<String> retData = new ArrayList<String>();
        for (int i = 0; i < children.size(); ++i) {
            el = (Element)children.get(i);
            retData.add(el.getTextTrim());
        }
        return retData;
    }

    public static void checkName(Element root, String name, boolean isRoot) throws JDOMException {
        String ns = "";
        String n = new String(name);
        int index = name.indexOf(58);
        if (index != -1) {
            ns = name.substring(0, index);
            n = name.substring(index + 1);
        }
        JDOMUtils.checkName(root, n, ns, isRoot);
    }

    public static void checkName(Element root, String name, String namespacePrefix, boolean isRoot) throws JDOMException {
        if (isRoot) {
            if (!root.getName().equals(name)) {
                throw new JDOMException("Exepected element root name to be: " + name);
            }
        } else {
            if (!root.getName().equals(name)) {
                throw new JDOMException("Expected element: " + JDOMUtils.getPath(root) + " to have name: " + namespacePrefix + ":" + name);
            }
            if (!root.getNamespacePrefix().equals(namespacePrefix)) {
                throw new JDOMException("Expected element: " + JDOMUtils.getPath(root) + " to have namespace prefix: " + namespacePrefix);
            }
        }
    }

    public static Element getElementWithId(String attr, String id, List els) {
        for (int i = 0; i < els.size(); ++i) {
            Element el = (Element)els.get(i);
            String aid = null;
            try {
                aid = JDOMUtils.getAttributeValue(el, attr, false);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (aid == null || !aid.equals(id)) continue;
            return el;
        }
        return null;
    }

    private static String getElementPath(Element el, StringBuffer buf) {
        String b = '/' + el.getQualifiedName();
        Parent par = el.getParent();
        if (par != null && par instanceof Element) {
            Element parent = (Element)par;
            try {
                List els = JDOMUtils.getChildElements(parent, el.getName(), true);
                if (els.size() > 1) {
                    for (int i = 0; i < els.size(); ++i) {
                        Element e = (Element)els.get(i);
                        if (e != el) continue;
                        b = b + '[';
                        b = e.getAttribute(ID) != null ? b + JDOMUtils.getAttributeValue(e, ID) : b + (i + 1);
                        b = b + ']';
                    }
                }
            }
            catch (Exception e) {
                b = b + "[err!]";
            }
            buf.insert(0, b);
            return JDOMUtils.getElementPath(parent, buf);
        }
        buf.insert(0, b);
        return buf.toString();
    }

    public static String getPath(Attribute attr) {
        String path = JDOMUtils.getElementPath(attr.getParent(), new StringBuffer());
        return path + "/@" + attr.getQualifiedName();
    }

    public static String getPath(Element el) {
        return JDOMUtils.getElementPath(el, new StringBuffer());
    }

    public static void writeMapToFile(Map map, File file, boolean overWrite) throws IOException, XmlConversionException, XmlOutputterException {
        JDOMUtils.writeElementToFile(JDOMUtils.convertMap(map), file, overWrite);
    }

    public static void writeMapToFile(Map map, File file, boolean overWrite, XmlMapConverter con) throws IOException, XmlConversionException, XmlOutputterException {
        JDOMUtils.writeElementToFile(JDOMUtils.convertMap(map, con), file, overWrite);
    }

    public static Element convertMap(Map map) throws XmlConversionException, XmlOutputterException {
        return JDOMUtils.convertMap(map, new DefaultXmlConverter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element convertMap(Map map, XmlMapConverter con) throws XmlConversionException, XmlOutputterException {
        Element root = new Element("map");
        Map map2 = map;
        synchronized (map2) {
            Iterator iter = map.keySet().iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                Object val = map.get(key);
                Element item = new Element("item");
                Element k = new Element("key");
                k.setAttribute("class", key.getClass().getName());
                if ((class$com$gentlyweb$xml$JDOMXmlOutputter == null ? JDOMUtils.class$("com.gentlyweb.xml.JDOMXmlOutputter") : class$com$gentlyweb$xml$JDOMXmlOutputter).isAssignableFrom(key.getClass())) {
                    k.setAttribute("isXML", Boolean.toString(true));
                    JDOMXmlOutputter xo = (JDOMXmlOutputter)key;
                    k.addContent((Content)xo.getAsJDOMElement());
                } else {
                    k.addContent((Content)new CDATA(con.mapKey(key)));
                }
                item.addContent((Content)k);
                Element v = new Element("value");
                v.setAttribute("class", val.getClass().getName());
                if ((class$com$gentlyweb$xml$JDOMXmlOutputter == null ? JDOMUtils.class$("com.gentlyweb.xml.JDOMXmlOutputter") : class$com$gentlyweb$xml$JDOMXmlOutputter).isAssignableFrom(val.getClass())) {
                    v.setAttribute("isXML", Boolean.toString(true));
                    JDOMXmlOutputter xo = (JDOMXmlOutputter)val;
                    v.addContent((Content)xo.getAsJDOMElement());
                } else {
                    v.addContent((Content)new CDATA(con.mapEntry(val)));
                }
                item.addContent((Content)v);
                root.addContent((Content)item);
            }
        }
        return root;
    }

    public static Element convertList(List list) throws XmlConversionException, XmlOutputterException {
        return JDOMUtils.convertList(list, new DefaultXmlConverter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element convertList(List list, XmlListConverter con) throws XmlConversionException, XmlOutputterException {
        Element root = new Element("list");
        List list2 = list;
        synchronized (list2) {
            for (int i = 0; i < list.size(); ++i) {
                Element item = new Element("item");
                root.addContent((Content)item);
                Object o = list.get(i);
                item.setAttribute("class", o.getClass().getName());
                if ((class$com$gentlyweb$xml$JDOMXmlOutputter == null ? JDOMUtils.class$("com.gentlyweb.xml.JDOMXmlOutputter") : class$com$gentlyweb$xml$JDOMXmlOutputter).isAssignableFrom(o.getClass())) {
                    item.setAttribute("isXML", Boolean.toString(true));
                    JDOMXmlOutputter xo = (JDOMXmlOutputter)o;
                    item.addContent((Content)xo.getAsJDOMElement());
                    continue;
                }
                String v = con.mapEntry(o);
                item.addContent((Content)new CDATA(v));
            }
        }
        return root;
    }

    public static int buildList(Element element, List list) throws JDOMException, XmlConversionException {
        return JDOMUtils.buildList(element, list, new DefaultXmlConverter());
    }

    public static synchronized int buildList(Element element, List list, XmlListConverter con) throws JDOMException, XmlConversionException {
        if (con == null) {
            con = new DefaultXmlConverter();
        }
        List itemEls = JDOMUtils.getChildElements(element, "item", false);
        for (int i = 0; i < itemEls.size(); ++i) {
            Element e = (Element)itemEls.get(i);
            String val = e.getText();
            String clazz = JDOMUtils.getAttributeValue(e, "class", false);
            boolean isXml = JDOMUtils.getAttributeValueAsBoolean(e, "isXML", false);
            Object v = null;
            if (isXml) {
                if (clazz.equals("")) {
                    throw new JDOMException("Attribute: isXML cannot be set to: true if the: class attribute is not specified (path: " + JDOMUtils.getPath(e) + ")");
                }
                List cont = e.getContent();
                if (cont.size() == 0) {
                    throw new JDOMException("Expected: " + JDOMUtils.getPath(e) + " to have a child element as content");
                }
                Element el = null;
                for (int j = 0; j < cont.size(); ++j) {
                    Object o = cont.get(j);
                    if (!(o instanceof Element)) continue;
                    el = (Element)o;
                    break;
                }
                try {
                    v = JDOMUtils.loadObject(clazz, el);
                }
                catch (Exception ex) {
                    throw new XmlConversionException("Unable to create new instance of: " + clazz + " (path: " + JDOMUtils.getPath(e) + ")", ex);
                }
            } else {
                if (clazz.equals("")) {
                    clazz = (class$java$lang$String == null ? JDOMUtils.class$("java.lang.String") : class$java$lang$String).getName();
                }
                v = con.convertEntry(clazz, val);
            }
            list.add(v);
        }
        return itemEls.size();
    }

    public static int buildMap(Element element, Map map) throws JDOMException, XmlConversionException {
        return JDOMUtils.buildMap(element, map, new DefaultXmlConverter());
    }

    public static synchronized int buildMap(Element element, Map map, XmlMapConverter con) throws JDOMException, XmlConversionException {
        if (con == null) {
            con = new DefaultXmlConverter();
        }
        List itemEls = JDOMUtils.getChildElements(element, "item", false);
        for (int i = 0; i < itemEls.size(); ++i) {
            Element e = (Element)itemEls.get(i);
            Element kEl = JDOMUtils.getChildElement(e, "key");
            String clazz = JDOMUtils.getAttributeValue(kEl, "class", false);
            boolean isKXml = JDOMUtils.getAttributeValueAsBoolean(kEl, "isXML", false);
            Object oKey = null;
            if (isKXml) {
                if (clazz.equals("")) {
                    throw new JDOMException("Attribute: isXML cannot be set to: true if the: class attribute is not specified (path: " + JDOMUtils.getPath(kEl) + ")");
                }
                List kCont = kEl.getContent();
                if (kCont.size() == 0) {
                    throw new JDOMException("Expected key: " + JDOMUtils.getPath(kEl) + " to have a child element as content");
                }
                Element el = null;
                for (int j = 0; j < kCont.size(); ++j) {
                    Object o = kCont.get(j);
                    if (!(o instanceof Element)) continue;
                    el = (Element)o;
                    break;
                }
                try {
                    oKey = JDOMUtils.loadObject(clazz, el);
                }
                catch (Exception ex) {
                    throw new XmlConversionException("Unable to create new instance of: " + clazz + " (path: " + JDOMUtils.getPath(kEl) + ")", ex);
                }
            } else {
                String key = JDOMUtils.getChildContent(kEl);
                if (clazz.equals("")) {
                    clazz = (class$java$lang$String == null ? JDOMUtils.class$("java.lang.String") : class$java$lang$String).getName();
                }
                oKey = con.convertKey(clazz, key);
            }
            Element vEl = JDOMUtils.getChildElement(e, "value");
            clazz = JDOMUtils.getAttributeValue(vEl, "class", false);
            boolean isVXml = JDOMUtils.getAttributeValueAsBoolean(vEl, "isXML", false);
            Object oValue = null;
            if (isVXml) {
                if (clazz.equals("")) {
                    throw new JDOMException("Attribute: isXML cannot be set to: true if the: class attribute is not specified (path: " + JDOMUtils.getPath(vEl) + ")");
                }
                List vCont = vEl.getContent();
                if (vCont.size() == 0) {
                    throw new JDOMException("Expected value: " + JDOMUtils.getPath(vEl) + " to have a child element as content");
                }
                Element el = null;
                for (int j = 0; j < vCont.size(); ++j) {
                    Object o = vCont.get(j);
                    if (!(o instanceof Element)) continue;
                    el = (Element)o;
                    break;
                }
                try {
                    oValue = JDOMUtils.loadObject(clazz, el);
                }
                catch (Exception ex) {
                    throw new XmlConversionException("Unable to create new instance of: " + clazz + " (path: " + JDOMUtils.getPath(vEl) + ")", ex);
                }
            } else {
                String value = JDOMUtils.getChildContent(vEl);
                if (clazz.equals("")) {
                    clazz = (class$java$lang$String == null ? JDOMUtils.class$("java.lang.String") : class$java$lang$String).getName();
                }
                oValue = con.convertEntry(clazz, value);
            }
            map.put(oKey, oValue);
        }
        return itemEls.size();
    }

    public static int readMapFromFile(Map map, File file, String zipExtension) throws IOException, JDOMException, XmlConversionException {
        return JDOMUtils.readMapFromFile(map, file, zipExtension, new DefaultXmlConverter());
    }

    public static int readMapFromFile(Map map, File file, String zipExtension, XmlMapConverter con) throws IOException, JDOMException, XmlConversionException {
        if (!file.exists()) {
            return -1;
        }
        Element root = JDOMUtils.getFileAsElement(file, zipExtension);
        JDOMUtils.checkName(root, "map", true);
        return JDOMUtils.buildMap(root, map, con);
    }

    public static void writeListToFile(List list, File file, boolean overWrite) throws IOException, XmlConversionException, XmlOutputterException {
        JDOMUtils.writeListToFile(list, file, overWrite, new DefaultXmlConverter());
    }

    public static void writeListToFile(List list, File file, boolean overWrite, XmlListConverter con) throws IOException, XmlConversionException, XmlOutputterException {
        Element root = JDOMUtils.convertList(list, con);
        JDOMUtils.writeElementToFile(root, file, overWrite);
    }

    public static int readListFromFile(List list, File file, String zipExtension, XmlListConverter con) throws IOException, JDOMException, XmlConversionException {
        if (!file.exists()) {
            return -1;
        }
        Element root = JDOMUtils.getFileAsElement(file, zipExtension);
        return JDOMUtils.buildList(root, list, con);
    }

    public static int readListFromFile(List list, File file, String zipExtension) throws IOException, JDOMException, XmlConversionException {
        return JDOMUtils.readListFromFile(list, file, zipExtension, new DefaultXmlConverter());
    }

    public static Attribute getAttributeForPath(Element el, String path) throws JDOMException {
        StringTokenizer t = new StringTokenizer(path, "/");
        String last = "";
        while (t.hasMoreTokens()) {
            last = t.nextToken();
        }
        if (!last.startsWith("@")) {
            throw new JDOMException("Expected last part of path specification: " + path + " to begin with: @");
        }
        Element e = JDOMUtils.getElementForPath(el, path);
        if (e == null) {
            return null;
        }
        return JDOMUtils.getAttribute(e, last.substring(1), false);
    }

    public static Element getElementForPath(Element el, String path) throws JDOMException {
        if (el == null) {
            return null;
        }
        if (path.equals("")) {
            return el;
        }
        Element wanted = el;
        if (path.startsWith("/")) {
            Parent par;
            while (wanted != null && wanted.getParent() != null && !((par = wanted.getParent()) instanceof Document)) {
                wanted = (Element)par;
            }
            if (path.equals("/")) {
                return wanted;
            }
            if (path.startsWith("/" + wanted.getName())) {
                path = path.substring(("/" + wanted.getName()).length());
            } else {
                return null;
            }
        }
        StringTokenizer t = new StringTokenizer(path, "/");
        while (t.hasMoreTokens()) {
            String part = t.nextToken();
            if (part.startsWith("@")) continue;
            if (part.endsWith("]")) {
                List children;
                int index = part.indexOf(91);
                if (index == -1) {
                    throw new JDOMException("XPath: " + path + " path is not correct, expected to find [ in part: " + part);
                }
                String val = part.substring(index + 1, part.indexOf(93));
                String elName = part.substring(0, index);
                try {
                    int v = Integer.parseInt(val);
                    if (v == 0) {
                        throw new JDOMException("XPath: " + path + " path is not correct, part: " + part + " element index must be 1 or greater.");
                    }
                    children = JDOMUtils.getChildElements(wanted, elName, false);
                    if (children.size() > 1 && v <= children.size()) {
                        wanted = (Element)children.get(v - 1);
                        continue;
                    }
                    return null;
                }
                catch (NumberFormatException nfe) {
                    children = JDOMUtils.getChildElements(wanted, elName, false);
                    if (children.size() == 0) {
                        return null;
                    }
                    if (val.equals(FIRST)) {
                        wanted = (Element)children.get(0);
                        continue;
                    }
                    if (val.equals(LAST)) {
                        wanted = (Element)children.get(children.size() - 1);
                        continue;
                    }
                    String id = ID;
                    index = val.indexOf(58);
                    if (index != -1) {
                        id = val.substring(0, index + 1) + id;
                        val = val.substring(index + 1);
                    }
                    boolean found = false;
                    for (int i = 0; i < children.size(); ++i) {
                        Element e = (Element)children.get(i);
                        if (!val.equals(JDOMUtils.getAttributeValue(e, id, false))) continue;
                        found = true;
                        wanted = e;
                    }
                    if (found) continue;
                    return null;
                }
            }
            wanted = JDOMUtils.getChildElement(wanted, part, false);
        }
        return wanted;
    }

    public static Object loadObject(String clazz, Element el) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> cl = Class.forName(clazz);
        Class[] parmTypes = new Class[]{class$org$jdom$Element == null ? (class$org$jdom$Element = JDOMUtils.class$("org.jdom.Element")) : class$org$jdom$Element};
        Constructor<?> con = cl.getConstructor(parmTypes);
        Object[] args = new Object[]{el};
        return con.newInstance(args);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class XMLConstants {
        public static final String map = "map";
        public static final String item = "item";
        public static final String key = "key";
        public static final String value = "value";
        public static final String list = "list";
        public static final String clazz = "class";
        public static final String isXML = "isXML";
    }
}

