/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.xml;

import com.gentlyweb.xml.JDOMUtils;
import com.gentlyweb.xml.XmlConversionException;
import com.gentlyweb.xml.XmlListConverter;
import com.gentlyweb.xml.XmlMapConverter;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.jdom.Element;

public class DefaultXmlConverter
implements XmlMapConverter,
XmlListConverter {
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$net$InetAddress;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$util$SortedMap;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$org$jdom$Element;
    static /* synthetic */ Class class$java$net$Socket;

    public Object convertKey(String clazz, String key) throws XmlConversionException {
        return this.convertObject(clazz, key);
    }

    public Object convertEntry(String clazz, String entry) throws XmlConversionException {
        return this.convertObject(clazz, entry);
    }

    public Object convertObject(String clazz, String value) throws XmlConversionException {
        try {
            if (clazz.equals((class$java$lang$Short == null ? (class$java$lang$Short = DefaultXmlConverter.class$("java.lang.Short")) : class$java$lang$Short).getName())) {
                return new Short(value);
            }
            if (clazz.equals((class$java$lang$Float == null ? (class$java$lang$Float = DefaultXmlConverter.class$("java.lang.Float")) : class$java$lang$Float).getName())) {
                return new Float(value);
            }
            if (clazz.equals((class$java$lang$Double == null ? (class$java$lang$Double = DefaultXmlConverter.class$("java.lang.Double")) : class$java$lang$Double).getName())) {
                return new Double(value);
            }
            if (clazz.equals((class$java$lang$Byte == null ? (class$java$lang$Byte = DefaultXmlConverter.class$("java.lang.Byte")) : class$java$lang$Byte).getName())) {
                return new Byte(value);
            }
            if (clazz.equals((class$java$lang$Character == null ? (class$java$lang$Character = DefaultXmlConverter.class$("java.lang.Character")) : class$java$lang$Character).getName())) {
                return new Character(value.charAt(0));
            }
            if (clazz.equals((class$java$lang$Boolean == null ? (class$java$lang$Boolean = DefaultXmlConverter.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName())) {
                return new Boolean(value);
            }
            if (clazz.equals((class$java$lang$Integer == null ? (class$java$lang$Integer = DefaultXmlConverter.class$("java.lang.Integer")) : class$java$lang$Integer).getName())) {
                return new Integer(value);
            }
            if (clazz.equals((class$java$lang$Long == null ? (class$java$lang$Long = DefaultXmlConverter.class$("java.lang.Long")) : class$java$lang$Long).getName())) {
                return new Long(value);
            }
        }
        catch (Exception e) {
            throw new XmlConversionException("Unable to convert value to: " + clazz, e);
        }
        if (clazz.equals((class$java$lang$String == null ? (class$java$lang$String = DefaultXmlConverter.class$("java.lang.String")) : class$java$lang$String).getName())) {
            return value;
        }
        if (clazz.equals((class$java$util$List == null ? (class$java$util$List = DefaultXmlConverter.class$("java.util.List")) : class$java$util$List).getName())) {
            return this.convertList(value);
        }
        if (clazz.equals((class$java$net$InetAddress == null ? (class$java$net$InetAddress = DefaultXmlConverter.class$("java.net.InetAddress")) : class$java$net$InetAddress).getName())) {
            return this.convertInetAddress(value);
        }
        if (clazz.equals((class$java$io$File == null ? (class$java$io$File = DefaultXmlConverter.class$("java.io.File")) : class$java$io$File).getName())) {
            return this.convertFile(value);
        }
        if (clazz.equals((class$java$net$URL == null ? (class$java$net$URL = DefaultXmlConverter.class$("java.net.URL")) : class$java$net$URL).getName())) {
            return this.convertURL(value);
        }
        if (clazz.equals((class$java$lang$Class == null ? (class$java$lang$Class = DefaultXmlConverter.class$("java.lang.Class")) : class$java$lang$Class).getName())) {
            return this.convertClass(value);
        }
        if (clazz.equals((class$java$util$SortedMap == null ? (class$java$util$SortedMap = DefaultXmlConverter.class$("java.util.SortedMap")) : class$java$util$SortedMap).getName())) {
            return this.convertSortedMap(value);
        }
        if (clazz.equals((class$java$util$Map == null ? (class$java$util$Map = DefaultXmlConverter.class$("java.util.Map")) : class$java$util$Map).getName())) {
            return this.convertMap(value);
        }
        if (clazz.equals((class$java$util$Date == null ? (class$java$util$Date = DefaultXmlConverter.class$("java.util.Date")) : class$java$util$Date).getName())) {
            return this.convertDate(value);
        }
        if (clazz.equals((class$org$jdom$Element == null ? (class$org$jdom$Element = DefaultXmlConverter.class$("org.jdom.Element")) : class$org$jdom$Element).getName())) {
            return this.convertElement(value);
        }
        if (clazz.equals((class$java$net$Socket == null ? (class$java$net$Socket = DefaultXmlConverter.class$("java.net.Socket")) : class$java$net$Socket).getName())) {
            return this.convertSocket(value);
        }
        return this.convertUnknownObject(clazz, value);
    }

    public Object convertUnknownObject(String c, String v) throws XmlConversionException {
        try {
            Class<?> cl = Class.forName(c);
            Constructor<?> con = null;
            try {
                Class[] parmTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = DefaultXmlConverter.class$("java.lang.String")) : class$java$lang$String};
                con = cl.getConstructor(parmTypes);
            }
            catch (Exception ex) {
                throw new XmlConversionException("Class: " + c + " does not contain a constructor that takes a single: " + (class$java$lang$String == null ? (class$java$lang$String = DefaultXmlConverter.class$("java.lang.String")) : class$java$lang$String).getName() + " argument", ex);
            }
            Object[] args = new Object[]{v};
            return con.newInstance(args);
        }
        catch (Exception e) {
            throw new XmlConversionException("Unable to convert: " + v + " to: " + c, e);
        }
    }

    public InetAddress convertInetAddress(String s) throws XmlConversionException {
        try {
            return InetAddress.getByName(s);
        }
        catch (Exception e) {
            throw new XmlConversionException("Unable to convert: " + s + " to InetAddress", e);
        }
    }

    public URL convertURL(String s) throws XmlConversionException {
        try {
            return new URL(s);
        }
        catch (Exception e) {
            throw new XmlConversionException("Unable to convert: " + s + " to URL", e);
        }
    }

    public File convertFile(String s) throws XmlConversionException {
        return new File(s);
    }

    public Class convertClass(String s) throws XmlConversionException {
        try {
            return Class.forName(s);
        }
        catch (Exception e) {
            throw new XmlConversionException("Unable to convert: " + s + " to Class", e);
        }
    }

    public List convertList(String s) throws XmlConversionException {
        try {
            Element el = JDOMUtils.getStringAsElement(s);
            ArrayList l = new ArrayList();
            JDOMUtils.buildList(el, l, this);
            return l;
        }
        catch (Exception e) {
            throw new XmlConversionException("Unable to convert: " + s + " to List.", e);
        }
    }

    public SortedMap convertSortedMap(String s) throws XmlConversionException {
        try {
            Element el = JDOMUtils.getStringAsElement(s);
            TreeMap m = new TreeMap();
            JDOMUtils.buildMap(el, m, this);
            return m;
        }
        catch (Exception e) {
            throw new XmlConversionException("Unable to convert: " + s + " to SortedMap.", e);
        }
    }

    public Map convertMap(String s) throws XmlConversionException {
        try {
            Element el = JDOMUtils.getStringAsElement(s);
            HashMap m = new HashMap();
            JDOMUtils.buildMap(el, m, this);
            return m;
        }
        catch (Exception e) {
            throw new XmlConversionException("Unable to convert: " + s + " to Map.", e);
        }
    }

    public Socket convertSocket(String s) throws XmlConversionException {
        StringTokenizer t = new StringTokenizer(s, ":");
        if (t.countTokens() != 2) {
            throw new XmlConversionException("Incorrect format for Socket creation: " + s);
        }
        try {
            return new Socket(t.nextToken(), Integer.parseInt(t.nextToken()));
        }
        catch (Exception e) {
            throw new XmlConversionException("Unable to convert: " + s + " to a Socket.", e);
        }
    }

    public Date convertDate(String s) throws XmlConversionException {
        try {
            return new Date(Long.parseLong(s));
        }
        catch (Exception e) {
            throw new XmlConversionException("Unable to convert: " + s + " to a Date.", e);
        }
    }

    public Element convertElement(String s) throws XmlConversionException {
        try {
            return JDOMUtils.getStringAsElement(s);
        }
        catch (Exception e) {
            throw new XmlConversionException("Cannot convert string to JDOM Element", e);
        }
    }

    public String mapKey(Object key) throws XmlConversionException {
        return this.mapObject(key);
    }

    public String mapEntry(Object entry) throws XmlConversionException {
        return this.mapObject(entry);
    }

    public String mapObject(Object o) throws XmlConversionException {
        if (o instanceof Integer || o instanceof Long || o instanceof Byte || o instanceof Float || o instanceof Short || o instanceof Double || o instanceof Boolean || o instanceof Character || o instanceof String) {
            return o.toString();
        }
        if (o instanceof InetAddress) {
            return this.map((InetAddress)o);
        }
        if (o instanceof Socket) {
            return this.map((Socket)o);
        }
        if (o instanceof URL) {
            return this.map((URL)o);
        }
        if (o instanceof List) {
            return this.map((List)o);
        }
        if (o instanceof SortedMap) {
            return this.map((SortedMap)o);
        }
        if (o instanceof Map) {
            return this.map((Map)o);
        }
        if (o instanceof File) {
            return this.map((File)o);
        }
        if (o instanceof Class) {
            return this.map((Class)o);
        }
        if (o instanceof Date) {
            return this.map((Date)o);
        }
        if (o instanceof Element) {
            return this.map((Element)o);
        }
        return this.mapUnknownObject(o);
    }

    public String mapUnknownObject(Object o) throws XmlConversionException {
        return o.toString();
    }

    public String map(InetAddress i) throws XmlConversionException {
        return i.getHostAddress();
    }

    public String map(Socket s) throws XmlConversionException {
        return s.getInetAddress().getHostAddress() + ":" + String.valueOf(s.getPort());
    }

    public String map(URL u) throws XmlConversionException {
        return u.toString();
    }

    public String map(List list) throws XmlConversionException {
        try {
            Element el = JDOMUtils.convertList(list, this);
            return JDOMUtils.getElementAsString(el);
        }
        catch (Exception e) {
            throw new XmlConversionException("Unable to convert List to a String.", e);
        }
    }

    public String map(Map map) throws XmlConversionException {
        try {
            Element el = JDOMUtils.convertMap(map, this);
            return JDOMUtils.getElementAsString(el);
        }
        catch (Exception e) {
            throw new XmlConversionException("Unable to convert Map to a String.", e);
        }
    }

    public String map(Date d) throws XmlConversionException {
        return String.valueOf(d.getTime());
    }

    public String map(Class c) throws XmlConversionException {
        return c.getName();
    }

    public String map(File f) throws XmlConversionException {
        return f.getPath();
    }

    public String map(Element e) throws XmlConversionException {
        try {
            return JDOMUtils.getElementAsString(e);
        }
        catch (Exception ee) {
            throw new XmlConversionException("Unable to convert Element to String.", ee);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

