/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.servlet.formatting;

import com.gentlyweb.servlet.ServletUtils;
import com.gentlyweb.servlet.formatting.FormattingException;
import java.util.List;
import java.util.Map;

public abstract class TableFormatter {
    private int pageSize = 20;
    private int start = 0;
    protected String servletName = "";
    private Map parms = null;
    private String fragment = null;
    private String startID = "";
    private String pageText = "";
    private String pageRightText = null;
    private int resultsSize = 0;
    private String rowDivider = null;

    public abstract int getColumnCount();

    public void setResultsSize(int size) {
        this.resultsSize = size;
    }

    public void setPageRightText(String text) {
        this.pageRightText = text;
    }

    public void setRowDivider(String divider) {
        this.rowDivider = divider;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public String getServletName() {
        return this.servletName;
    }

    public void setServletName(String name) {
        this.servletName = name;
    }

    public Map getParms() {
        return this.parms;
    }

    public void setParms(Map parms) {
        this.parms = parms;
    }

    public void setFragment(String frag) {
        this.fragment = frag;
    }

    public void setPageText(String text) {
        this.pageText = text;
    }

    public void setStartID(String id) {
        this.startID = id;
    }

    public abstract String getFormattedRow(Object var1) throws FormattingException;

    public String format(Object o) throws FormattingException {
        if (o == null) {
            throw new FormattingException("Null object passed.");
        }
        return this.getFormattedRow(o);
    }

    public List getDisplaySlice(List objects) {
        int start = this.start;
        int end = this.start + this.pageSize;
        if (end > objects.size() - 1) {
            end = objects.size();
        }
        if (this.start > objects.size() - 1) {
            start = 0;
        }
        return objects.subList(start, end);
    }

    public String format(List objects) throws FormattingException {
        if (objects == null) {
            throw new FormattingException("Null List passed.");
        }
        if (objects.size() == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        if (this.resultsSize <= 0) {
            this.resultsSize = objects.size();
        }
        if (this.start > this.resultsSize) {
            this.start = 0;
        }
        if (this.start < 0) {
            this.start = 0;
        }
        int pages = 1;
        if (this.resultsSize > this.pageSize) {
            pages = this.resultsSize / this.pageSize;
            if (this.resultsSize % this.pageSize != 0) {
                ++pages;
            }
        }
        int cols = this.getColumnCount();
        for (int i = 0; i < objects.size(); ++i) {
            if (i >= this.pageSize) continue;
            buf.append(this.getFormattedRow(objects.get(i)));
            if (this.rowDivider == null) continue;
            buf.append("<tr><td width=\"100%\" colspan=\"");
            buf.append(cols);
            buf.append("\">");
            buf.append(this.rowDivider);
            buf.append("</td></tr>");
        }
        if (pages > 1) {
            buf.append("<tr><td align=\"left\" colspan=\"");
            buf.append(cols);
            buf.append("\"><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\"><tr><td nowrap=\"nowrap\">");
            if (!this.pageText.equals("")) {
                buf.append(this.pageText);
                buf.append("&#160;");
            }
            int nextPage = -1;
            if (this.start >= this.pageSize) {
                buf.append(this.getPageURL(this.start / this.pageSize - 1, "Previous " + this.pageSize));
                buf.append("&#160;|&#160;");
            }
            for (int j = 0; j < pages; ++j) {
                if (this.start == j * this.pageSize) {
                    buf.append("<b>");
                    buf.append(j + 1);
                    buf.append("</b>");
                    if (j < pages - 1) {
                        nextPage = j + 1;
                    }
                } else {
                    buf.append(this.getPageURL(j, String.valueOf(j + 1)));
                }
                if (j < pages - 1) {
                    buf.append("&#160;|&#160;");
                }
                if (pages <= 20) continue;
                int other = this.resultsSize - 10 * this.pageSize;
                buf.append(this.getPageURL(20, "Next " + other));
            }
            if (nextPage != -1) {
                buf.append("&#160;|&#160;");
                if (nextPage == pages - 1) {
                    int rest = this.resultsSize - nextPage * this.pageSize;
                    buf.append(this.getPageURL(nextPage, "Final " + rest));
                } else {
                    buf.append(this.getPageURL(nextPage, "Next " + this.pageSize));
                }
            }
            buf.append("</td><td width=\"100%\">&#160;</td>");
            if (this.pageRightText != null) {
                buf.append("<td nowrap=\"nowrap\" alight=\"right\">");
                buf.append(this.pageRightText);
                buf.append("</td>");
            }
            buf.append("</tr></table></td></tr>");
        } else if (this.pageRightText != null) {
            buf.append("<tr><td colspan=\"");
            buf.append(cols);
            buf.append("\" width=\"100%\"><table cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"><tr><td width=\"100%\">&#160;</td><td align=\"right\" nowrap=\"nowrap\">");
            buf.append(this.pageRightText);
            buf.append("</td></tr></table></td></tr>");
        }
        return buf.toString();
    }

    private String getPageURL(int page, String id) {
        StringBuffer buf = new StringBuffer("<a href=\"");
        buf.append(this.servletName);
        buf.append("?");
        buf.append(this.startID);
        buf.append("=");
        buf.append(page * this.pageSize);
        if (this.parms != null) {
            if (this.parms.size() > 0) {
                buf.append("&amp;");
            }
            buf.append(ServletUtils.buildRequestString(this.parms));
        }
        if (this.fragment != null) {
            buf.append("#");
            buf.append(this.fragment);
        }
        buf.append("\">");
        buf.append(id);
        buf.append("</a>");
        return buf.toString();
    }
}

