/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.servlet.formatting;

import com.gentlyweb.servlet.formatting.FormattingException;
import com.gentlyweb.servlet.formatting.TableFormatter;
import com.gentlyweb.utils.Accessor;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AnonymousTableFormatter
extends TableFormatter {
    private Map columnAccessorMap = new HashMap();
    private List fields = null;
    private Class clazz = null;
    private NumberFormat nf = null;
    private DateFormat df = null;

    public AnonymousTableFormatter(List fields, Class clazz) throws FormattingException, IllegalArgumentException {
        this.clazz = clazz;
        this.fields = fields;
        for (int i = 0; i < fields.size(); ++i) {
            String f = (String)fields.get(i);
            List l = Accessor.getAccessorChain(f, clazz);
            this.columnAccessorMap.put(f, l);
        }
    }

    public int getColumnCount() {
        return this.fields.size();
    }

    public String getFormattedRow(Object o) throws FormattingException {
        if (!o.getClass().isAssignableFrom(this.clazz)) {
            throw new FormattingException("Expected object of type: " + this.clazz.getName() + ", got: " + o.getClass().getName());
        }
        StringBuffer buf = new StringBuffer("<tr>");
        for (int i = 0; i < this.fields.size(); ++i) {
            String f = (String)this.fields.get(i);
            List chain = (List)this.columnAccessorMap.get(f);
            try {
                buf.append("<td>");
                buf.append(this.getFormattedField(Accessor.getValueFromAccessorChain(o, chain), f));
                buf.append("</td>");
                continue;
            }
            catch (Exception e) {
                throw new FormattingException("Cannot get value for field: " + f + ", root cause: " + e.getMessage(), e);
            }
        }
        buf.append("</tr>");
        return buf.toString();
    }

    public void setNumberFormatter(NumberFormat nf) {
        this.nf = nf;
    }

    public void setDateFormatter(DateFormat df) {
        this.df = df;
    }

    public String getFormattedField(Date val, String columnName) {
        if (this.df != null) {
            return this.df.format(val);
        }
        return val.toString();
    }

    public String getFormattedField(String val, String columnName) {
        return val;
    }

    public String getFormattedField(boolean val, String columnName) {
        return String.valueOf(val);
    }

    public String getFormattedField(long val, String columnName) {
        if (this.nf != null) {
            return this.nf.format(val);
        }
        return String.valueOf(val);
    }

    public String getFormattedField(double val, String columnName) {
        if (this.nf != null) {
            return this.nf.format(val);
        }
        return String.valueOf(val);
    }

    public String getFormattedField(char val, String columnName) {
        return String.valueOf(val);
    }

    public String getFormattedField(float val, String columnName) {
        return String.valueOf(val);
    }

    public String getFormattedField(int val, String columnName) {
        return String.valueOf(val);
    }

    public String getFormattedField(Map vals, String columnName) {
        StringBuffer buf = new StringBuffer();
        Iterator iter = vals.keySet().iterator();
        while (iter.hasNext()) {
            buf.append(this.getFormattedField(iter.next(), columnName));
            buf.append("&#160;[");
            buf.append(this.getFormattedField(vals.get(iter.next()), columnName));
            buf.append("]");
            if (!iter.hasNext()) continue;
            buf.append(",&#160;");
        }
        return buf.toString();
    }

    public String getFormattedField(List vals, String columnName) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < vals.size(); ++i) {
            buf.append(this.getFormattedField(vals.get(i), columnName));
            if (vals.size() - 1 >= i) continue;
            buf.append(",&#160;");
        }
        return buf.toString();
    }

    public String getUnknownTypeField(Object val, String columnName) {
        return val.toString();
    }

    public String getFormattedField(Object val, String columnName) {
        if (val == null) {
            return "null";
        }
        if (val instanceof List) {
            return this.getFormattedField((List)val, columnName);
        }
        if (val instanceof Map) {
            return this.getFormattedField((Map)val, columnName);
        }
        if (val instanceof Integer) {
            return this.getFormattedField((Integer)val, columnName);
        }
        if (val instanceof Float) {
            return this.getFormattedField(((Float)val).floatValue(), columnName);
        }
        if (val instanceof Double) {
            return this.getFormattedField((Double)val, columnName);
        }
        if (val instanceof Character) {
            return this.getFormattedField(((Character)val).charValue(), columnName);
        }
        if (val instanceof Long) {
            return this.getFormattedField((Long)val, columnName);
        }
        if (val instanceof Boolean) {
            return this.getFormattedField((Boolean)val, columnName);
        }
        if (val instanceof Date) {
            return this.getFormattedField((Date)val, columnName);
        }
        if (val instanceof String) {
            return this.getFormattedField((String)val, columnName);
        }
        return this.getUnknownTypeField(val, columnName);
    }
}

