/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.servlet;

import com.gentlyweb.servlet.CookieFilter;
import com.gentlyweb.servlet.Parameters;
import com.gentlyweb.utils.ChainException;
import com.gentlyweb.utils.StringUtils;
import com.oreilly.servlet.MultipartRequest;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletUtils {
    static /* synthetic */ Class class$java$lang$String;

    public static String checkRequestParameter(HttpServletRequest request, String name, String errorName, List errors) {
        boolean found = true;
        String value = request.getParameter(name);
        if (value == null) {
            found = false;
        } else if (value.equals("")) {
            found = false;
        }
        if (!found) {
            errors.add(errorName + " must be given.");
            return null;
        }
        return value;
    }

    public static String checkRequestParameter(Parameters parms, String name, String errorName, List errors) {
        boolean found = true;
        String value = parms.getParameter(name);
        if (value == null) {
            found = false;
        } else if (value.equals("")) {
            found = false;
        }
        if (!found) {
            errors.add(errorName + " must be given.");
            return null;
        }
        return value;
    }

    public static void redirect(HttpServletResponse response, String page) throws IOException {
        response.setStatus(302);
        response.setHeader("Location", page);
    }

    public static String getFormErrors(List errors) {
        if (errors.size() > 0) {
            StringBuffer buf = new StringBuffer("<ul>");
            for (int i = 0; i < errors.size(); ++i) {
                buf.append("<li class=\"ERROR\">");
                buf.append((String)errors.get(i));
                buf.append("</li>");
            }
            buf.append("</ul>");
            return buf.toString();
        }
        return "";
    }

    public static String buildTextArea(MultipartRequest request, String name, String value, int cols, int rows) {
        String v = value;
        String val = request.getParameter(name);
        if (val != null) {
            v = val;
        }
        return ServletUtils.buildTextArea(name, v, cols, rows);
    }

    public static String buildTextArea(String name, String value, int cols, int rows) {
        StringBuffer buf = new StringBuffer("<textarea name=\"");
        buf.append(name);
        buf.append("\" cols=\"");
        buf.append(cols);
        buf.append("\" rows=\"");
        buf.append(rows);
        buf.append("\">");
        if (value != null) {
            buf.append(value.trim());
        }
        buf.append("</textarea>");
        return buf.toString();
    }

    public static String buildTextArea(HttpServletRequest request, String name, String value, int cols, int rows) {
        String v = value;
        String val = request.getParameter(name);
        if (val != null) {
            v = val;
        }
        return ServletUtils.buildTextArea(name, v, cols, rows);
    }

    public static String buildTextArea(HttpServletRequest request, String name, int cols, int rows) {
        return ServletUtils.buildTextArea(request, name, null, cols, rows);
    }

    public static String buildRadioButtonList(MultipartRequest request, String name, List list, int index) {
        String ind = String.valueOf(index);
        String val = request.getParameter(name);
        if (val != null) {
            ind = val;
        }
        return ServletUtils.buildRadioButtonList(name, list, ind);
    }

    public static String buildRadioButtonList(HttpServletRequest request, String name, List list, int index) {
        String ind = String.valueOf(index);
        String val = request.getParameter(name);
        if (val != null) {
            ind = val;
        }
        return ServletUtils.buildRadioButtonList(name, list, ind);
    }

    public static String buildRadioButtonList(String name, List list, String index) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            String ind = String.valueOf(i + 1);
            buf.append("<input type=\"radio\" name=\"");
            buf.append(name);
            buf.append("\" value=\"");
            buf.append(ind);
            buf.append("\" ");
            if (index != null && index.equals(ind)) {
                buf.append("checked=\"checked\"");
            }
            buf.append(" /> ");
            buf.append((String)list.get(i));
            buf.append("<br />");
        }
        return buf.toString();
    }

    public static String buildCheckBox(HttpServletRequest request, String name) {
        return ServletUtils.buildCheckBox(request, name, false);
    }

    public static String buildCheckBox(MultipartRequest request, String name, boolean checked) {
        if (request.getParameter(name) != null) {
            checked = true;
        }
        return ServletUtils.buildCheckBox(name, checked);
    }

    public static String buildCheckBox(HttpServletRequest request, String name, boolean checked) {
        if (request.getParameter(name) != null) {
            checked = true;
        }
        return ServletUtils.buildCheckBox(name, checked);
    }

    public static String buildCheckBox(String name, boolean checked) {
        StringBuffer buf = new StringBuffer("<input type=\"checkbox\" name=\"");
        buf.append(name);
        buf.append("\" ");
        if (checked) {
            buf.append("checked=\"checked\"");
        }
        buf.append(" />");
        return buf.toString();
    }

    public static String buildSelect(HttpServletRequest request, String name, int lower, int upper, int dfault) {
        String val = request.getParameter(name);
        int v = 0;
        if (val != null) {
            try {
                v = Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (lower > upper) {
            lower = upper;
        }
        StringBuffer buf = new StringBuffer("<select name=\"");
        buf.append(name);
        buf.append("\">");
        for (int i = lower; i < upper + 1; ++i) {
            buf.append("<option value=\"");
            buf.append(i);
            buf.append("\"");
            if (val != null) {
                if (i == v) {
                    buf.append(" selected=\"selected\"");
                }
            } else if (i == dfault) {
                buf.append(" selected=\"selected\"");
            }
            buf.append(">");
            buf.append(i);
            buf.append("</option>");
        }
        buf.append("</select>");
        return buf.toString();
    }

    public static String buildSelect(HttpServletRequest request, String name, List values, List dfaults, int selectSize) {
        int size = selectSize;
        if (selectSize > values.size()) {
            size = values.size();
        }
        String[] vals = request.getParameterValues(name);
        StringBuffer buf = new StringBuffer("<select name=\"");
        buf.append(name);
        buf.append("\"");
        if (size > 1) {
            buf.append(" multiple=\"multiple\" size=\"");
            buf.append(size);
            buf.append("\"");
        }
        buf.append(">");
        for (int i = 0; i < values.size(); ++i) {
            int j;
            String value = (String)values.get(i);
            buf.append("<option value=\"");
            buf.append(value);
            buf.append("\"");
            if (vals != null) {
                for (j = 0; j < vals.length; ++j) {
                    if (!value.equals(vals[j])) continue;
                    buf.append(" selected=\"selected\"");
                    break;
                }
            } else if (dfaults != null) {
                for (j = 0; j < dfaults.size(); ++j) {
                    if (!value.equals((String)dfaults.get(j))) continue;
                    buf.append(" selected=\"selected\"");
                    break;
                }
            }
            buf.append(">");
            buf.append(value);
            buf.append("</option>");
        }
        buf.append("</select>");
        return buf.toString();
    }

    public static String buildSelect(HttpServletRequest request, String name, List values, String dfault) {
        ArrayList<String> l = new ArrayList<String>();
        if (dfault != null) {
            l.add(dfault);
        }
        return ServletUtils.buildSelect(request, name, values, l, -1);
    }

    public static String buildFileInputBox(MultipartRequest request, String name, int size) {
        return ServletUtils.buildFileInputBox(name, request.getParameter(name), size);
    }

    public static String buildFileInputBox(String name, String value, int size) {
        StringBuffer buf = new StringBuffer("<input type=\"file\" name=\"");
        buf.append(name);
        buf.append("\" size=\"");
        buf.append(size);
        buf.append("\"");
        if (value != null) {
            buf.append(" value=\"");
            buf.append(value.trim());
            buf.append("\"");
        }
        buf.append(" />");
        return buf.toString();
    }

    public static String buildFileInputBox(HttpServletRequest request, String name, int size) {
        return ServletUtils.buildFileInputBox(name, request.getParameter(name), size);
    }

    public static String buildTextBox(HttpServletRequest request, String name, String value, int size) {
        StringBuffer buf = new StringBuffer("<input type=\"text\" name=\"");
        buf.append(name);
        buf.append("\" size=\"");
        buf.append(size);
        buf.append("\"");
        String val = request.getParameter(name);
        if (val != null) {
            buf.append(" value=\"");
            buf.append(StringUtils.replaceString(val, "\"", "&quot;"));
            buf.append("\"");
        } else if (value != null) {
            String newval = "";
            newval = StringUtils.replaceString(value, "\"", "&quot;");
            buf.append(" value=\"");
            buf.append(newval);
            buf.append("\"");
        }
        buf.append(" />");
        return buf.toString();
    }

    public static String buildTextBox(HttpServletRequest request, String name, int size) {
        return ServletUtils.buildTextBox(request, name, null, size);
    }

    public static String buildPasswordBox(String name, int size) {
        StringBuffer buf = new StringBuffer("<input type=\"password\" name=\"");
        buf.append(name);
        buf.append("\" size=\"");
        buf.append(size);
        buf.append("\"");
        buf.append(" />");
        return buf.toString();
    }

    public static List getCookiesAsObjects(Cookie[] cookies, Class clazz, CookieFilter cookieFilter, String vPairDelimiter, String nvPairDelimiter, boolean valueURLEncoded) throws ChainException, InstantiationException, IllegalAccessException, InvocationTargetException {
        ArrayList retData = new ArrayList();
        if (cookies == null) {
            return retData;
        }
        Class[] parmTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ServletUtils.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ServletUtils.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ServletUtils.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ServletUtils.class$("java.lang.String")) : class$java$lang$String};
        Constructor con = null;
        try {
            con = clazz.getConstructor(parmTypes);
        }
        catch (Exception e) {
            throw new ChainException("Cannot find/access a constructor in class: " + clazz.getName() + " with signature (String,String,String,String)", e);
        }
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            if (cookieFilter != null && !cookieFilter.accept(cookie)) continue;
            String name = cookie.getName();
            String value = cookie.getValue();
            if (valueURLEncoded) {
                try {
                    value = URLDecoder.decode(value, "utf-8");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            Object[] args = new Object[]{name, value, vPairDelimiter, nvPairDelimiter};
            retData.add(con.newInstance(args));
        }
        return retData;
    }

    public static String buildRequestString(Map parms) {
        if (parms == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        Iterator iter = parms.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Object value = parms.get(key);
            if (value instanceof String) {
                String v = (String)value;
                buf.append(key);
                buf.append("=");
                try {
                    buf.append(URLEncoder.encode(v, "utf-8"));
                }
                catch (UnsupportedEncodingException e) {}
            } else if (value instanceof List) {
                List l = (List)value;
                if (l != null) {
                    for (int i = 0; i < l.size(); ++i) {
                        String v = (String)l.get(i);
                        buf.append(key);
                        buf.append("=");
                        try {
                            buf.append(URLEncoder.encode(v, "utf-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            // empty catch block
                        }
                        if (i >= l.size() - 1) continue;
                        buf.append("&amp;");
                    }
                }
            } else {
                buf.append(key);
                buf.append("=");
                try {
                    buf.append(URLEncoder.encode(value.toString(), "utf-8"));
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
            }
            if (!iter.hasNext()) continue;
            buf.append("&amp;");
        }
        return buf.toString();
    }

    public static Parameters getParameters(HttpServletRequest request) throws IOException {
        return new Parameters(request);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

