/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.servlet;

import com.gentlyweb.utils.FilterException;
import com.gentlyweb.utils.GeneralFilter;
import com.oreilly.servlet.multipart.FilePart;
import com.oreilly.servlet.multipart.MultipartParser;
import com.oreilly.servlet.multipart.ParamPart;
import com.oreilly.servlet.multipart.Part;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class Parameters {
    public static final String MULTIPART_FORM = "multipart/form-data";
    private Map params = new HashMap();
    private HttpServletRequest request = null;
    private boolean normal = true;

    public Parameters(HttpServletRequest request) throws IOException {
        this.init(request, 1024000, null);
    }

    public Parameters(HttpServletRequest request, int maxRequestSize) throws IOException {
        this.init(request, maxRequestSize, null);
    }

    public Parameters(HttpServletRequest request, int maxRequestSize, Map fileSizes) throws IOException {
        this.init(request, maxRequestSize, fileSizes);
    }

    public List getParameterNames(GeneralFilter gf) throws IllegalAccessException, InvocationTargetException, FilterException {
        ArrayList<String> retData = new ArrayList<String>();
        if (this.normal) {
            Enumeration ps = this.request.getParameterNames();
            while (ps.hasMoreElements()) {
                String name = (String)ps.nextElement();
                if (!gf.accept(name)) continue;
                retData.add(name);
            }
        } else {
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                if (!gf.accept(name)) continue;
                retData.add(name);
            }
        }
        return retData;
    }

    public byte[] getFileContent(String name) {
        File f = this.getFile(name);
        if (f == null) {
            return null;
        }
        return f.bytes;
    }

    public Iterator iterator() {
        return this.params.keySet().iterator();
    }

    private File getFile(String name) {
        Object o = this.params.get(name);
        if (o == null) {
            return null;
        }
        if (o instanceof File) {
            return (File)o;
        }
        return null;
    }

    public String getFileName(String name) {
        File f = this.getFile(name);
        if (f == null) {
            return null;
        }
        return f.fileName;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public List getParameterValues(String name) {
        if (this.normal) {
            ArrayList<String> retData = new ArrayList<String>();
            String[] ps = this.request.getParameterValues(name);
            if (ps != null) {
                for (int i = 0; i < ps.length; ++i) {
                    retData.add(ps[i]);
                }
            }
            return retData;
        }
        Object o = this.params.get(name);
        ArrayList retData = new ArrayList();
        retData.add(o);
        return retData;
    }

    public String getParameter(String name) {
        if (this.normal) {
            return this.request.getParameter(name);
        }
        Object o = this.params.get(name);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof File) {
            File f = (File)o;
            return f.fileName;
        }
        return null;
    }

    private void init(HttpServletRequest request, int maxRequestSize, Map fileSizes) throws IOException {
        Part p;
        this.request = request;
        String ct = request.getContentType();
        if (ct == null) {
            return;
        }
        if (!ct.startsWith(MULTIPART_FORM)) {
            return;
        }
        this.normal = false;
        MultipartParser mp = new MultipartParser(request, maxRequestSize);
        while ((p = mp.readNextPart()) != null) {
            Integer i;
            String name;
            if (p.isParam()) {
                ParamPart pp = (ParamPart)p;
                name = pp.getName();
                String value = pp.getStringValue().trim();
                this.params.put(name, value);
            }
            if (!p.isFile()) continue;
            FilePart fp = (FilePart)p;
            name = fp.getName();
            BufferedInputStream bin = new BufferedInputStream(fp.getInputStream());
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] buf = new byte[20480];
            int read = 0;
            int count = 0;
            int max = -1;
            if (fileSizes != null && (i = (Integer)fileSizes.get(name)) != null) {
                max = i;
            }
            while ((read = bin.read(buf)) != -1) {
                if (max > -1 && ++count > max) {
                    throw new IOException("Parameter: " + name + " has associated file larger than maximum specified: " + max);
                }
                bout.write(buf, 0, read);
            }
            File f = new File();
            f.fileName = fp.getFileName();
            f.bytes = bout.toByteArray();
            this.params.put(name, f);
        }
    }

    private class File {
        public String fileName = null;
        public byte[] bytes = null;

        private File() {
        }
    }
}

