/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.properties;

import com.gentlyweb.properties.AbstractProperty;
import com.gentlyweb.properties.BooleanProperty;
import com.gentlyweb.properties.ClassProperty;
import com.gentlyweb.properties.EmailProperty;
import com.gentlyweb.properties.EnumeratedProperty;
import com.gentlyweb.properties.FileProperty;
import com.gentlyweb.properties.FloatProperty;
import com.gentlyweb.properties.IntegerProperty;
import com.gentlyweb.properties.NumberProperty;
import com.gentlyweb.properties.PropertyException;
import com.gentlyweb.properties.PropertyNameMapping;
import com.gentlyweb.properties.StringProperty;
import com.gentlyweb.properties.URLProperty;
import com.gentlyweb.utils.CollectionsUtils;
import com.gentlyweb.xml.JDOMUtils;
import com.gentlyweb.xml.JDOMXmlOutputter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Text;

public class Properties
implements JDOMXmlOutputter {
    public static final String URL = "url";
    public static final String FILE = "file";
    public static final String DIR = "dir";
    public static final String CLASS = "class";
    public static final String INTEGER = "integer";
    public static final String EMAIL = "email";
    public static final String BOOLEAN = "boolean";
    public static final String ENUM = "enum";
    public static final String STRING = "string";
    public static final String FLOAT = "float";
    public static final String NUMBER = "number";
    private Map props = new HashMap();
    private Properties parentProps = null;
    private File propsFile = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$Number;

    public Properties() {
    }

    public void merge(Properties props) {
        this.props.putAll(props.getPropertiesAsMap());
    }

    public void setParentProperties(Properties props) {
        this.parentProps = props;
    }

    public Properties(File in, String zipExtension) throws IOException, JDOMException, PropertyException {
        this.setProperties(JDOMUtils.getFileAsElement(in, zipExtension));
        this.propsFile = in;
    }

    public Properties(File in, String zipExtension, Properties parent) throws IOException, PropertyException, JDOMException {
        this.parentProps = parent;
        this.setProperties(JDOMUtils.getFileAsElement(in, zipExtension));
        this.propsFile = in;
    }

    public void setProperty(String name, AbstractProperty ap) {
        this.props.put(name, ap);
    }

    private void setProperties(Element root) throws JDOMException, PropertyException, IOException {
        JDOMUtils.checkName(root, "properties", true);
        List properties = JDOMUtils.getChildElements(root, "property", true);
        for (int i = 0; i < properties.size(); ++i) {
            Element property = (Element)properties.get(i);
            String id = JDOMUtils.getAttributeValue(property, "id");
            Element value = JDOMUtils.getChildElement(property, "value");
            List propvalues = value.getContent();
            StringBuffer valuebuf = new StringBuffer();
            for (int j = 0; j < propvalues.size(); ++j) {
                Element elitem;
                Object item = propvalues.get(j);
                if (item instanceof Text) {
                    valuebuf.append(((Text)item).getTextTrim());
                }
                if (!(item instanceof Element) || !(elitem = (Element)item).getName().equals("property")) continue;
                String propval = JDOMUtils.getAttributeValue(elitem, "id");
                valuebuf.append(this.getElementsValue(propval, root));
            }
            String val = valuebuf.toString();
            String type = JDOMUtils.getAttributeValue(property, "type");
            AbstractProperty prop = this.getProperty(property, id, type, val);
            this.props.put(id, prop);
        }
    }

    private AbstractProperty getProperty(Element property, String id, String type, String val) throws PropertyException, JDOMException {
        if (type.equals(EMAIL)) {
            return new EmailProperty(property, id, type, val);
        }
        if (type.equals(FLOAT)) {
            return new FloatProperty(property, id, type, val);
        }
        if (type.equals(NUMBER)) {
            return new NumberProperty(property, id, type, val);
        }
        if (type.equals(INTEGER)) {
            return new IntegerProperty(property, id, type, val);
        }
        if (type.equals(BOOLEAN)) {
            return new BooleanProperty(property, id, type, val);
        }
        if (type.equals(DIR) || type.equals(FILE)) {
            return new FileProperty(property, id, type, val);
        }
        if (type.equals(URL)) {
            return new URLProperty(property, id, type, val);
        }
        if (type.equals(ENUM)) {
            return new EnumeratedProperty(property, id, type, val);
        }
        if (type.equals(CLASS)) {
            return new ClassProperty(property, id, type, val);
        }
        if (type.equals(STRING)) {
            return new StringProperty(property, id, type, val);
        }
        throw new JDOMException("Invalid value: " + type + " for attribute: " + JDOMUtils.getPath(property.getAttribute("type")));
    }

    public static void setPropertiesInClass(String className, PropertyNameMapping mapper, Properties props) throws IllegalArgumentException, IllegalAccessException, ClassNotFoundException, InstantiationException, InvocationTargetException, PropertyException {
        Class<?> c = Class.forName(className);
        Object o = c.newInstance();
        Properties.setPropertiesInObject(o, mapper, props);
    }

    public static void setPropertiesInObject(Object o, PropertyNameMapping mapper, Properties props) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, PropertyException {
        Class<?> c = o.getClass();
        Map prs = props.getPropertiesAsMap();
        ArrayList l = new ArrayList();
        CollectionsUtils.getMapEntriesAsOrderedList(prs, l);
        for (int i = 0; i < l.size(); ++i) {
            AbstractProperty p = (AbstractProperty)l.get(i);
            String f = p.getID();
            if (mapper != null) {
                f = mapper.mapName(f);
            }
            Field field = null;
            try {
                field = c.getField(f);
            }
            catch (NoSuchFieldException e) {
                // empty catch block
            }
            if (field == null) {
                StringBuffer name = new StringBuffer(p.getID());
                name.setCharAt(0, Character.toUpperCase(name.charAt(0)));
                name.insert(0, "set");
                Class[] parmTypes = new Class[]{class$java$lang$String == null ? Properties.class$("java.lang.String") : class$java$lang$String};
                Object[] args = new Object[]{p.getValue()};
                if (p instanceof URLProperty) {
                    parmTypes[0] = class$java$net$URL == null ? Properties.class$("java.net.URL") : class$java$net$URL;
                    args[0] = ((URLProperty)p).getURL();
                }
                if (p instanceof FileProperty) {
                    parmTypes[0] = class$java$io$File == null ? Properties.class$("java.io.File") : class$java$io$File;
                    args[0] = ((FileProperty)p).getFile();
                }
                if (p instanceof ClassProperty) {
                    parmTypes[0] = class$java$lang$Class == null ? Properties.class$("java.lang.Class") : class$java$lang$Class;
                    args[0] = ((ClassProperty)p).getClass();
                }
                if (p instanceof BooleanProperty) {
                    parmTypes[0] = Boolean.TYPE;
                    args[0] = new Boolean(((BooleanProperty)p).getBoolean());
                }
                if (p instanceof IntegerProperty) {
                    parmTypes[0] = Integer.TYPE;
                    args[0] = new Integer(((IntegerProperty)p).getInteger());
                }
                if (p instanceof FloatProperty) {
                    parmTypes[0] = Float.TYPE;
                    args[0] = new Float(((FloatProperty)p).getFloat());
                }
                if (p instanceof NumberProperty) {
                    parmTypes[0] = class$java$lang$Number == null ? Properties.class$("java.lang.Number") : class$java$lang$Number;
                    args[0] = new Double(((NumberProperty)p).getDouble());
                }
                Method meth = null;
                try {
                    meth = c.getMethod(name.toString(), parmTypes);
                    meth.invoke(o, args);
                }
                catch (NoSuchMethodException e) {}
                continue;
            }
            if (p instanceof URLProperty) {
                try {
                    if (field.getType().isAssignableFrom(class$java$net$URL == null ? Properties.class$("java.net.URL") : class$java$net$URL)) {
                        field.set(o, ((URLProperty)p).getURL());
                        continue;
                    }
                    field.set(o, p.getValue());
                    continue;
                }
                catch (Exception e) {
                    throw new PropertyException("Unable to set URL property: " + p.getID(), e, field);
                }
            }
            if (p instanceof IntegerProperty) {
                try {
                    if (field.getType().isPrimitive() && Integer.TYPE.isAssignableFrom(field.getType())) {
                        field.setInt(o, ((IntegerProperty)p).getInteger());
                        continue;
                    }
                    field.set(o, p.getValue());
                    continue;
                }
                catch (Exception e) {
                    throw new PropertyException("Unable to set integer property: " + p.getID(), e, field);
                }
            }
            if (p instanceof FloatProperty) {
                try {
                    if (field.getType().isPrimitive() && Float.TYPE.isAssignableFrom(field.getType())) {
                        field.setFloat(o, ((FloatProperty)p).getFloat());
                        continue;
                    }
                    field.set(o, p.getValue());
                    continue;
                }
                catch (Exception e) {
                    throw new PropertyException("Unable to set float property: " + p.getID(), e, field);
                }
            }
            if (p instanceof BooleanProperty) {
                try {
                    if (field.getType().isPrimitive() && Boolean.TYPE.isAssignableFrom(field.getType())) {
                        field.setBoolean(o, ((BooleanProperty)p).getBoolean());
                        continue;
                    }
                    field.set(o, p.getValue());
                    continue;
                }
                catch (Exception e) {
                    throw new PropertyException("Unable to set boolean property: " + p.getID(), e, field);
                }
            }
            if (p instanceof ClassProperty) {
                try {
                    if (field.getType().isAssignableFrom(class$java$lang$Class == null ? Properties.class$("java.lang.Class") : class$java$lang$Class)) {
                        field.set(o, ((ClassProperty)p).getClazz());
                        continue;
                    }
                    field.set(o, p.getValue());
                    continue;
                }
                catch (Exception e) {
                    throw new PropertyException("Unable to set Class property: " + p.getID(), e, field);
                }
            }
            if (p instanceof FileProperty) {
                try {
                    if (field.getType().isAssignableFrom(class$java$io$File == null ? Properties.class$("java.io.File") : class$java$io$File)) {
                        field.set(o, ((FileProperty)p).getFile());
                        continue;
                    }
                    field.set(o, p.getValue());
                    continue;
                }
                catch (Exception e) {
                    throw new PropertyException("Unable to set File property: " + p.getID(), e, field);
                }
            }
            field.set(o, p.getValue());
        }
    }

    private String getElementsValue(String itemname, Element root) throws JDOMException {
        StringBuffer buf = new StringBuffer();
        Element el = this.getValueElementForID(itemname, root);
        if (el == null) {
            if (this.parentProps != null) {
                String val = this.parentProps.getProperty(itemname);
                if (val != null) {
                    return val;
                }
                throw new JDOMException("Unable to find property: " + itemname + " in local or parent properties");
            }
            throw new JDOMException("Unable to find property: " + itemname + " (path: " + JDOMUtils.getPath(root) + ") in local properties.");
        }
        List elcontent = el.getContent();
        ListIterator elcontentit = elcontent.listIterator();
        while (elcontentit.hasNext()) {
            Object item = elcontentit.next();
            if (item instanceof Text) {
                buf.append(((Text)item).getTextTrim());
            }
            if (!(item instanceof Element)) continue;
            Element elitem = (Element)item;
            buf.append(this.getElementsValue(JDOMUtils.getAttributeValue(elitem, "id"), root));
        }
        return buf.toString();
    }

    public String getProperty(String name) {
        AbstractProperty prop = this.getPropertyI(name);
        if (prop == null) {
            return null;
        }
        return prop.getValue();
    }

    public AbstractProperty getPropertyObj(String name) {
        return this.getPropertyI(name);
    }

    private AbstractProperty getPropertyI(String name) {
        AbstractProperty val = (AbstractProperty)this.props.get(name);
        if (this.parentProps != null && val == null) {
            return this.parentProps.getPropertyI(name);
        }
        return val;
    }

    public int getPropertyAsInt(String name) {
        AbstractProperty ap = this.getPropertyI(name);
        if (ap == null) {
            return 0;
        }
        if (ap instanceof NumberProperty) {
            return ((NumberProperty)ap).getInteger();
        }
        return 0;
    }

    public float getPropertyAsFloat(String name) {
        AbstractProperty ap = this.getPropertyI(name);
        if (ap == null) {
            return 0.0f;
        }
        if (ap instanceof NumberProperty) {
            return ((NumberProperty)ap).getFloat();
        }
        return 0.0f;
    }

    public Set getEnumPropertyValues(String name) {
        AbstractProperty ap = this.getPropertyI(name);
        if (ap == null) {
            return null;
        }
        if (ap instanceof EnumeratedProperty) {
            return ((EnumeratedProperty)ap).getValues();
        }
        return null;
    }

    public boolean getPropertyAsBoolean(String name) {
        AbstractProperty ap = this.getPropertyI(name);
        if (ap == null) {
            return false;
        }
        if (ap instanceof BooleanProperty) {
            return ((BooleanProperty)ap).getBoolean();
        }
        return false;
    }

    public File getPropertyAsFile(String name) {
        AbstractProperty ap = this.getPropertyI(name);
        if (ap == null) {
            return null;
        }
        if (ap instanceof FileProperty) {
            return ((FileProperty)ap).getFile();
        }
        return null;
    }

    private Element getValueElementForID(String id, Element root) throws JDOMException {
        List props = root.getChildren("property");
        ListIterator propsit = props.listIterator();
        while (propsit.hasNext()) {
            Element el = (Element)propsit.next();
            if (el.getAttribute("id") != null) {
                String name = el.getAttribute("id").getValue();
                if (!name.equals(id)) continue;
                return el.getChild("value");
            }
            throw new JDOMException("Property element: " + JDOMUtils.getPath(el) + " does not have an: " + "id" + " attribute");
        }
        return null;
    }

    public Map getPropertiesAsMap() {
        HashMap vals = new HashMap();
        if (this.parentProps != null) {
            vals.putAll(this.parentProps.getPropertiesAsMap());
        }
        vals.putAll(this.props);
        return vals;
    }

    public List getProperties() {
        ArrayList l = new ArrayList();
        CollectionsUtils.getMapEntriesAsOrderedList(this.props, l);
        if (this.parentProps != null) {
            l.addAll(this.parentProps.getProperties());
        }
        return l;
    }

    public String getPropertiesAsString() {
        StringBuffer retbuf = new StringBuffer("The following properties are known about:\n\n");
        Iterator iter = this.props.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            AbstractProperty value = (AbstractProperty)this.props.get(key);
            if (value != null) {
                retbuf.append("Key: " + key + " : " + value.getValue() + "\n");
                continue;
            }
            retbuf.append("Error: Value for key: " + key + " is null.\n");
        }
        retbuf.append("\n\n");
        if (this.parentProps != null) {
            retbuf.append("The following parent properties are also known about:\n");
            retbuf.append(this.parentProps.getPropertiesAsString());
        }
        return retbuf.toString();
    }

    public File getFile() {
        return this.propsFile;
    }

    public Element getAsJDOMElement() {
        Element root = new Element("properties");
        Iterator iter = this.props.keySet().iterator();
        while (iter.hasNext()) {
            AbstractProperty ap = (AbstractProperty)this.props.get(iter.next());
            root.addContent((Content)ap.getAsJDOMElement());
        }
        return root;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class XMLConstants {
        private static final String root = "properties";
        public static final String property = "property";
        public static final String value = "value";
        public static final String type = "type";
        public static final String id = "id";
    }
}

