/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.properties;

import com.gentlyweb.properties.AbstractProperty;
import com.gentlyweb.properties.PropertyException;
import com.gentlyweb.utils.IOUtils;
import com.gentlyweb.xml.JDOMUtils;
import java.io.File;
import java.io.IOException;
import org.jdom.Element;
import org.jdom.JDOMException;

public class FileProperty
extends AbstractProperty {
    private boolean mustExist = false;

    public FileProperty(String id, File f, String type, boolean mustExist) {
        super(id, f.getPath(), type);
        this.mustExist = mustExist;
    }

    public FileProperty(Element root, String id, String type, String value) throws JDOMException, PropertyException {
        super(root, id, type, value);
        this.mustExist = JDOMUtils.getAttributeValueAsBoolean(root, "exist", false);
        File file = new File(value);
        if (file.exists()) {
            if (type.equals("dir")) {
                if (file.isFile()) {
                    throw new PropertyException("File: " + file.getPath() + " is a file, but property (path=" + JDOMUtils.getPath(root) + ") type attribute is: " + "dir");
                }
            } else if (file.isDirectory()) {
                throw new PropertyException("File: " + file.getPath() + " is a directory, but property (path=" + JDOMUtils.getPath(root) + ") type attribute is: " + "file");
            }
        }
        if (this.mustExist && !file.exists()) {
            String v = "file";
            if (type.equals("dir")) {
                v = "directory";
            }
            throw new PropertyException("Property: " + JDOMUtils.getPath(root) + " with value: " + value + " does not exist as a " + v + " in the file system");
        }
    }

    public String getFileContent() throws IOException {
        File f = new File(this.getValue());
        if (!f.exists()) {
            return null;
        }
        if (f.isDirectory()) {
            return null;
        }
        return IOUtils.getFile(f);
    }

    public byte[] getFileContentAsArray() throws IOException {
        File f = new File(this.getValue());
        if (!f.exists()) {
            return null;
        }
        if (f.isDirectory()) {
            return null;
        }
        return IOUtils.getFileAsArray(f);
    }

    public File getFile() {
        return new File(this.getValue());
    }

    public boolean isDirectory() {
        return this.getFile().isDirectory();
    }

    public Element getAsJDOMElement() {
        Element root = super.getAsJDOMElement();
        root.setAttribute("exist", Boolean.toString(this.mustExist));
        return root;
    }

    public class XMLConstants {
        public static final String exist = "exist";
    }
}

