/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.logging;

import com.gentlyweb.utils.GeneralUtils;
import com.gentlyweb.utils.IOUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class Logger {
    private SimpleDateFormat df = null;
    private File logFile;
    private String initMessage = null;
    private Date startTime = null;
    private Date initFinishTime = null;
    private int informationMessageListMaxSize = 1000;
    private int warningMessageListMaxSize = 1000;
    private int errorMessageListMaxSize = -1;
    private boolean append = false;
    private String dateFormat = "dd.MM.yyyy-kk.mm.ss.SSS";
    private String zipExtension = ".gz";
    private boolean zipArchiveFiles = false;
    private File archiveDir = null;
    private boolean inited = false;
    private int problemID = 0;
    private File problemIDFile = null;
    private List infMessages = Collections.synchronizedList(new ArrayList());
    private List warMessages = Collections.synchronizedList(new ArrayList());
    private List errMessages = Collections.synchronizedList(new ArrayList());

    public void setLogInitMessage(String mess) {
        this.initMessage = mess;
    }

    public String getLogInitMessage() {
        return this.initMessage;
    }

    public void setProblemIDFile(File file) {
        this.problemIDFile = file;
    }

    public boolean isAppendToLogFile() {
        return this.append;
    }

    public void setAppendToLogFile(boolean append) {
        if (!this.inited) {
            this.append = append;
        }
    }

    public String getZipExtension() {
        return this.zipExtension;
    }

    public void setLogFileZipExtension(String ext) {
        if (!this.inited) {
            this.zipExtension = ext;
        }
    }

    public boolean isZipArchiveLogFiles() {
        return this.zipArchiveFiles;
    }

    public void setZipArchiveLogFiles(boolean zip) {
        if (!this.inited) {
            this.zipArchiveFiles = zip;
        }
    }

    public void setLogArchiveDirectory(File file) {
        this.archiveDir = file;
    }

    public String getLogDateFormat() {
        return this.dateFormat;
    }

    public void setLogDateFormat(String dateFormat) {
        if (!this.inited) {
            this.dateFormat = dateFormat;
        }
    }

    public int getInformationMessageListMaxSize() {
        return this.informationMessageListMaxSize;
    }

    public int getWarningMessageListMaxSize() {
        return this.warningMessageListMaxSize;
    }

    public int getErrorMessageListMaxSize() {
        return this.errorMessageListMaxSize;
    }

    public synchronized void setMaximumInformationMessagesSize(int newSize) {
        if (newSize < 0) {
            return;
        }
        if (this.informationMessageListMaxSize != newSize) {
            int cursize;
            if (newSize == 0) {
                this.infMessages.clear();
            } else if (newSize < this.informationMessageListMaxSize && (cursize = this.infMessages.size()) > newSize) {
                this.infMessages = this.infMessages.subList(0, newSize - 1);
            }
            this.informationMessageListMaxSize = newSize;
            this.logInformationMessage("Reset information message list size to: " + newSize);
        }
    }

    public synchronized void setMaximumErrorMessagesSize(int newSize) {
        if (newSize < 0) {
            this.errorMessageListMaxSize = -1;
            this.logInformationMessage("Removed error log list size maximum size, error log list will grow with no upper limit.");
            return;
        }
        if (this.errorMessageListMaxSize != newSize) {
            int cursize;
            if (newSize == 0) {
                this.errMessages.clear();
            } else if (newSize < this.errorMessageListMaxSize && (cursize = this.errMessages.size()) > newSize) {
                this.errMessages = this.errMessages.subList(0, newSize - 1);
            }
            this.errorMessageListMaxSize = newSize;
            this.logInformationMessage("Reset error log message list size to: " + newSize);
        }
    }

    public synchronized void setMaximumWarningMessagesSize(int newSize) {
        if (newSize < 0) {
            return;
        }
        if (this.warningMessageListMaxSize != newSize) {
            int cursize;
            if (newSize == 0) {
                this.warMessages.clear();
            } else if (newSize < this.warningMessageListMaxSize && (cursize = this.warMessages.size()) > newSize) {
                this.warMessages = this.warMessages.subList(0, newSize - 1);
            }
            this.warningMessageListMaxSize = newSize;
            this.logInformationMessage("Reset warning log message list size to: " + newSize);
        }
    }

    public void initLogFile(File logFile) throws Exception {
        if (logFile == null) {
            throw new Exception("No log file location specified.");
        }
        this.inited = true;
        this.df = new SimpleDateFormat(this.dateFormat);
        this.startTime = this.startTime;
        ArrayList<String> ms = new ArrayList<String>();
        if (this.problemIDFile != null && this.problemIDFile.exists()) {
            String id = IOUtils.getFile(this.problemIDFile);
            if (!id.equals("")) {
                try {
                    this.problemID = Integer.parseInt(id);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                ms.add("Using problem id file: " + this.problemIDFile.getPath());
                ms.add("Problem id inited to: " + this.problemID);
            } else {
                ms.add("No problem id file specified, initing id to: 1");
            }
        }
        if (logFile.isDirectory()) {
            throw new Exception("Log file location: " + logFile.getPath() + " is a directory");
        }
        if (logFile.exists() && !logFile.canWrite()) {
            throw new Exception("Log file: " + logFile.getPath() + " is not writable");
        }
        if (logFile.exists() && !this.append) {
            SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy-kk.mm.ss.SSS");
            if (this.archiveDir == null) {
                this.archiveDir = logFile.getParentFile();
            }
            if (this.archiveDir.isFile()) {
                throw new Exception("Unable to archive log file, there is already a file named \"" + this.archiveDir + "\" in the log directory: " + logFile.getParent());
            }
            if (!this.archiveDir.exists()) {
                this.archiveDir.mkdir();
            }
            File newname = new File(this.archiveDir.getPath() + System.getProperty("file.separator") + logFile.getName() + "-" + df.format(new Date(System.currentTimeMillis())));
            logFile.renameTo(newname);
            ms.add("Archived existing log file, renamed to: " + newname.getName());
            if (this.zipArchiveFiles) {
                File zFile = new File(newname.getPath() + this.zipExtension);
                ms.add("Created zip file: " + zFile.getName());
                IOUtils.gzipFile(newname, zFile);
                ms.add("Zipped file: " + newname.getPath() + " to: " + zFile.getPath());
                newname.delete();
            }
        }
        this.logFile = logFile;
        if (this.initMessage != null) {
            this.logInformationMessage(this.initMessage);
        }
        this.logInformationMessage("Logger started");
        this.logInformationMessage("Information message size limit: " + this.informationMessageListMaxSize);
        this.logInformationMessage("Warning message size limit: " + this.warningMessageListMaxSize);
        if (this.errorMessageListMaxSize == -1) {
            this.logInformationMessage("Error message size unlimited.");
        } else {
            this.logInformationMessage("Error message size limit: " + this.errorMessageListMaxSize);
        }
        for (int i = 0; i < ms.size(); ++i) {
            this.logInformationMessage((String)ms.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void logError(String message, Exception excep, List otherInfo) {
        String err;
        block15: {
            int pid = this.problemID;
            err = this.getErrorAsString(message, excep, otherInfo, ++pid);
            if (this.logFile != null) {
                try {
                    PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.logFile.getPath(), true)));
                    try {
                        try {
                            out.print(this.getBoilerPlate("Error"));
                            out.print(err);
                        }
                        catch (Exception ee) {
                            ArrayList<Object> l = new ArrayList<Object>();
                            l.add("Original message: " + message);
                            l.add(excep);
                            if (otherInfo != null) {
                                l.addAll(otherInfo);
                            }
                            this.addMessage(0, this.getErrorAsString("Unable to write to log file: " + this.logFile.getPath(), ee, l, -1));
                            Object var10_10 = null;
                            if (out != null) {
                                out.flush();
                                out.close();
                            }
                            break block15;
                        }
                        Object var10_9 = null;
                        if (out != null) {
                            out.flush();
                            out.close();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_11 = null;
                        if (out != null) {
                            out.flush();
                            out.close();
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    ArrayList<Object> l = new ArrayList<Object>();
                    l.add("Original message: " + message);
                    l.add(excep);
                    if (otherInfo != null) {
                        l.addAll(otherInfo);
                    }
                    this.addMessage(0, this.getErrorAsString("Unable to write to log file: " + this.logFile.getPath(), e, l, -1));
                }
            }
        }
        this.addMessage(0, err);
        ++this.problemID;
        if (this.problemIDFile != null) {
            try {
                IOUtils.writeStringToFile(this.problemIDFile, String.valueOf(this.problemID), false);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private String getErrorAsString(String message, Exception e, List otherInfo, int problemID) {
        StringBuffer buf = new StringBuffer("[ID-");
        if (problemID == -1) {
            buf.append(" INTERNAL LOGGING ERROR");
        } else {
            buf.append(problemID);
        }
        buf.append("] ");
        buf.append(message);
        buf.append("\n\n");
        if (e != null) {
            buf.append("The following exception chain was also given:\n\n");
            try {
                buf.append(GeneralUtils.getExceptionTraceAsString(e));
            }
            catch (Exception ee) {
                buf.append("Unable to output stack trace for exception: ");
                buf.append(e.getMessage());
                buf.append(", root cause: ");
                buf.append(ee.getMessage());
            }
        }
        buf.append("\n");
        if (otherInfo != null) {
            buf.append("Extra information provided is:\n");
            for (int i = 0; i < otherInfo.size(); ++i) {
                buf.append(otherInfo.get(i).toString());
                buf.append('\n');
            }
        }
        return buf.toString();
    }

    private String getBoilerPlate(String type) {
        StringBuffer buf = new StringBuffer(type);
        buf.append(" [");
        buf.append(new SimpleDateFormat(this.dateFormat).format(new Date()));
        buf.append("] ");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void logInformationMessage(String message) {
        block10: {
            if (this.logFile != null) {
                try {
                    PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.logFile.getPath(), true)));
                    try {
                        try {
                            out.print(this.getBoilerPlate("Information"));
                            out.print(message);
                            out.println();
                        }
                        catch (Exception e) {
                            ArrayList<String> l = new ArrayList<String>();
                            l.add("Original message: " + message);
                            this.addMessage(0, this.getErrorAsString("Unable to write to log file: " + this.logFile.getPath(), e, l, -1));
                            Object var6_5 = null;
                            if (out != null) {
                                out.flush();
                                out.close();
                            }
                            break block10;
                        }
                        Object var6_4 = null;
                        if (out != null) {
                            out.flush();
                            out.close();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        if (out != null) {
                            out.flush();
                            out.close();
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    ArrayList<String> l = new ArrayList<String>();
                    l.add("Original message: " + message);
                    this.addMessage(0, this.getErrorAsString("Unable to write to log file: " + this.logFile.getPath(), e, l, -1));
                }
            }
        }
        this.addMessage(2, message);
    }

    private void addMessage(int type, String message) {
        if (type == 2 && this.informationMessageListMaxSize > 0) {
            if (this.infMessages.size() == this.informationMessageListMaxSize) {
                this.infMessages.remove(this.infMessages.size() - 1);
            }
            this.infMessages.add(0, new Message(type, message));
        }
        if (type == 1 && this.warningMessageListMaxSize > 0) {
            if (this.warMessages.size() == this.warningMessageListMaxSize) {
                this.warMessages.remove(this.warMessages.size() - 1);
            }
            this.warMessages.add(0, new Message(type, message));
        }
        if (type == 0) {
            if (this.errorMessageListMaxSize > 0 && this.errMessages.size() == this.errorMessageListMaxSize) {
                this.errMessages.remove(this.errMessages.size() - 1);
            }
            if (this.errorMessageListMaxSize != 0) {
                this.errMessages.add(0, new Message(type, message));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void logWarningMessage(String message) {
        block10: {
            if (this.logFile != null) {
                try {
                    PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(this.logFile.getPath(), true)));
                    try {
                        try {
                            out.print(this.getBoilerPlate("Warning"));
                            out.print(message);
                            out.println();
                        }
                        catch (Exception e) {
                            ArrayList<String> l = new ArrayList<String>();
                            l.add("Original message: " + message);
                            this.addMessage(0, this.getErrorAsString("Unable to write to log file: " + this.logFile.getPath(), e, l, -1));
                            Object var6_5 = null;
                            if (out != null) {
                                out.flush();
                                out.close();
                            }
                            break block10;
                        }
                        Object var6_4 = null;
                        if (out != null) {
                            out.flush();
                            out.close();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        if (out != null) {
                            out.flush();
                            out.close();
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    ArrayList<String> l = new ArrayList<String>();
                    l.add("Original message: " + message);
                    this.addMessage(0, this.getErrorAsString("Unable to write to log file: " + this.logFile.getPath(), e, l, -1));
                }
            }
        }
        this.addMessage(1, message);
    }

    public void setInitFinishTime() {
        this.initFinishTime = new Date();
    }

    public Date getInitFinishTime() {
        return this.initFinishTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public List getErrorMessages() {
        return this.errMessages;
    }

    public List getInformationMessages() {
        return this.infMessages;
    }

    public List getWarningMessages() {
        return this.warMessages;
    }

    public List getInitMessages() {
        return this.getMessages(this.startTime, this.initFinishTime, 3);
    }

    public List getPostInitMessages(int types) {
        return this.getMessagesFrom(new Date(this.initFinishTime.getTime() + 1L), types);
    }

    public List getMessagesFrom(Date from, int types) {
        return this.getMessages(from, new Date(Long.MAX_VALUE), types);
    }

    public List getMessagesTo(Date to, int types) {
        return this.getMessages(new Date(Long.MIN_VALUE), to, types);
    }

    public List getMessages(Date from, Date to, int types) {
        long t;
        Message m;
        int i;
        ArrayList<Message> l = new ArrayList<Message>();
        long ff = from.getTime();
        long tt = to.getTime();
        if ((types & 0) == 0) {
            for (i = 0; i < this.errMessages.size(); ++i) {
                m = (Message)this.errMessages.get(i);
                t = m.getTime().getTime();
                if (t < ff || t > tt) continue;
                l.add(m);
            }
        }
        if ((types & 1) == 1) {
            for (i = 0; i < this.warMessages.size(); ++i) {
                m = (Message)this.warMessages.get(i);
                t = m.getTime().getTime();
                if (t < ff || t > tt) continue;
                l.add(m);
            }
        }
        if ((types & 2) == 2) {
            for (i = 0; i < this.infMessages.size(); ++i) {
                m = (Message)this.infMessages.get(i);
                t = m.getTime().getTime();
                if (t < ff || t > tt) continue;
                l.add(m);
            }
        }
        Collections.sort(l);
        return l;
    }

    public int getProblemID() {
        return this.problemID;
    }

    public String formatDate(Date date) {
        SimpleDateFormat d = new SimpleDateFormat(this.df.toPattern());
        return d.format(date);
    }

    public class Message
    implements Comparable {
        public static final int ERROR = 0;
        public static final int WARNING = 1;
        public static final int INFORMATION = 2;
        private int type = -1;
        private String mess = "";
        private Date time = new Date();

        public Message(int type, String message) {
            this.mess = message;
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public String getMessage() {
            return this.mess;
        }

        public Date getTime() {
            return this.time;
        }

        public int compareTo(Object o) {
            Message m = (Message)o;
            return -1 * this.time.compareTo(m.getTime());
        }
    }
}

