/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.jsql;

public class ValueTokenizer {
    private String str = null;
    private char breakChar = (char)32;
    private int currLoc = 0;
    private boolean quoted = false;

    public ValueTokenizer(String str) {
        this.str = str;
    }

    public ValueTokenizer(String str, char bc) {
        this(str);
        this.breakChar = bc;
    }

    public void setString(String str) {
        this.str = str;
        this.currLoc = 0;
        this.quoted = false;
    }

    public void setBreakChar(char bc) {
        this.breakChar = bc;
    }

    public boolean lastTokenQuoted() {
        return this.quoted;
    }

    public boolean hasMoreTokens() {
        return this.str.length() - 1 > this.currLoc;
    }

    public String nextToken() {
        if (this.str == null) {
            return null;
        }
        this.quoted = false;
        char[] chars = this.str.substring(this.currLoc).toCharArray();
        boolean inQuote = false;
        char quoteVal = '\'';
        int consumed = 0;
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < chars.length; ++i) {
            ++consumed;
            if (chars[i] == this.breakChar && !inQuote) break;
            if (inQuote && chars[i] == '\\' && i < chars.length - 1 && chars[i + 1] == quoteVal && (chars[i + 1] == '\'' || chars[i + 1] == '\"')) continue;
            if (chars[i] == '\'' || chars[i] == '\"') {
                b.append(chars[i]);
                if (!inQuote) {
                    quoteVal = chars[i];
                    this.quoted = true;
                    inQuote = true;
                    continue;
                }
                if (inQuote && i > 0 && chars[i - 1] == '\\') continue;
                if (inQuote && chars[i] == quoteVal) {
                    inQuote = false;
                    continue;
                }
            }
            b.append(chars[i]);
        }
        this.currLoc += consumed;
        return b.toString();
    }
}

