/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.email;

import com.gentlyweb.email.Email;
import com.gentlyweb.email.EmailUtils;
import com.gentlyweb.logging.Logger;
import com.gentlyweb.utils.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class EmailSender
extends TimerTask {
    private String nameSearchVal = "[[NAME]]";
    private String emailSearchVal = "[[EMAIL]]";
    private Map recipients = null;
    private String smtpHost = "";
    private String zipExtension = ".gz";
    private String textEncoding = "iso-8859-1";
    private Email baseEmail = null;
    private boolean bodyIsHTML = false;
    private Logger logger = null;
    private Map replacements = null;
    private boolean isDaemon = false;
    private Map exceptions = new HashMap();
    private boolean tryAllUsers = false;
    private boolean inited = false;
    private Timer timer = null;

    public void setRunAsDaemon(boolean isDaemon) {
        if (!this.inited) {
            this.isDaemon = isDaemon;
        }
    }

    public void setTryAllUsers(boolean val) {
        if (!this.inited) {
            this.tryAllUsers = val;
        }
    }

    public String getZipExtension() {
        return this.zipExtension;
    }

    public String getTextEncoding() {
        return this.textEncoding;
    }

    public String getSMTPHost() {
        return this.smtpHost;
    }

    public void setBodyIsHTML(boolean isHTML) {
        if (!this.inited) {
            this.bodyIsHTML = isHTML;
        }
    }

    public void setZipExtension(String zipExtension) {
        if (!this.inited) {
            this.zipExtension = zipExtension;
        }
    }

    public void setNameReplacement(String nameReplace) {
        if (!this.inited) {
            this.nameSearchVal = nameReplace;
        }
    }

    public void setEmailReplacement(String emailReplace) {
        if (!this.inited) {
            this.emailSearchVal = emailReplace;
        }
    }

    public void setLogger(Logger logger) {
        if (!this.inited) {
            this.logger = logger;
        }
    }

    public void setReplacements(Map replacements) {
        if (!this.inited) {
            this.replacements = replacements;
        }
    }

    public void setSmtpHost(String smtpHost) {
        if (!this.inited) {
            this.smtpHost = smtpHost;
        }
    }

    public void setTextEncoding(String textEncoding) {
        if (!this.inited) {
            this.textEncoding = textEncoding;
        }
    }

    public void initExecutionTime(Date date) throws IllegalStateException {
        if (this.baseEmail == null || this.recipients == null || this.smtpHost == null) {
            throw new IllegalStateException("Insufficient data to send emails.");
        }
        this.timer = new Timer(this.isDaemon);
        this.timer.schedule((TimerTask)this, date);
        this.inited = true;
    }

    public void setBaseEmail(Email baseEmail) {
        if (!this.inited) {
            this.baseEmail = new Email();
            this.baseEmail.setSubject(baseEmail.getSubject());
            this.baseEmail.setBody(baseEmail.getBody());
            this.baseEmail.setAttachments(baseEmail.getAttachments());
        }
    }

    public void setRecipients(Map recipients) {
        if (!this.inited) {
            this.recipients = recipients;
        }
    }

    public Map getErrors() {
        return this.exceptions;
    }

    public void run() {
        this.timer = null;
        if (this.logger != null) {
            this.logger.logInformationMessage("About to send emails to Users, there are: " + this.recipients.size() + " email(s) to send.");
        }
        int sent = 0;
        String body = this.baseEmail.getBody();
        if (this.replacements != null) {
            Iterator rIter = this.replacements.keySet().iterator();
            while (rIter.hasNext()) {
                String id = (String)rIter.next();
                String rep = this.replacements.get(id).toString();
                body = StringUtils.replaceString(body, id, rep);
            }
        }
        Iterator iter = this.recipients.keySet().iterator();
        while (iter.hasNext()) {
            String addr = (String)iter.next();
            String name = (String)this.recipients.get(addr);
            String t = new String(body);
            if (this.emailSearchVal != null) {
                t = StringUtils.replaceString(t, this.emailSearchVal, addr);
            }
            if (this.nameSearchVal != null) {
                t = StringUtils.replaceString(t, this.nameSearchVal, name);
            }
            if (sent > 0 && sent % 10 == 0) {
                if (this.logger != null) {
                    this.logger.logInformationMessage("Sent: " + sent + " emails, sleeping for 2 seconds.");
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.baseEmail.setTo(addr);
            this.baseEmail.setBody(t);
            try {
                EmailUtils.sendEmail(this.baseEmail, this.bodyIsHTML, this.smtpHost, this.zipExtension, this.textEncoding);
                ++sent;
            }
            catch (Exception e) {
                if (this.logger != null) {
                    this.logger.logError("Unable to send email", e, null);
                }
                this.exceptions.put(addr, e);
                if (this.tryAllUsers) continue;
                break;
            }
        }
        if (this.logger != null) {
            this.logger.logInformationMessage("Completed email sending, sent: " + sent + " emails to: " + this.recipients.size() + " email addresses, there were: " + this.exceptions.size() + " errors during processing.");
        }
        this.inited = false;
    }
}

