/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.ecom;

import com.gentlyweb.datastore.DataStoreException;
import com.gentlyweb.datastore.Searchable;
import com.gentlyweb.ecom.ACL;
import com.gentlyweb.ecom.AbstractDataManager;
import com.gentlyweb.ecom.Account;
import com.gentlyweb.ecom.Order;
import com.gentlyweb.ecom.OrderItem;
import com.gentlyweb.ecom.StockItem;
import com.gentlyweb.ecom.StockManager;
import com.gentlyweb.templates.TemplateManager;
import com.gentlyweb.utils.GeneralFilter;
import com.gentlyweb.utils.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class OrderManager
extends AbstractDataManager {
    public static final String UPDATE = "orderUpdate";
    public static final String DELETE = "orderDelete";
    public static final String READ = "orderRead";
    public static final String STOCK_QUANTITY_CHANGED_FROM_ORDER_DEFAULT_TEMPLATE_NAME = "STOCK_QUANTITY_CHANGED_FROM_ORDER";
    public static final String ORDER_STATUS_CHANGED_DEFAULT_TEMPLATE_NAME = "ORDER_STATUS_CHANGED";
    private Random random = new Random();
    private StockManager stockManager = null;
    private TemplateManager templateManager = null;
    private ACL acl = null;
    private String stockQuantityChangedTemplateName = "STOCK_QUANTITY_CHANGED_FROM_ORDER";
    private String orderStatusChangedTemplateName = "ORDER_STATUS_CHANGED";
    private String dateFormat = "dd/MMM/yy";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$gentlyweb$ecom$Order;

    public OrderManager(boolean cacheStock, int policy) {
        super(cacheStock, policy);
    }

    public void setDateFormat(String df) {
        this.dateFormat = df;
    }

    public void setOrderStatusChangedTemplateName(String name) {
        this.orderStatusChangedTemplateName = name;
    }

    public void setStockQuantityChangedTemplateName(String name) {
        this.stockQuantityChangedTemplateName = name;
    }

    public void setACL(ACL acl) {
        this.acl = acl;
    }

    public void setTemplateManager(TemplateManager man) {
        this.templateManager = man;
    }

    public void setStockManager(StockManager man) {
        this.stockManager = man;
    }

    public synchronized void createOrder(Account acc, Order item) throws DataStoreException {
        this.checkAction(acc, UPDATE);
        item.setID(this.getNewOrderID());
        this.putObject(item.getID(), item);
    }

    public synchronized void saveOrder(Account acc, Order item) throws DataStoreException {
        this.checkAction(acc, UPDATE);
        if (!this.hasKey(item.getID()) || item.getID() == null) {
            throw new DataStoreException("Cannot save order for key: " + item.getID() + " that does not exist, use createOrder(Account,Order) for creating a new Order.");
        }
        this.putObject(item.getID(), item);
    }

    public Order getOrder(Account acc, String id) throws DataStoreException {
        this.checkAction(acc, READ);
        return (Order)this.getObject(id);
    }

    private void checkAction(Account acc, String act) throws DataStoreException {
        if (this.acl != null) {
            if (acc == null) {
                throw new DataStoreException("No account passed.");
            }
            if (!this.acl.actionAllowed(acc.getType(), acc.getUsername(), act)) {
                throw new DataStoreException("Account: " + acc.getType() + "/" + acc.getUsername() + " does not have the: " + act + " action allowed.");
            }
        }
    }

    public boolean hasOrder(Account acc, Order item) throws DataStoreException {
        this.checkAction(acc, READ);
        return this.hasKey(item.getID());
    }

    public synchronized List getOrders(Account acc, String id) throws DataStoreException {
        this.checkAction(acc, READ);
        GeneralFilter f = new GeneralFilter(class$java$lang$String == null ? (class$java$lang$String = OrderManager.class$("java.lang.String")) : class$java$lang$String);
        f.addField("toString", id, 3);
        return this.getObjects(f);
    }

    public synchronized List getAllOrders(Account acc) throws DataStoreException {
        this.checkAction(acc, READ);
        return this.getAllObjects();
    }

    public void addAll(Account acc, Map map) throws IllegalArgumentException, DataStoreException {
        this.checkAction(acc, UPDATE);
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            Object value = map.get(key);
            if (!(key instanceof String)) {
                throw new IllegalArgumentException("Expected key to be of type: " + (class$java$lang$String == null ? (class$java$lang$String = OrderManager.class$("java.lang.String")) : class$java$lang$String).getName() + ", got: " + key.getClass().getName());
            }
            if (!value.getClass().isAssignableFrom(class$com$gentlyweb$ecom$Order == null ? OrderManager.class$("com.gentlyweb.ecom.Order") : class$com$gentlyweb$ecom$Order)) {
                throw new IllegalArgumentException("Expected value to be of type: " + (class$com$gentlyweb$ecom$Order == null ? (class$com$gentlyweb$ecom$Order = OrderManager.class$("com.gentlyweb.ecom.Order")) : class$com$gentlyweb$ecom$Order).getName() + ", got: " + value.getClass().getName());
            }
            this.putObject(key, value);
        }
    }

    public List findOrders(Account acc, GeneralFilter filter) throws DataStoreException {
        Searchable searcher;
        this.checkAction(acc, READ);
        List retData = new ArrayList();
        if (this.dataStore != null && (searcher = this.dataStore.getSearcher()) != null) {
            retData = searcher.getValues(filter);
        }
        return retData;
    }

    public synchronized boolean canOrderBeProcessed(Account acc, Order order) throws DataStoreException {
        this.checkAction(acc, READ);
        if (this.stockManager == null) {
            throw new DataStoreException("Unable to check to see if order: " + order.getID() + " can be processed since there is no StockManager set.");
        }
        List items = order.getItems();
        for (int i = 0; i < items.size(); ++i) {
            OrderItem item = (OrderItem)items.get(i);
            String id = item.getStockID();
            StockItem t = this.stockManager.getStockItem(acc, id);
            if (t == null) {
                throw new DataStoreException("Cannot find stock item for id: " + id + " for item: " + i + " from order: " + order.getID());
            }
            if (t.getQuantity() - item.getQuantity() >= 0) continue;
            return false;
        }
        return true;
    }

    public synchronized Date setOrderSent(Account acc, Order order) throws DataStoreException {
        if (order.getStatus().equals("sent")) {
            return order.getDateSent();
        }
        this.checkAction(acc, UPDATE);
        this.checkAction(acc, "stockUpdate");
        this.checkAction(acc, "stockRead");
        if (!this.canOrderBeProcessed(acc, order)) {
            throw new DataStoreException("Order: " + order.getID() + " cannot be processed since it would bring stock totals below zero.");
        }
        String u = "--NO USERNAME--";
        if (acc != null) {
            u = acc.getUsername();
        }
        List items = order.getItems();
        for (int i = 0; i < items.size(); ++i) {
            String template;
            OrderItem item = (OrderItem)items.get(i);
            String id = item.getStockID();
            StockItem t = this.stockManager.getStockItem(acc, id);
            if (t == null) {
                throw new DataStoreException("Cannot find stock item for id: " + id + " for item: " + i + " from order: " + order.getID());
            }
            if (this.templateManager != null && (template = this.templateManager.getTemplate(this.stockQuantityChangedTemplateName)) != null) {
                int o = t.getQuantity();
                int n = o - item.getQuantity();
                String note = new String(template);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("[[OLD]]", String.valueOf(o));
                map.put("[[NEW]]", String.valueOf(n));
                map.put("[[ID]]", order.getID());
                t.addNote(u, StringUtils.replaceAllStrings(template, map));
            }
            t.setQuantity(t.getQuantity() - item.getQuantity());
            this.stockManager.saveStockItem(acc, t);
        }
        if (this.templateManager != null) {
            String template = this.templateManager.getTemplate(this.orderStatusChangedTemplateName);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("[[NEW]]", "sent");
            map.put("[[OLD]]", order.getStatus());
            order.addNote(u, StringUtils.replaceAllStrings(template, map));
        }
        order.setStatus("sent");
        Date dateSent = new Date();
        order.setDateSent(dateSent);
        this.saveOrder(acc, order);
        return order.getDateSent();
    }

    public synchronized String getNewOrderID() throws DataStoreException {
        String id = String.valueOf(this.random.nextInt(999999));
        while (this.hasKey(id)) {
            id = String.valueOf(this.random.nextInt(999999));
        }
        return id;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

