/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.ecom;

import com.gentlyweb.ecom.Address;
import com.gentlyweb.ecom.Customer;
import com.gentlyweb.ecom.Note;
import com.gentlyweb.ecom.OrderItem;
import com.gentlyweb.xml.JDOMUtils;
import com.gentlyweb.xml.JDOMXmlOutputter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;

public class Order
implements JDOMXmlOutputter {
    public static final String CREATED = "created";
    public static final String PAID = "paid";
    public static final String CANCELLED = "cancelled";
    public static final String SENT = "sent";
    public static final String WEB = "web";
    public static final String FORM = "form";
    private String customerID = null;
    private Customer customer = null;
    private Address shippingAddress = null;
    private List items = new ArrayList();
    private Date orderDate = new Date();
    private Date dateSent = null;
    private String id = null;
    private float shipping = 0.0f;
    private String status = "created";
    private String currency = null;
    private String type = "web";
    private List notes = new ArrayList();

    public Order() {
    }

    public Order(Element root) throws JDOMException {
        JDOMUtils.checkName(root, "order", true);
        if (root.getChild("customerID") != null) {
            this.customerID = JDOMUtils.getChildElementContent(root, "customerID");
        }
        if (root.getChild("address") != null) {
            this.shippingAddress = new Address(JDOMUtils.getChildElement(root, "address"));
        }
        if (root.getAttribute("shipping") != null) {
            this.shipping = JDOMUtils.getAttributeValueAsFloat(root, "shipping");
        }
        this.currency = JDOMUtils.getAttributeValue(root, "currency");
        this.type = JDOMUtils.getAttributeValue(root, "type");
        this.id = JDOMUtils.getAttributeValue(root, "id");
        this.orderDate = JDOMUtils.getAttributeValueAsDate(root, "date");
        this.status = JDOMUtils.getAttributeValue(root, "status");
        if (root.getAttribute("dateSent") != null) {
            this.dateSent = JDOMUtils.getAttributeValueAsDate(root, "dateSent");
        }
        if (root.getChild("address") != null) {
            this.shippingAddress = new Address(JDOMUtils.getChildElement(root, "address"));
        }
        List itemEls = JDOMUtils.getChildElementSet(root, "items", "item", true);
        for (int i = 0; i < itemEls.size(); ++i) {
            Element el = (Element)itemEls.get(i);
            OrderItem item = new OrderItem(el);
            this.items.add(item);
        }
        List noteEls = JDOMUtils.getChildElementSet(root, "notes", "note", false);
        for (int i = 0; i < noteEls.size(); ++i) {
            Element el = (Element)noteEls.get(i);
            Note note = new Note(el);
            this.notes.add(note);
        }
    }

    public void setCustomer(Customer cust) {
        this.customer = cust;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String cur) {
        this.currency = cur;
    }

    public void setShippingAddress(Address addr) {
        this.shippingAddress = addr;
    }

    public Address getShippingAddress() {
        return this.shippingAddress;
    }

    public int getItemsSize() {
        int total = 0;
        for (int i = 0; i < this.items.size(); ++i) {
            OrderItem item = (OrderItem)this.items.get(i);
            total += item.getQuantity();
        }
        return total;
    }

    public void setItems(List items) {
        for (int i = 0; i < items.size(); ++i) {
            OrderItem item = (OrderItem)items.get(i);
            this.items.add(item);
        }
    }

    public void setCustomerID(String id) {
        this.customerID = id;
    }

    public String getCustomerID() {
        return this.customerID;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void addItem(OrderItem item) {
        this.items.add(item);
    }

    public List getItems() {
        return this.items;
    }

    public Date getDate() {
        return this.orderDate;
    }

    public void setDateSent(Date date) {
        this.dateSent = date;
    }

    public Date getDateSent() {
        return this.dateSent;
    }

    void setID(String id) {
        this.id = id;
    }

    public String getID() {
        return this.id;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public void setShipping(float s) {
        this.shipping = s;
    }

    public float getShipping() {
        return this.shipping;
    }

    public float getTotalCost() {
        return this.getTotalItemsCost() + this.shipping;
    }

    public float getTotalItemsCost() {
        float total = 0.0f;
        for (int i = 0; i < this.items.size(); ++i) {
            OrderItem item = (OrderItem)this.items.get(i);
            total += item.getItemCost();
        }
        return total;
    }

    public void addNote(Note note) {
        this.notes.add(note);
    }

    public void addNote(String username, String text) {
        Note note = new Note(username, text, new Date());
        this.notes.add(note);
    }

    public List getNotes() {
        return this.notes;
    }

    public Element getAsJDOMElement() {
        Element root = new Element("order");
        root.setAttribute("id", this.id);
        root.setAttribute("type", this.type);
        root.setAttribute("date", String.valueOf(this.orderDate.getTime()));
        if (this.shipping != 0.0f) {
            root.setAttribute("shipping", String.valueOf(this.shipping));
        }
        root.setAttribute("currency", this.currency);
        root.setAttribute("status", this.status);
        if (this.dateSent != null) {
            root.setAttribute("dateSent", String.valueOf(this.dateSent.getTime()));
        }
        root.addContent((Content)new Element("customerID").addContent((Content)new CDATA(this.customerID)));
        if (this.shippingAddress != null) {
            root.addContent((Content)this.shippingAddress.getAsJDOMElement());
        }
        Element items = new Element("items");
        root.addContent((Content)items);
        for (int i = 0; i < this.items.size(); ++i) {
            OrderItem item = (OrderItem)this.items.get(i);
            items.addContent((Content)item.getAsJDOMElement());
        }
        if (this.notes.size() > 0) {
            Element notes = new Element("notes");
            root.addContent((Content)notes);
            for (int i = 0; i < this.notes.size(); ++i) {
                Note note = (Note)this.notes.get(i);
                notes.addContent((Content)note.getAsJDOMElement());
            }
        }
        return root;
    }

    public class XMLConstants {
        public static final String root = "order";
        public static final String address = "address";
        public static final String items = "items";
        public static final String item = "item";
        public static final String date = "date";
        public static final String id = "id";
        public static final String shipping = "shipping";
        public static final String cost = "cost";
        public static final String currency = "currency";
        public static final String status = "status";
        public static final String dateSent = "dateSent";
        public static final String quantity = "quantity";
        public static final String size = "size";
        public static final String colour = "colour";
        public static final String type = "type";
        public static final String notes = "notes";
        public static final String note = "note";
        public static final String customerID = "customerID";
    }
}

