/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.ecom;

import com.gentlyweb.datastore.DataStoreException;
import com.gentlyweb.datastore.Searchable;
import com.gentlyweb.ecom.ACL;
import com.gentlyweb.ecom.AbstractDataManager;
import com.gentlyweb.ecom.Account;
import com.gentlyweb.ecom.Customer;
import com.gentlyweb.utils.GeneralFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CustomerManager
extends AbstractDataManager {
    public static final String UPDATE = "orderUpdate";
    public static final String DELETE = "orderDelete";
    public static final String READ = "orderRead";
    private ACL acl = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$gentlyweb$ecom$Customer;

    public CustomerManager(boolean cache, int policy) {
        super(cache, policy);
    }

    public void setACL(ACL acl) {
        this.acl = acl;
    }

    public void saveCustomer(Account acc, Customer cust) throws DataStoreException {
        this.checkAction(acc, UPDATE);
        this.putObject(cust.getID(), cust);
    }

    private void checkAction(Account acc, String act) throws DataStoreException {
        if (this.acl != null) {
            if (acc == null) {
                throw new DataStoreException("No account passed.");
            }
            if (!this.acl.actionAllowed(acc.getType(), acc.getUsername(), act)) {
                throw new DataStoreException("Account: " + acc.getType() + "/" + acc.getUsername() + " does not have the: " + act + " action allowed.");
            }
        }
    }

    public List findCustomers(Account acc, GeneralFilter filter) throws DataStoreException {
        Searchable searcher;
        this.checkAction(acc, READ);
        List retData = new ArrayList();
        if (this.dataStore != null && (searcher = this.dataStore.getSearcher()) != null) {
            retData = searcher.getValues(filter);
        }
        return retData;
    }

    public Customer getCustomer(Account acc, String id) throws DataStoreException {
        this.checkAction(acc, READ);
        return (Customer)this.getObject(id);
    }

    public boolean hasCustomer(Account acc, Customer cust) throws DataStoreException {
        this.checkAction(acc, READ);
        return this.hasKey(cust.getID());
    }

    public synchronized List getCustomers(Account acc, String id) throws DataStoreException {
        this.checkAction(acc, READ);
        GeneralFilter f = new GeneralFilter(class$java$lang$String == null ? (class$java$lang$String = CustomerManager.class$("java.lang.String")) : class$java$lang$String);
        f.addField("toString", id, 3);
        return this.getObjects(f);
    }

    public synchronized List getAllCustomers(Account acc) throws DataStoreException {
        this.checkAction(acc, READ);
        return this.getAllObjects();
    }

    public void addAll(Account acc, Map map) throws IllegalArgumentException, DataStoreException {
        this.checkAction(acc, UPDATE);
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            Object value = map.get(key);
            if (!(key instanceof String)) {
                throw new IllegalArgumentException("Expected key to be of type: " + (class$java$lang$String == null ? (class$java$lang$String = CustomerManager.class$("java.lang.String")) : class$java$lang$String).getName() + ", got: " + key.getClass().getName());
            }
            if (!value.getClass().isAssignableFrom(class$com$gentlyweb$ecom$Customer == null ? CustomerManager.class$("com.gentlyweb.ecom.Customer") : class$com$gentlyweb$ecom$Customer)) {
                throw new IllegalArgumentException("Expected value to be of type: " + (class$com$gentlyweb$ecom$Customer == null ? (class$com$gentlyweb$ecom$Customer = CustomerManager.class$("com.gentlyweb.ecom.Customer")) : class$com$gentlyweb$ecom$Customer).getName() + ", got: " + value.getClass().getName());
            }
            this.putObject(key, value);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

