/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.ecom;

import com.gentlyweb.ecom.EComException;
import com.gentlyweb.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CartItem
implements Comparable {
    public static final String DEFAULT_COOKIE_NAME_VALUE_PAIR_DELIMITER = ":";
    public static final String DEFAULT_COOKIE_VALUE_PAIR_DELIMITER = "&";
    private String nameValuePairDelimiter = ":";
    private String valuePairDelimiter = "&";
    public static final String UTF_8 = "utf-8";
    private static final String STOCK_ID = "id";
    private static final String QUANTITY = "q";
    private String stockID = "";
    private int id = 0;
    private int quantity = 0;
    private Map attributes = new HashMap();

    public CartItem() {
    }

    public CartItem(String name, String value, String nvPairDelimiter, String vPairDelimiter) throws EComException {
        this.id = this.getNumber(name);
        this.valuePairDelimiter = vPairDelimiter;
        this.nameValuePairDelimiter = nvPairDelimiter;
        List tokens = StringUtils.tokenizeString(value, this.valuePairDelimiter);
        for (int i = 0; i < tokens.size(); ++i) {
            String s = (String)tokens.get(i);
            List nv = StringUtils.tokenizeString(s, this.nameValuePairDelimiter);
            if (nv.size() != 2) continue;
            String item0 = (String)nv.get(0);
            String item1 = (String)nv.get(1);
            if (item0.equals(STOCK_ID)) {
                this.stockID = item1;
                continue;
            }
            if (item0.equals(QUANTITY)) {
                try {
                    this.quantity = Integer.parseInt(item1);
                }
                catch (NumberFormatException e) {}
                continue;
            }
            this.attributes.put(item0, item1);
        }
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public void addAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    public String getAttribute(String name) {
        return (String)this.attributes.get(name);
    }

    private int getNumber(String val) throws EComException {
        char[] chars = val.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (!Character.isDigit(chars[i])) continue;
            String s = val.substring(i);
            try {
                return Integer.parseInt(s);
            }
            catch (Exception e) {
                throw new EComException("Value: " + val + " does not contain a parseable number at the end of the String.");
            }
        }
        throw new EComException("Value: " + val + " does not contain a parseable number at the end of the String.");
    }

    public void setQuantity(int quantity) {
        if (quantity > 0) {
            this.quantity = quantity;
        }
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setStockID(String id) {
        this.stockID = id;
    }

    public String getStockID() {
        return this.stockID;
    }

    public String encode() {
        String nvD = this.nameValuePairDelimiter;
        String vD = this.valuePairDelimiter;
        StringBuffer b = new StringBuffer(STOCK_ID);
        b.append(nvD);
        b.append(this.stockID);
        b.append(vD);
        b.append(QUANTITY);
        b.append(nvD);
        b.append(this.quantity);
        if (this.attributes.size() > 0) {
            Iterator iter = this.attributes.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                String val = (String)this.attributes.get(key);
                b.append(vD);
                b.append(key);
                b.append(nvD);
                b.append(val);
            }
        }
        String retVal = b.toString();
        try {
            retVal = URLEncoder.encode(retVal, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        return retVal;
    }

    public void setID(int id) {
        this.id = id;
    }

    public int getID() {
        return this.id;
    }

    public int compareTo(Object o) {
        CartItem i = (CartItem)o;
        return new Integer(this.id).compareTo(new Integer(i.getID()));
    }

    public boolean canMerge(CartItem item) {
        if (item == null) {
            return false;
        }
        return item.getStockID().equals(this.stockID);
    }

    public void addQuantity(int value) {
        this.quantity += value;
    }

    public String toString() {
        String s = this.encode();
        try {
            return URLDecoder.decode(s, UTF_8);
        }
        catch (Exception e) {
            return "Unable to decode result of: encode call";
        }
    }
}

