/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.ecom;

import com.gentlyweb.datastore.DataStore;
import com.gentlyweb.datastore.DataStoreException;
import com.gentlyweb.utils.MultipleObjectCacheManager;
import com.gentlyweb.utils.ObjectCache;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AbstractMultiDataManager
implements MultipleObjectCacheManager {
    private Map dataStores = new HashMap();
    private Map caches = new HashMap();
    private int defaultPolicy = 1;

    public void setDataStore(DataStore dataStore, Object key) {
        this.dataStores.put(key, dataStore);
    }

    public void setDefaultCachingPolicy(int policy) {
        this.defaultPolicy = policy;
    }

    public void setCachingOff(Object type) {
        ObjectCache oc = (ObjectCache)this.caches.get(type);
        if (oc != null) {
            oc.flush();
            this.caches.remove(type);
        }
    }

    public void setCachingOn(Object type, int maxSize, int policy) {
        ObjectCache oc = (ObjectCache)this.caches.get(type);
        if (oc == null) {
            oc = new ObjectCache(policy);
            oc.setMaxSize(maxSize);
            this.caches.put(type, oc);
        }
    }

    public synchronized void initCache(Object type) throws DataStoreException, IllegalStateException {
        if (!this.caches.containsKey(type)) {
            throw new IllegalStateException("Cannot init cache when caching is not on for type: " + type.toString());
        }
        if (!this.dataStores.containsKey(type)) {
            throw new IllegalStateException("No DataStore available for type: " + type.toString());
        }
        ObjectCache oc = (ObjectCache)this.caches.get(type);
        DataStore ds = (DataStore)this.dataStores.get(type);
        List keys = ds.keys();
        for (int i = 0; i < keys.size(); ++i) {
            Object key = keys.get(i);
            Object value = ds.get(key);
            oc.put(key, value);
        }
    }

    protected void putObject(Object type, Object key, Object obj) throws DataStoreException {
        DataStore ds = (DataStore)this.dataStores.get(type);
        if (ds != null) {
            try {
                ds.put(key, obj);
            }
            catch (DataStoreException e) {
                ObjectCache oc = (ObjectCache)this.caches.get(key);
                if (oc != null) {
                    oc.remove(key);
                }
                throw new DataStoreException(e.getMessage(), e.getException());
            }
        }
        this.updateCache(type, key, obj);
    }

    protected synchronized Object getObjectFromCache(Object type, Object key) {
        ObjectCache cache = (ObjectCache)this.caches.get(type);
        if (cache != null) {
            return cache.get(key);
        }
        return null;
    }

    protected synchronized Object getObjectFromDataStore(Object type, Object key) throws DataStoreException {
        DataStore ds = (DataStore)this.dataStores.get(type);
        if (ds == null) {
            return null;
        }
        return ds.get(key);
    }

    protected synchronized void updateCache(Object type, Object key, Object obj) {
        ObjectCache cache = (ObjectCache)this.caches.get(type);
        if (cache != null) {
            cache.put(key, obj);
        }
    }

    public synchronized Object getObject(Object type, Object key) throws DataStoreException {
        Object obj = this.getObjectFromCache(type, key);
        if (obj != null) {
            return obj;
        }
        obj = this.getObjectFromDataStore(type, key);
        if (obj != null) {
            this.updateCache(type, key, obj);
        }
        return obj;
    }

    public void resize(Object type, int size) {
        ObjectCache c = (ObjectCache)this.caches.get(type);
        if (c != null) {
            c.resize(size);
        }
    }

    public int capacity(Object type) {
        ObjectCache c = (ObjectCache)this.caches.get(type);
        if (c != null) {
            return c.capacity();
        }
        return -1;
    }

    public boolean isEmpty(Object type) {
        ObjectCache c = (ObjectCache)this.caches.get(type);
        if (c != null) {
            return c.isEmpty();
        }
        return true;
    }

    public void setMaxSize(Object type, int size) {
        ObjectCache c = (ObjectCache)this.caches.get(type);
        if (c != null) {
            c.setMaxSize(size);
        }
    }

    public void toMap(Object key, Map map) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This method is not supported.");
    }

    public void merge(Object type, ObjectCache cache) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This method is not supported.");
    }

    public synchronized void setPolicy(Object type, int policy) {
        ObjectCache oc = (ObjectCache)this.caches.get(type);
        if (oc != null) {
            oc.setPolicy(policy);
        }
    }

    public synchronized void putAll(Object type, Map map) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This method is not supported.");
    }

    public boolean hasKey(Object type, Object key) throws DataStoreException {
        ObjectCache c = (ObjectCache)this.caches.get(type);
        if (c != null && c.containsKey(key)) {
            return true;
        }
        DataStore ds = (DataStore)this.dataStores.get(key);
        if (ds != null) {
            return ds.containsKey(key);
        }
        return false;
    }

    public synchronized void flush(Object type) {
        ObjectCache oc = (ObjectCache)this.caches.get(type);
        if (oc != null) {
            oc.flush();
        }
    }

    public synchronized void flush() {
        Iterator iter = this.caches.keySet().iterator();
        while (iter.hasNext()) {
            ObjectCache cache = (ObjectCache)this.caches.get(iter.next());
            cache.flush();
        }
    }
}

