/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.cron;

import com.gentlyweb.cron.RepeatTask;
import com.gentlyweb.cron.RepeatTaskInfo;
import com.gentlyweb.cron.TaskException;
import com.gentlyweb.logging.Logger;
import com.gentlyweb.xml.JDOMUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import org.jdom.Element;
import org.jdom.JDOMException;

public class RepeatTasksManager
implements Runnable {
    private Map tasks = new HashMap();
    private Map timers = new HashMap();
    private Timer main = null;
    private String timeFormat = "";
    private String dateFormat = "";
    private String timeZone = "";
    private Logger logger = null;

    public RepeatTasksManager(Element root) throws TaskException, JDOMException {
        this(root, null);
    }

    public RepeatTasksManager(File f, String zipExtension) throws TaskException, JDOMException, IOException {
        this(f, zipExtension, null);
    }

    public RepeatTasksManager(File f, String zipExtension, Logger logger) throws TaskException, JDOMException, IOException {
        this(JDOMUtils.getFileAsElement(f, zipExtension), logger);
    }

    public RepeatTasksManager(Element root, Logger logger) throws TaskException, JDOMException {
        RepeatTaskInfo taskInfo;
        RepeatTask task;
        this.logger = logger;
        TreeMap<Integer, RepeatTask> runOnLoad = new TreeMap<Integer, RepeatTask>();
        JDOMUtils.checkName(root, "repeatedTasks", true);
        List taskels = JDOMUtils.getChildElements(root, "task", false);
        this.timeFormat = JDOMUtils.getAttributeValue(root, "timeFormat", false);
        this.dateFormat = JDOMUtils.getAttributeValue(root, "dateFormat", false);
        this.timeZone = JDOMUtils.getAttributeValue(root, "timeZone", false);
        for (int i = 0; i < taskels.size(); ++i) {
            Element el = (Element)taskels.get(i);
            RepeatTask task2 = null;
            try {
                task2 = new RepeatTask(el, this.timeFormat, this.dateFormat, this.timeZone);
            }
            catch (Exception e) {
                throw new TaskException("Unable to create new RepeatTask object, root cause: " + e.getMessage(), e);
            }
            RepeatTaskInfo taskInfo2 = task2.getTaskInfo();
            if (this.tasks.containsKey(taskInfo2.getID())) {
                throw new TaskException("Found duplicate repeat task: " + taskInfo2.getID());
            }
            this.tasks.put(taskInfo2.getID(), task2);
            if (this.logger != null) {
                task2.setLogger(this.logger);
                this.logger.logInformationMessage(task2.toString());
            }
            if (taskInfo2.getRunOnLoad() == -1) continue;
            runOnLoad.put(new Integer(taskInfo2.getRunOnLoad()), task2);
        }
        Iterator iter = runOnLoad.keySet().iterator();
        while (iter.hasNext()) {
            task = (RepeatTask)runOnLoad.get(iter.next());
            taskInfo = task.getTaskInfo();
            if (this.logger != null) {
                this.logger.logInformationMessage("Running task: " + taskInfo.getID() + " at start-up with runonload: " + taskInfo.getRunOnLoad());
            }
            task.run();
            if (this.logger == null) continue;
            this.logger.logInformationMessage("Finished start-up task: " + taskInfo.getID());
        }
        iter = this.tasks.keySet().iterator();
        while (iter.hasNext()) {
            task = (RepeatTask)this.tasks.get(iter.next());
            taskInfo = task.getTaskInfo();
            if (taskInfo.getRepeatTime() > 0) {
                long repeatTime = taskInfo.getRepeatTimeInMillis();
                if (taskInfo.isOwnTimer() || taskInfo.isRunAsDaemon()) {
                    Timer t = new Timer(taskInfo.isRunAsDaemon());
                    this.timers.put(taskInfo.getID(), t);
                    t.scheduleAtFixedRate((TimerTask)task, taskInfo.getStartTime(), repeatTime);
                    if (this.logger == null) continue;
                    this.logger.logInformationMessage("Scheduled task: " + taskInfo.getID() + " to run in own Timer, start at: " + logger.formatDate(taskInfo.getStartTime()) + " and execute every: " + taskInfo.getRepeatTime() + " " + taskInfo.getUnits());
                    continue;
                }
                if (this.main == null) {
                    this.main = new Timer();
                }
                this.main.scheduleAtFixedRate((TimerTask)task, taskInfo.getStartTime(), repeatTime);
                if (this.logger == null) continue;
                this.logger.logInformationMessage("Scheduled task: " + taskInfo.getID() + " to run in main Timer, start at: " + logger.formatDate(taskInfo.getStartTime()) + " and execute every: " + taskInfo.getRepeatTime() + " " + taskInfo.getUnits());
                continue;
            }
            if (taskInfo.getRunOnLoad() == -1 || this.logger == null) continue;
            this.logger.logWarningMessage("Task: " + taskInfo.getID() + " has a repeat time of 0 and no runonload value so will NOT be ever executed");
        }
        Runtime.getRuntime().addShutdownHook(new Thread(this));
    }

    public void run() {
        Object t;
        Object key;
        Iterator iter = this.tasks.keySet().iterator();
        while (iter.hasNext()) {
            key = iter.next();
            t = (RepeatTask)this.tasks.get(key);
            ((TimerTask)t).cancel();
        }
        iter = this.timers.keySet().iterator();
        while (iter.hasNext()) {
            key = iter.next();
            t = (Timer)this.timers.get(key);
            ((Timer)t).cancel();
        }
    }

    public RepeatTaskInfo getTaskInfo(String id) {
        if (this.tasks.containsKey(id)) {
            RepeatTask t = (RepeatTask)this.tasks.get(id);
            return t.getTaskInfo();
        }
        return null;
    }

    public class XMLConstants {
        public static final String root = "repeatedTasks";
        public static final String task = "task";
        public static final String startTime = "startTime";
        public static final String startDate = "startDate";
        public static final String timeFormat = "timeFormat";
        public static final String dateFormat = "dateFormat";
        public static final String timeZone = "timeZone";
    }
}

