/*
 * Decompiled with CFR 0.152.
 */
package com.gentlyweb.cron;

import com.gentlyweb.cron.RepeatTaskInfo;
import com.gentlyweb.cron.RepeatTaskInitializer;
import com.gentlyweb.cron.RepeatTaskListener;
import com.gentlyweb.cron.TaskException;
import com.gentlyweb.logging.Logger;
import com.gentlyweb.properties.Properties;
import com.gentlyweb.properties.PropertyException;
import com.gentlyweb.xml.JDOMUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TimerTask;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;

public class RepeatTask
extends TimerTask {
    public static final String MINUTE = "minute";
    public static final String DAY = "day";
    public static final String HOUR = "hour";
    private RepeatTaskInfo info = new RepeatTaskInfo();
    private Runnable task = null;
    private Class clazz = null;
    private Map initParms = new HashMap();
    private Properties properties = null;
    private boolean autoInitProperties = false;
    private Logger logger = null;
    private List listeners = new ArrayList();
    static /* synthetic */ Class class$java$lang$Runnable;
    static /* synthetic */ Class class$com$gentlyweb$cron$RepeatTaskListener;
    static /* synthetic */ Class class$com$gentlyweb$cron$RepeatTaskInitializer;
    static /* synthetic */ Class class$com$gentlyweb$logging$Logger;

    public RepeatTask(Element root, String timeFormat, String dateFormat, String timeZone) throws JDOMException, IllegalAccessException, InstantiationException, InvocationTargetException, ClassNotFoundException, IOException, PropertyException, TaskException {
        Element initparamsel;
        TimeZone tZ = TimeZone.getDefault();
        this.info.setTimeFormat(timeFormat);
        this.info.setDateFormat(dateFormat);
        if (timeZone != null) {
            tZ = TimeZone.getTimeZone(timeZone);
        }
        JDOMUtils.checkName(root, "task", true);
        this.info.setID(JDOMUtils.getAttributeValue(root, "id"));
        String c = JDOMUtils.getAttributeValue(root, "class");
        this.info.setTaskClass(c);
        this.clazz = Class.forName(c);
        if (!(class$java$lang$Runnable == null ? (class$java$lang$Runnable = RepeatTask.class$("java.lang.Runnable")) : class$java$lang$Runnable).isAssignableFrom(this.clazz)) {
            Attribute a = JDOMUtils.getAttribute(root, "class", true);
            throw new TaskException("Repeat task class: " + c + " referenced by: " + JDOMUtils.getPath(a) + " does not implement: " + (class$java$lang$Runnable == null ? (class$java$lang$Runnable = RepeatTask.class$("java.lang.Runnable")) : class$java$lang$Runnable).getName());
        }
        this.task = null;
        try {
            this.task = (Runnable)this.clazz.newInstance();
        }
        catch (Exception e) {
            Attribute a = JDOMUtils.getAttribute(root, "class", true);
            throw new TaskException("Unable to create new instance of: " + c + " referenced by: " + JDOMUtils.getPath(a), e);
        }
        this.info.setExecutionLimit(JDOMUtils.getAttributeValueAsInt(root, "executionLimit", false));
        this.info.setRunAsDaemon(JDOMUtils.getAttributeValueAsBoolean(root, "runAsDaemon", false));
        this.info.setRepeatTime(JDOMUtils.getAttributeValueAsInt(root, "repeatTime"));
        if (this.info.getRepeatTime() != 0) {
            String units = JDOMUtils.getAttributeValue(root, "units");
            if (!(units.equals(MINUTE) || units.equals(HOUR) || units.equals(DAY))) {
                throw new JDOMException("Attribute: " + JDOMUtils.getPath(root.getAttribute("units")) + " value must be one of: " + MINUTE + "|" + HOUR + "|" + DAY);
            }
            this.info.setUnits(units);
            Attribute sD = root.getAttribute("startDate");
            Attribute sT = root.getAttribute("startTime");
            Attribute sA = root.getAttribute("startAfter");
            int attrCount = 0;
            if (sA != null) {
                ++attrCount;
            }
            if (sT != null) {
                ++attrCount;
            }
            if (sD != null) {
                ++attrCount;
            }
            if (attrCount > 1) {
                throw new JDOMException("The attributes: startTime, startDate, startAfter are mutually exclusive for the element: " + JDOMUtils.getPath(root));
            }
            Calendar cal = Calendar.getInstance(tZ);
            cal.setTime(new Date(System.currentTimeMillis() + this.info.getRepeatTimeInMillis()));
            this.info.setStartTime(cal.getTime());
            if (sA != null) {
                int s = JDOMUtils.getAttributeValueAsInt(root, "startAfter");
                cal = Calendar.getInstance(tZ);
                cal.setTime(new Date(System.currentTimeMillis() + 1000L * (long)s));
                this.info.setStartTime(cal.getTime());
            }
            if (sT != null) {
                String s = JDOMUtils.getAttributeValue(root, "startTime");
                SimpleDateFormat df = new SimpleDateFormat(timeFormat);
                Date d = null;
                try {
                    d = df.parse(s);
                    cal = Calendar.getInstance(tZ);
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    long t = cal.getTime().getTime();
                    cal = Calendar.getInstance(tZ);
                    cal.setTime(new Date(t + d.getTime()));
                    this.info.setStartTime(cal.getTime());
                    if (this.info.getStartTime().getTime() < Calendar.getInstance(tZ).getTime().getTime()) {
                        this.info.setStartTime(new Date(this.info.getStartTime().getTime() + 86400000L));
                    }
                }
                catch (ParseException ee) {
                    throw new JDOMException("Attribute: " + JDOMUtils.getPath(sT) + " with value: " + s + " must be either a number or time with format: " + timeFormat);
                }
            }
            if (sD != null) {
                String v = JDOMUtils.getAttributeValue(root, "startDate");
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
                    cal = Calendar.getInstance(tZ);
                    cal.setTime(sdf.parse(v));
                    long curT = Calendar.getInstance(tZ).getTime().getTime();
                    if (cal.getTime().getTime() > curT) {
                        this.info.setStartTime(cal.getTime());
                    }
                }
                catch (ParseException e) {
                    throw new JDOMException("Attribute: " + JDOMUtils.getPath(sD) + " does not contain a valid date formatted string, root cause: " + e.getMessage());
                }
            }
        }
        List listenerEls = JDOMUtils.getChildElements(root, "listener", false);
        for (int i = 0; i < listenerEls.size(); ++i) {
            Element e = (Element)listenerEls.get(i);
            Attribute ol = e.getAttribute("taskIsOwnListener");
            Attribute cl = e.getAttribute("class");
            if (ol == null && cl == null) {
                throw new JDOMException("Either the: taskIsOwnListener (path: " + JDOMUtils.getPath(ol) + ") or: " + "class" + " (path: " + JDOMUtils.getPath(cl) + ") attribute must be specified on element: " + JDOMUtils.getPath(e));
            }
            if (ol != null && cl != null) {
                throw new JDOMException("Attributes: taskIsOwnListener (path: " + JDOMUtils.getPath(ol) + ") and: " + "class" + " (path: " + JDOMUtils.getPath(ol) + ") are mutually exlusive on element: " + JDOMUtils.getPath(e));
            }
            RepeatTaskListener l = null;
            if (ol != null && JDOMUtils.getAttributeValueAsBoolean(e, "taskIsOwnListener")) {
                if (!(class$com$gentlyweb$cron$RepeatTaskListener == null ? RepeatTask.class$("com.gentlyweb.cron.RepeatTaskListener") : class$com$gentlyweb$cron$RepeatTaskListener).isAssignableFrom(this.clazz)) {
                    Attribute a = JDOMUtils.getAttribute(root, "class", true);
                    throw new JDOMException("Repeat task class: " + c + " refereneced by: " + JDOMUtils.getPath(a) + " does not implement: " + (class$com$gentlyweb$cron$RepeatTaskListener == null ? (class$com$gentlyweb$cron$RepeatTaskListener = RepeatTask.class$("com.gentlyweb.cron.RepeatTaskListener")) : class$com$gentlyweb$cron$RepeatTaskListener).getName());
                }
                l = (RepeatTaskListener)((Object)this.task);
            }
            if (cl != null) {
                String cN;
                Class<?> clazz;
                if (!(class$com$gentlyweb$cron$RepeatTaskListener == null ? RepeatTask.class$("com.gentlyweb.cron.RepeatTaskListener") : class$com$gentlyweb$cron$RepeatTaskListener).isAssignableFrom(clazz = Class.forName(cN = JDOMUtils.getAttributeValue(e, "class")))) {
                    throw new JDOMException("Value: " + cN + " of attribute: " + JDOMUtils.getPath(e.getAttribute("class")) + " does not implement: " + (class$com$gentlyweb$cron$RepeatTaskListener == null ? (class$com$gentlyweb$cron$RepeatTaskListener = RepeatTask.class$("com.gentlyweb.cron.RepeatTaskListener")) : class$com$gentlyweb$cron$RepeatTaskListener).getName());
                }
                l = (RepeatTaskListener)clazz.newInstance();
            }
            int threshold = JDOMUtils.getAttributeValueAsInt(e, "timingThreshold", false);
            if (l == null) continue;
            Listener list = new Listener();
            list.listener = l;
            list.threshold = threshold;
            this.listeners.add(list);
        }
        this.info.setRunOnLoad(JDOMUtils.getAttributeValueAsInt(root, "runOnLoad", false));
        this.info.setDescription(JDOMUtils.getChildElementContent(root, "description"));
        this.info.setOwnTimer(JDOMUtils.getAttributeValueAsBoolean(root, "ownTimer", false));
        Element propsEl = JDOMUtils.getChildElement(root, "properties", false);
        if (propsEl != null) {
            File propsFile = new File(JDOMUtils.getChildContent(propsEl));
            if (!propsFile.exists()) {
                throw new JDOMException("Content of: " + JDOMUtils.getPath(propsEl) + " element: " + propsFile.getPath() + " does not point to a valid file in the file system.");
            }
            String zipExtension = JDOMUtils.getAttributeValue(propsEl, "zipExtension");
            this.autoInitProperties = JDOMUtils.getAttributeValueAsBoolean(propsEl, "autoInit", false);
            this.properties = new Properties(propsFile, zipExtension);
            if (this.autoInitProperties) {
                Object mapper = null;
                if (propsEl.getAttribute("nameMapper") != null) {
                    String mapperName = JDOMUtils.getAttributeValue(propsEl, "nameMapper");
                    Class<?> mapClazz = Class.forName(mapperName);
                    mapper = mapClazz.newInstance();
                }
                Properties.setPropertiesInObject(this.task, mapper, this.properties);
            } else if ((class$com$gentlyweb$cron$RepeatTaskInitializer == null ? (class$com$gentlyweb$cron$RepeatTaskInitializer = RepeatTask.class$("com.gentlyweb.cron.RepeatTaskInitializer")) : class$com$gentlyweb$cron$RepeatTaskInitializer).isAssignableFrom(this.clazz)) {
                RepeatTaskInitializer r = (RepeatTaskInitializer)((Object)this.task);
                r.setProperties(this.properties);
            }
        }
        if ((initparamsel = JDOMUtils.getChildElement(root, "initParams", false)) != null) {
            List paramels = JDOMUtils.getChildElements(initparamsel, "param", true);
            for (int i = 0; i < paramels.size(); ++i) {
                Element el = (Element)paramels.get(i);
                this.initParms.put(JDOMUtils.getChildElementContent(el, "name"), JDOMUtils.getChildElementContent(el, "value"));
            }
            if ((class$com$gentlyweb$cron$RepeatTaskInitializer == null ? (class$com$gentlyweb$cron$RepeatTaskInitializer = RepeatTask.class$("com.gentlyweb.cron.RepeatTaskInitializer")) : class$com$gentlyweb$cron$RepeatTaskInitializer).isAssignableFrom(this.clazz)) {
                RepeatTaskInitializer r = (RepeatTaskInitializer)((Object)this.task);
                r.setInitParms(this.initParms);
            }
        }
    }

    public void run() {
        Object l;
        int i;
        long execTime = 0L;
        Class[] argTypes = new Class[]{class$com$gentlyweb$logging$Logger == null ? (class$com$gentlyweb$logging$Logger = RepeatTask.class$("com.gentlyweb.logging.Logger")) : class$com$gentlyweb$logging$Logger};
        try {
            Method meth = this.task.getClass().getMethod("run", argTypes);
            Object[] args = new Object[]{this.logger};
            long start = System.currentTimeMillis();
            meth.invoke((Object)this.task, args);
            execTime = System.currentTimeMillis() - start;
        }
        catch (Exception e) {
            long start = System.currentTimeMillis();
            this.task.run();
            execTime = System.currentTimeMillis() - start;
        }
        int execCount = this.info.incrementExecutionCount();
        long end = System.currentTimeMillis();
        this.info.addTiming(execTime);
        for (i = 0; i < this.listeners.size(); ++i) {
            l = (Listener)this.listeners.get(i);
            if (((Listener)l).threshold <= 0 || execTime <= (long)((Listener)l).threshold) continue;
            ((Listener)l).listener.timingThresholdPassed(execTime, this.info.getTotalExecutionTime(), this.info.getExecutionCount(), ((Listener)l).threshold, this);
        }
        if (this.info.getExecutionLimit() > 1 && execCount == this.info.getExecutionLimit()) {
            if (this.logger != null) {
                this.logger.logInformationMessage("Reached execution limit: " + this.info.getExecutionLimit() + " cancelling repeating task.");
            }
            this.cancel();
            for (i = 0; i < this.listeners.size(); ++i) {
                l = ((Listener)this.listeners.get(i)).listener;
                l.executionLimitReached(this.info.getExecutionCount(), this);
            }
            return;
        }
    }

    public RepeatTaskInfo getTaskInfo() {
        return this.info;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    protected void stopTask() {
        this.cancel();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.info.toString());
        if (this.listeners.size() > 0) {
            buf.append("        Listeners: \n");
            for (int i = 0; i < this.listeners.size(); ++i) {
                Listener l = (Listener)this.listeners.get(i);
                buf.append("      Repeat Time: ");
                buf.append("            Class: ");
                buf.append(l.listener.getClass().getName());
                buf.append('\n');
                buf.append("        Threshold: ");
                buf.append(l.threshold);
                buf.append('\n');
                buf.append("Task is own listener: ");
                if (l == this.task) {
                    buf.append("YES");
                    continue;
                }
                buf.append("NO");
            }
        }
        return buf.toString();
    }

    public Runnable getTask() {
        return this.task;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Listener {
        private RepeatTaskListener listener = null;
        private int threshold = 0;

        private Listener() {
        }
    }

    public class XMLConstants {
        public static final String id = "id";
        public static final String root = "task";
        public static final String clazz = "class";
        public static final String repeatTime = "repeatTime";
        public static final String units = "units";
        public static final String runOnLoad = "runOnLoad";
        public static final String description = "description";
        public static final String ownTimer = "ownTimer";
        public static final String initParams = "initParams";
        public static final String param = "param";
        public static final String name = "name";
        public static final String value = "value";
        public static final String startTime = "startTime";
        public static final String startDate = "startDate";
        public static final String startAfter = "startAfter";
        public static final String properties = "properties";
        public static final String autoInit = "autoInit";
        public static final String zipExtension = "zipExtension";
        public static final String nameMapper = "nameMapper";
        public static final String executionLimit = "executionLimit";
        public static final String runAsDaemon = "runAsDaemon";
        public static final String listener = "listener";
        public static final String timingThreshold = "timingThreshold";
        public static final String taskIsOwnListener = "taskIsOwnListener";
    }
}

