/*
 * Decompiled with CFR 0.152.
 */
package org.kobjects.jdbc.ram;

import java.io.File;
import java.io.FileWriter;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;
import org.kobjects.jdbc.TableManager;
import org.kobjects.jdbc.stream.ReaderResultSet;
import org.kobjects.jdbc.util.AbstractTable;

public class RamTable
extends AbstractTable
implements Runnable {
    Vector rows = new Vector();
    ReaderResultSet reader;
    String file;
    boolean modified = false;

    public RamTable() {
    }

    public RamTable(String type, String file, Properties properties) throws SQLException {
        this.reader = (ReaderResultSet)TableManager.getResultSet(type, file, properties);
        this.file = file;
        int i = 1;
        while (i <= this.reader.getColumnSet().getColumnCount()) {
            this.addColumn(this.reader.getColumnSet().getColumn(i));
            ++i;
        }
        Object[] row = new Object[this.getColumnCount()];
        while (this.reader.next()) {
            int i2 = 0;
            while (i2 < row.length) {
                row[i2] = this.reader.getObject(i2 + 1);
                ++i2;
            }
            this.addRow(row);
        }
        this.reader.close();
        new Thread(this).start();
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.modified) continue;
            RamTable ramTable = this;
            synchronized (ramTable) {
                this.modified = false;
                try {
                    File newFile = new File(String.valueOf(this.file) + ".new");
                    FileWriter writer = new FileWriter(newFile);
                    throw new RuntimeException("ResultSet rs = reader.getWriterResultSet(writer);");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public synchronized void set(int row, Object[] value, boolean[] dirty) {
        Object[] rowBuf = (Object[])this.rows.elementAt(row - 1);
        int i = 0;
        while (i < value.length) {
            if (dirty[i]) {
                rowBuf[i] = value[i];
                dirty[i] = false;
            }
            ++i;
        }
        this.modified = true;
    }

    public Object get(int row, int column) {
        return ((Object[])this.rows.elementAt(row - 1))[column - 1];
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public boolean rowDeleted(int row) {
        return this.rows.elementAt(row - 1) == null;
    }

    public synchronized void addRow(Object[] row) {
        Object[] copy = new Object[row.length];
        System.arraycopy(row, 0, copy, 0, row.length);
        this.rows.addElement(copy);
        this.modified = true;
    }

    public synchronized void deleteRow(int row) {
        this.rows.setElementAt(null, row - 1);
        this.modified = true;
    }
}

