/*
 * Decompiled with CFR 0.152.
 */
package org.kobjects.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.kobjects.jdbc.ColumnSet;

public class Column {
    private String name;
    private int type;
    private int number;
    private String label;
    private Object[] values;
    private ColumnSet columnSet;
    private int scale;
    private int precision;
    private int displaySize;

    public Column(String name, int type) {
        this.name = name;
        this.type = type;
    }

    public Column(ResultSetMetaData meta, int index) throws SQLException {
        this(meta.getColumnName(index), meta.getColumnType(index));
    }

    public Column(Column column) {
        this.name = column.name;
        this.type = column.type;
    }

    public String getName() {
        return this.name;
    }

    public void setValues(Object[] values) {
        if (this.number != 0) {
            throw new RuntimeException("Column is locked already");
        }
        this.values = values;
    }

    public ColumnSet getColumnSet() {
        return this.columnSet;
    }

    public Object[] getValues() {
        return this.values;
    }

    public int getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public int getNumber() {
        return this.number;
    }

    public void lock(ColumnSet columnSet) {
        this.columnSet = columnSet;
        this.number = columnSet.getColumnCount();
    }

    public int getDisplaySize() {
        return this.displaySize;
    }

    public void setDisplaySize(int displaySize) {
        this.displaySize = displaySize;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }
}

