/*
 * Decompiled with CFR 0.152.
 */
package org.kobjects.jdbc.util;

import java.sql.SQLException;
import org.kobjects.jdbc.util.AbstractResultSet;
import org.kobjects.jdbc.util.AbstractTable;

public class TableResultSet
extends AbstractResultSet {
    AbstractTable table;
    int row;
    Object[] writeBuf;
    boolean wasNull;
    boolean[] dirty;
    boolean insertRow;

    public TableResultSet(AbstractTable table) throws SQLException {
        this.table = table;
        int i = 1;
        while (i <= table.getColumnCount()) {
            this.getColumnSet().addColumn(table.getColumn(i));
            ++i;
        }
    }

    public boolean next() throws SQLException {
        return this.absolute(this.row + 1);
    }

    public void close() throws SQLException {
    }

    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    public Object getObject(int columnIndex) throws SQLException {
        Object result = this.writeBuf != null && this.dirty[columnIndex - 1] ? this.writeBuf[columnIndex - 1] : this.table.get(this.row, columnIndex);
        this.wasNull = result == null;
        return result;
    }

    public boolean isAfterLast() throws SQLException {
        return this.row > this.table.getRowCount();
    }

    public boolean isLast() throws SQLException {
        return this.row == this.table.getRowCount() && this.row != 0;
    }

    public int getRow() throws SQLException {
        return this.row;
    }

    public boolean absolute(int row) throws SQLException {
        this.writeBuf = null;
        if (row > this.table.getRowCount() + 1) {
            return false;
        }
        this.row = row;
        return row <= this.table.getRowCount();
    }

    public boolean rowUpdated() throws SQLException {
        throw new RuntimeException("NYI");
    }

    public boolean rowInserted() throws SQLException {
        throw new RuntimeException("NYI");
    }

    public boolean rowDeleted() throws SQLException {
        return this.table.rowDeleted(this.row);
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        if (this.writeBuf == null) {
            this.writeBuf = new Object[this.table.getColumnCount()];
            this.dirty = new boolean[this.table.getColumnCount()];
        }
        this.writeBuf[columnIndex - 1] = x;
        this.dirty[columnIndex - 1] = true;
    }

    public void insertRow() throws SQLException {
        if (!this.insertRow) {
            throw new SQLException("Not on insert row!");
        }
        this.table.addRow(this.writeBuf);
        this.writeBuf = new Object[this.table.getColumnCount()];
        this.dirty = new boolean[this.table.getColumnCount()];
    }

    public void updateRow() throws SQLException {
        if (this.writeBuf == null) {
            return;
        }
        if (this.insertRow || this.row <= 0 || this.row > this.table.getRowCount()) {
            throw new SQLException("Illegal row index for update:" + this.row);
        }
        this.table.set(this.row, this.writeBuf, this.dirty);
    }

    public void deleteRow() throws SQLException {
        this.table.deleteRow(this.row);
    }

    public void refreshRow() throws SQLException {
        this.writeBuf = null;
    }

    public void moveToInsertRow() throws SQLException {
        this.insertRow = true;
    }

    public void moveToCurrentRow() throws SQLException {
        this.insertRow = false;
    }
}

