/*
 * Decompiled with CFR 0.152.
 */
package org.kobjects.jdbc.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.kobjects.jdbc.ColumnSet;

public abstract class AbstractResultSet
implements ResultSet {
    private ColumnSet columns = new ColumnSet();

    public ColumnSet getColumnSet() {
        return this.columns;
    }

    public String getString(int columnIndex) throws SQLException {
        Object o = this.getObject(columnIndex);
        return o == null ? null : o.toString();
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        Boolean b = (Boolean)this.getObject(columnIndex);
        return b == null ? false : b;
    }

    public byte getByte(int columnIndex) throws SQLException {
        Number n = (Number)this.getObject(columnIndex);
        return n == null ? (byte)0 : n.byteValue();
    }

    public short getShort(int columnIndex) throws SQLException {
        Number n = (Number)this.getObject(columnIndex);
        return n == null ? (short)0 : n.shortValue();
    }

    public int getInt(int columnIndex) throws SQLException {
        Number n = (Number)this.getObject(columnIndex);
        return n == null ? 0 : n.intValue();
    }

    public long getLong(int columnIndex) throws SQLException {
        Number n = (Number)this.getObject(columnIndex);
        return n == null ? 0L : n.longValue();
    }

    public float getFloat(int columnIndex) throws SQLException {
        Number n = (Number)this.getObject(columnIndex);
        return n == null ? 0.0f : n.floatValue();
    }

    public double getDouble(int columnIndex) throws SQLException {
        Number n = (Number)this.getObject(columnIndex);
        return n == null ? 0.0 : n.doubleValue();
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return (BigDecimal)this.getObject(columnIndex);
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        return (byte[])this.getObject(columnIndex);
    }

    public Date getDate(int columnIndex) throws SQLException {
        return (Date)this.getObject(columnIndex);
    }

    public Time getTime(int columnIndex) throws SQLException {
        return (Time)this.getObject(columnIndex);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return (Timestamp)this.getObject(columnIndex);
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new RuntimeException("not supported");
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new RuntimeException("not supported");
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return new ByteArrayInputStream(this.getBytes(columnIndex));
    }

    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public String getCursorName() throws SQLException {
        return null;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.columns;
    }

    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    public int findColumn(String columnName) throws SQLException {
        return this.columns.findColumn(columnName);
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return new StringReader(this.getString(columnIndex));
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return (BigDecimal)this.getObject(columnIndex);
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.getRow() < 1;
    }

    public boolean isFirst() throws SQLException {
        return this.getRow() == 1 && this.isAfterLast();
    }

    public void beforeFirst() throws SQLException {
        this.absolute(0);
    }

    public boolean first() throws SQLException {
        return this.absolute(1);
    }

    public boolean relative(int rows) throws SQLException {
        return this.absolute(this.getRow() + rows);
    }

    public boolean previous() throws SQLException {
        return this.absolute(this.getRow() - 1);
    }

    public void setFetchDirection(int direction) throws SQLException {
    }

    public int getFetchDirection() throws SQLException {
        return 0;
    }

    public void setFetchSize(int rows) throws SQLException {
    }

    public int getFetchSize() throws SQLException {
        return 0;
    }

    public int getType() throws SQLException {
        return 0;
    }

    public int getConcurrency() throws SQLException {
        return 0;
    }

    public void updateNull(int columnIndex) throws SQLException {
        this.updateObject(columnIndex, null);
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.updateObject(columnIndex, (Object)new Boolean(x));
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.updateObject(columnIndex, (Object)new Byte(x));
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        this.updateObject(columnIndex, (Object)new Short(x));
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        this.updateObject(columnIndex, (Object)new Integer(x));
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        this.updateObject(columnIndex, (Object)new Long(x));
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.updateObject(columnIndex, (Object)new Float(x));
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.updateObject(columnIndex, (Object)new Double(x));
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.updateObject(columnIndex, (Object)x);
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        byte[] buf = new byte[length];
        int pos = 0;
        try {
            while (pos < length) {
                if (x.read(buf, pos, length - pos) > 0) continue;
                throw new SQLException("Unexpected EOF");
            }
        }
        catch (IOException e) {
            throw new SQLException(e.toString());
        }
        this.updateObject(columnIndex, (Object)buf);
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        char[] buf = new char[length];
        int pos = 0;
        try {
            while (pos < length) {
                if (x.read(buf, pos, length - pos) > 0) continue;
                throw new SQLException("Unexpected EOF");
            }
        }
        catch (IOException e) {
            throw new SQLException(e.toString());
        }
        this.updateObject(columnIndex, (Object)new String(buf));
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw new SQLException("Not Supported");
    }

    public void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(columnName, x);
    }

    public void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.findColumn(columnName), x);
    }

    public void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    public void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.findColumn(columnName), x);
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    public void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnName), x);
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnName), x);
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    public void cancelRowUpdates() throws SQLException {
        throw new SQLException("not supported!");
    }

    public Statement getStatement() throws SQLException {
        throw new SQLException("not supported!");
    }

    public Object getObject(int i, Map map) throws SQLException {
        throw new SQLException("not supported!");
    }

    public Ref getRef(int i) throws SQLException {
        throw new SQLException("not supported!");
    }

    public Blob getBlob(int i) throws SQLException {
        throw new SQLException("not supported!");
    }

    public Clob getClob(int i) throws SQLException {
        throw new SQLException("not supported!");
    }

    public Array getArray(int i) throws SQLException {
        throw new SQLException("not supported!");
    }

    public Object getObject(String colName, Map map) throws SQLException {
        return this.getObject(this.findColumn(colName), map);
    }

    public Ref getRef(String colName) throws SQLException {
        throw new SQLException("not supported!");
    }

    public Blob getBlob(String colName) throws SQLException {
        return this.getBlob(this.findColumn(colName));
    }

    public Clob getClob(String colName) throws SQLException {
        return this.getClob(this.findColumn(colName));
    }

    public Array getArray(String colName) throws SQLException {
        return this.getArray(this.findColumn(colName));
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLException("not supported!");
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnName), cal);
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLException("not supported!");
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnName), cal);
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLException("not supported!");
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), cal);
    }

    public URL getURL(int columnIndex) throws SQLException {
        throw new SQLException("not supported!");
    }

    public URL getURL(String columnName) throws SQLException {
        return this.getURL(this.findColumn(columnName));
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new SQLException("not supported!");
    }

    public void updateRef(String columnName, Ref x) throws SQLException {
        this.updateRef(this.findColumn(columnName), x);
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
    }

    public void updateBlob(String columnName, Blob x) throws SQLException {
        this.updateBlob(this.findColumn(columnName), x);
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new SQLException("not supported!");
    }

    public void updateClob(String columnName, Clob x) throws SQLException {
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new SQLException("not supported!");
    }

    public void updateArray(String columnName, Array x) throws SQLException {
        this.updateArray(this.findColumn(columnName), x);
    }

    public boolean last() throws SQLException {
        while (!this.isLast() && this.next()) {
        }
        return !this.isAfterLast();
    }

    public void afterLast() throws SQLException {
        while (this.next()) {
        }
    }

    public abstract boolean next() throws SQLException;

    public abstract void close() throws SQLException;

    public abstract boolean wasNull() throws SQLException;

    public abstract Object getObject(int var1) throws SQLException;

    public abstract boolean isAfterLast() throws SQLException;

    public abstract boolean isLast() throws SQLException;

    public abstract int getRow() throws SQLException;

    public abstract boolean absolute(int var1) throws SQLException;

    public abstract boolean rowUpdated() throws SQLException;

    public abstract boolean rowInserted() throws SQLException;

    public abstract boolean rowDeleted() throws SQLException;

    public abstract void updateObject(int var1, Object var2) throws SQLException;

    public abstract void insertRow() throws SQLException;

    public abstract void updateRow() throws SQLException;

    public abstract void deleteRow() throws SQLException;

    public abstract void refreshRow() throws SQLException;

    public abstract void moveToInsertRow() throws SQLException;

    public abstract void moveToCurrentRow() throws SQLException;
}

