/*
 * Decompiled with CFR 0.152.
 */
package org.kobjects.jdbc.stream;

import java.io.IOException;
import java.sql.SQLException;
import org.kobjects.jdbc.util.AbstractResultSet;

public abstract class ReaderResultSet
extends AbstractResultSet {
    Object[] currentRow;
    Object[] nextRow;
    int row;
    boolean wasNull;

    protected abstract Object[] readRow() throws SQLException, IOException;

    public boolean next() throws SQLException {
        try {
            Object[] objectArray = this.currentRow = this.row == 0 ? this.readRow() : this.nextRow;
            if (this.currentRow != null) {
                this.nextRow = this.readRow();
            }
        }
        catch (IOException e) {
            throw new SQLException(e.toString());
        }
        ++this.row;
        return this.currentRow != null;
    }

    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    public Object getObject(int columnIndex) throws SQLException {
        Object result = this.currentRow[columnIndex - 1];
        this.wasNull = result == null;
        return result;
    }

    public boolean isAfterLast() throws SQLException {
        return this.currentRow == null && this.row != 0;
    }

    public boolean isLast() throws SQLException {
        return this.nextRow == null && this.row != 0;
    }

    public int getRow() throws SQLException {
        return this.row;
    }

    public boolean absolute(int row) throws SQLException {
        throw new SQLException("Only sequential read allowed");
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new SQLException("This ResultSet is read-only!");
    }

    public void insertRow() throws SQLException {
        throw new SQLException("This ResultSet is read-only!");
    }

    public void updateRow() throws SQLException {
        throw new SQLException("This ResultSet is read-only!");
    }

    public void deleteRow() throws SQLException {
        throw new SQLException("This ResultSet is read-only!");
    }

    public void refreshRow() throws SQLException {
    }

    public void moveToInsertRow() throws SQLException {
        throw new SQLException("This ResultSet is read-only!");
    }

    public void moveToCurrentRow() throws SQLException {
    }
}

