/*
 * Decompiled with CFR 0.152.
 */
package org.kobjects.jdbc.sql;

import java.sql.SQLException;
import java.util.Vector;
import org.kobjects.jdbc.ColumnSet;
import org.kobjects.jdbc.sql.Condition;

public class SqlParser {
    private static final int IDENT = 32;
    private static final int BOOLEAN = 33;
    private static final int NUMBER = 34;
    private static final int STRING = 35;
    private static final int LPAR = 36;
    private static final int RPAR = 37;
    private static final int NULL = 38;
    private static final int STOP = 63;
    private ColumnSet columns;
    private char[] buffer;
    private int bufferPos;
    private int tokenPos;
    private int tokenType;
    private String tokenText;

    public SqlParser(ColumnSet table) {
        this.columns = table;
    }

    public Condition parse(String sql) throws SQLException {
        int sqlLen = sql.length();
        this.buffer = new char[sqlLen + 1];
        sql.getChars(0, sqlLen, this.buffer, 0);
        this.buffer[sqlLen] = '\u0000';
        this.bufferPos = 0;
        this.nextToken();
        return this.parseExpression();
    }

    private long getDateTime(String s) {
        return 0L;
    }

    private void nextToken() throws SQLException {
        while (this.buffer[this.bufferPos] == ' ') {
            ++this.bufferPos;
        }
        this.tokenPos = this.bufferPos;
        char c = this.buffer[this.bufferPos];
        if (c == '\u0000') {
            this.tokenType = 63;
        } else if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
            while ((c = this.buffer[++this.bufferPos]) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
            }
            this.tokenText = new String(this.buffer, this.tokenPos, this.bufferPos - this.tokenPos);
            this.tokenType = "AND".equals(this.tokenText) ? 16 : ("OR".equals(this.tokenText) ? 17 : ("NOT".equals(this.tokenText) ? 19 : ("TRUE".equals(this.tokenText) ? 33 : ("FALSE".equals(this.tokenText) ? 33 : ("NULL".equals(this.tokenText) ? 38 : 32)))));
        } else if (c >= '0' && c <= '9' || c == '+' || c == '-') {
            while ((c = this.buffer[++this.bufferPos]) >= '0' && c <= '9') {
            }
            this.tokenText = new String(this.buffer, this.tokenPos, this.bufferPos - this.tokenPos);
            this.tokenType = 34;
        } else if (c == '\'') {
            while ((c = this.buffer[++this.bufferPos]) != '\'' && c != '\u0000') {
            }
            ++this.bufferPos;
            if (c == '\u0000') {
                throw new SQLException("Non-terminated string literal");
            }
            this.tokenText = new String(this.buffer, this.tokenPos + 1, this.bufferPos - this.tokenPos - 2);
            this.tokenType = 35;
        } else if (c == '(') {
            ++this.bufferPos;
            this.tokenType = 36;
        } else if (c == ')') {
            ++this.bufferPos;
            this.tokenType = 37;
        } else if (c == '=') {
            ++this.bufferPos;
            this.tokenType = 5;
        } else if (c == '~') {
            ++this.bufferPos;
            this.tokenType = 7;
        } else if (c == '<') {
            if (this.buffer[++this.bufferPos] == '=') {
                ++this.bufferPos;
                this.tokenType = 3;
            }
            this.tokenType = 1;
        } else if (c == '>') {
            if (this.buffer[++this.bufferPos] == '=') {
                ++this.bufferPos;
                this.tokenType = 4;
            }
            this.tokenType = 2;
        }
        System.out.println("nextToken(): " + this.tokenText);
    }

    private Condition parseExpression() throws SQLException {
        Vector<Condition> vector = new Vector<Condition>();
        vector.addElement(this.parseTerm());
        while (this.tokenType == 17) {
            this.nextToken();
            vector.addElement(this.parseExpression());
        }
        if (this.tokenType != 63) {
            throw new SQLException("End of input expected (" + this.tokenPos + ")");
        }
        if (vector.size() != 0) {
            Condition[] array = new Condition[vector.size()];
            int i = 0;
            while (i < vector.size()) {
                array[i] = (Condition)vector.elementAt(i);
                ++i;
            }
            return new Condition(17, array);
        }
        return (Condition)vector.elementAt(0);
    }

    private Condition parseTerm() throws SQLException {
        Vector<Condition> vector = new Vector<Condition>();
        vector.addElement(this.parseFactor());
        while (this.tokenType == 16) {
            this.nextToken();
            vector.addElement(this.parseExpression());
        }
        if (vector.size() != 0) {
            Condition[] array = new Condition[vector.size()];
            int i = 0;
            while (i < vector.size()) {
                array[i] = (Condition)vector.elementAt(i);
                ++i;
            }
            return new Condition(16, array);
        }
        return (Condition)vector.elementAt(0);
    }

    private Condition parseFactor() throws SQLException {
        if (this.tokenType == 32) {
            int field = this.columns.findColumn(this.tokenText);
            if (field == -1) {
                throw new SQLException("Unknown field \"" + this.tokenText + "\"");
            }
            this.nextToken();
            if (this.tokenType < 1 || this.tokenType > 7) {
                throw new SQLException("Relational operator expected (" + this.tokenPos + ")");
            }
            int relop = this.tokenType;
            this.nextToken();
            if (this.tokenType < 33 || this.tokenType > 35) {
                throw new SQLException("Value expected (" + this.tokenPos + ")");
            }
            Object value = null;
            switch (this.columns.getColumn(field).getType()) {
                case -7: {
                    if (this.tokenType != 33) {
                        throw new SQLException("Boolean value expected (" + this.tokenPos + ")");
                    }
                    value = new Boolean("TRUE".equals(this.tokenText));
                    break;
                }
                case 4: {
                    if (this.tokenType != 34) {
                        throw new SQLException("Numeric value expected (" + this.tokenPos + ")");
                    }
                    value = new Long(this.tokenText);
                    break;
                }
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    if (this.tokenType != 34) {
                        throw new SQLException("Numeric value expected (" + this.tokenPos + ")");
                    }
                    value = new Long(Long.parseLong(this.tokenText));
                    break;
                }
                case 91: 
                case 93: {
                    long l = this.getDateTime(this.tokenText);
                    if (l != -1L && this.tokenType == 34) break;
                    throw new SQLException("Date/time value expected (" + this.tokenPos + ")");
                }
                case 1: 
                case 12: {
                    value = this.tokenText;
                    break;
                }
                default: {
                    throw new SQLException("Unsupported field type (" + this.tokenPos + ")");
                }
            }
            this.nextToken();
            return new Condition(relop, this.columns.getColumn(field), value);
        }
        if (this.tokenType == 36) {
            this.nextToken();
            Condition temp = this.parseExpression();
            if (this.tokenType != 37) {
                throw new SQLException("Unclosed parenthesis (" + this.tokenPos + ")");
            }
            this.nextToken();
            return temp;
        }
        if (this.tokenType == 19) {
            this.nextToken();
            return new Condition(19, new Condition[]{this.parseExpression()});
        }
        throw new SQLException("Identifier, parenthesis or NOT expected (" + this.tokenPos + ")");
    }
}

