/*
 * Decompiled with CFR 0.152.
 */
package org.kobjects.jdbc.sql;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.kobjects.jdbc.Column;

public class Condition {
    public static final int LT = 1;
    public static final int GT = 2;
    public static final int LE = 3;
    public static final int GE = 4;
    public static final int EQ = 5;
    public static final int NE = 6;
    public static final int EQ_TEXT = 7;
    public static final int AND = 16;
    public static final int OR = 17;
    public static final int XOR = 18;
    public static final int NOT = 19;
    private int operator;
    private Column column;
    private int type;
    private Object value;
    private Condition[] children;

    public Condition(int operator, Column column, Object value) throws SQLException {
        if (operator < 1 || operator > 7) {
            throw new SQLException("Illegal type code \"" + this.type + "\" for leaf node.");
        }
        if (operator == 7) {
            value = value.toString().toUpperCase();
        }
        this.operator = operator;
        this.column = column;
        this.value = value;
    }

    public Condition(int operator, Condition[] children) throws SQLException {
        if (operator < 16 || operator > 19) {
            throw new SQLException("Illegal type code \"" + this.type + "\" for inner node.");
        }
        this.operator = operator;
        this.children = children;
    }

    static int compare(Object o1, Object o2) {
        return o1 == null ? (o2 == null ? 0 : -1) : ((Comparable)o1).compareTo(o2);
    }

    public boolean evaluate(ResultSet values) throws SQLException {
        if (this.operator < 16) {
            Object obj = values.getObject(this.column.getNumber());
            switch (this.operator) {
                case 1: {
                    return Condition.compare(obj, this.value) < 0;
                }
                case 2: {
                    return Condition.compare(obj, this.value) > 0;
                }
                case 3: {
                    return Condition.compare(obj, this.value) <= 0;
                }
                case 4: {
                    return Condition.compare(obj, this.value) >= 0;
                }
                case 5: {
                    return Condition.compare(obj, this.value) == 0;
                }
                case 6: {
                    return Condition.compare(obj, this.value) != 0;
                }
                case 7: {
                    return obj.toString().toUpperCase().equals(this.value.toString());
                }
            }
        } else {
            switch (this.operator) {
                case 16: {
                    int i = 0;
                    while (i < this.children.length) {
                        if (!this.children[i].evaluate(values)) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
                case 17: {
                    int i = 0;
                    while (i < this.children.length) {
                        if (this.children[i].evaluate(values)) {
                            return true;
                        }
                        ++i;
                    }
                    return false;
                }
                case 18: {
                    return this.children[0].evaluate(values) ^ this.children[1].evaluate(values);
                }
                case 19: {
                    return !this.children[0].evaluate(values);
                }
            }
        }
        return false;
    }

    public String toString() {
        if (this.operator < 16) {
            String f = this.column.getName();
            String v = this.value instanceof String ? "'" + this.value + "'" : "" + this.value;
            switch (this.operator) {
                case 1: {
                    return String.valueOf(f) + " < " + v;
                }
                case 2: {
                    return String.valueOf(f) + " > " + v;
                }
                case 3: {
                    return String.valueOf(f) + " <= " + v;
                }
                case 4: {
                    return String.valueOf(f) + " >= " + v;
                }
                case 5: {
                    return String.valueOf(f) + " = " + v;
                }
                case 6: {
                    return String.valueOf(f) + " != " + v;
                }
                case 7: {
                    throw new RuntimeException("NYI");
                }
            }
            throw new RuntimeException("illegal operator: " + this.operator);
        }
        if (this.operator == 19) {
            return "NOT(" + this.children[0] + ")";
        }
        StringBuffer buf = new StringBuffer("(");
        buf.append(this.children[0].toString());
        int i = 1;
        while (i < this.children.length) {
            switch (this.operator) {
                case 16: {
                    buf.append(" AND ");
                    break;
                }
                case 17: {
                    buf.append(" OR ");
                    break;
                }
                case 18: {
                    buf.append(" XOR ");
                    break;
                }
                default: {
                    throw new RuntimeException("illegal operator: " + this.operator);
                }
            }
            buf.append(this.children[i].toString());
            ++i;
        }
        buf.append(")");
        return buf.toString();
    }
}

