/*
 * Decompiled with CFR 0.152.
 */
package org.kobjects.jdbc.format.ls8bib;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;
import org.kobjects.jdbc.Column;
import org.kobjects.jdbc.ColumnSet;
import org.kobjects.jdbc.format.bibtex.BibtexReader;
import org.kobjects.jdbc.util.AbstractTable;

public class Ls8bibTable
extends AbstractTable {
    BibtexReader bibReader;
    Vector rows = new Vector();
    boolean modified;

    public Ls8bibTable(String name, Properties properties) throws FileNotFoundException, IOException, SQLException {
        this.bibReader = new BibtexReader(new FileReader(name));
        ColumnSet columns = this.bibReader.getColumnSet();
        columns.addColumn(new Column("ls8authoren", 12));
        columns.addColumn(new Column("projekt", 12));
        while (this.bibReader.next()) {
            Object[] row = new Object[columns.getColumnCount()];
            int i = 0;
            while (i < row.length) {
                row[i] = this.bibReader.getObject(i + 1);
                ++i;
            }
            this.rows.addElement(row);
        }
        int i = 1;
        while (i <= columns.getColumnCount()) {
            this.addColumn(columns.getColumn(i));
            ++i;
        }
        this.bibReader.close();
    }

    public synchronized void set(int row, Object[] value, boolean[] dirty) {
        Object[] rowBuf = (Object[])this.rows.elementAt(row - 1);
        int i = 0;
        while (i < value.length) {
            if (dirty[i]) {
                rowBuf[i] = value[i];
                dirty[i] = false;
            }
            ++i;
        }
        this.modified = true;
    }

    public Object get(int row, int column) {
        return ((Object[])this.rows.elementAt(row - 1))[column - 1];
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public void addRow(Object[] row) {
        Object[] copy = new Object[row.length];
        System.arraycopy(row, 0, copy, 0, row.length);
        this.rows.addElement(copy);
        this.modified = true;
    }

    public boolean rowDeleted(int row) {
        return this.rows.elementAt(row - 1) == null;
    }

    public void deleteRow(int row) {
        this.rows.setElementAt(null, row - 1);
        this.modified = true;
    }
}

