/*
 * Decompiled with CFR 0.152.
 */
package org.kobjects.jdbc.format.dbase;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.Date;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Properties;
import org.kobjects.jdbc.Column;
import org.kobjects.jdbc.util.AbstractTable;

public class DbaseTable
extends AbstractTable {
    RandomAccessFile raf;
    int headerSize;
    int[] offsets = new int[1024];
    int fieldCount;
    int recordCount;
    byte[] rowBuf;
    int row;
    static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");

    String getString(byte[] buf, int pos, int end) {
        StringBuffer result = new StringBuffer();
        while (pos < end) {
            char c;
            if ((c = (char)buf[pos++]) == '\u0000') break;
            result.append(c);
        }
        return result.toString();
    }

    int getInt16(byte[] buf, int pos) {
        return (buf[pos] & 0xFF) + 256 * (buf[pos + 1] & 0xFF);
    }

    int getInt32(byte[] buf, int pos) {
        return this.getInt16(buf, pos) + 65536 * this.getInt16(buf, pos + 2);
    }

    public DbaseTable(String file, Properties props) throws SQLException {
        try {
            this.raf = new RandomAccessFile(file, "r");
            this.raf.seek(0L);
            byte[] staticHeader = new byte[32];
            this.raf.readFully(staticHeader);
            this.recordCount = this.getInt32(staticHeader, 4);
            this.headerSize = this.getInt16(staticHeader, 8);
            byte[] fieldDef = new byte[32];
            this.offsets[0] = 1;
            while (true) {
                Column column;
                fieldDef[0] = (byte)this.raf.read();
                if (fieldDef[0] == 13) break;
                this.raf.readFully(fieldDef, 1, 31);
                String name = this.getString(fieldDef, 0, 11);
                int len = fieldDef[16] & 0xFF;
                int dec = fieldDef[17] & 0xFF;
                switch ((char)fieldDef[11]) {
                    case 'C': {
                        column = new Column(name, 1);
                        column.setDisplaySize(len);
                        break;
                    }
                    case 'N': {
                        if (dec == 0) {
                            column = new Column(name, -5);
                            column.setPrecision(len - 1);
                        } else {
                            column = new Column(name, 8);
                            column.setPrecision(len - 2);
                            column.setScale(dec);
                        }
                        column.setDisplaySize(len);
                        break;
                    }
                    case 'L': {
                        column = new Column(name, -7);
                        column.setDisplaySize(1);
                        break;
                    }
                    case 'D': {
                        column = new Column(name, 91);
                        break;
                    }
                    case 'M': {
                        column = new Column(name, -1);
                        break;
                    }
                    default: {
                        throw new RuntimeException(String.valueOf(name) + ": unknown type:" + fieldDef[10]);
                    }
                }
                this.addColumn(column);
                ++this.fieldCount;
                this.offsets[this.fieldCount] = this.offsets[this.fieldCount - 1] + (fieldDef[16] & 0xFF);
            }
            this.rowBuf = new byte[this.offsets[this.fieldCount]];
        }
        catch (IOException e) {
            throw new SQLException(e.toString());
        }
    }

    void loadRow(int row) throws SQLException {
        if (row == this.row) {
            return;
        }
        this.row = row;
        try {
            this.raf.seek(this.headerSize + (row - 1) * this.offsets[this.fieldCount]);
            this.raf.readFully(this.rowBuf);
        }
        catch (IOException e) {
            throw new SQLException(e.toString());
        }
    }

    public void set(int row, Object[] value, boolean[] dirty) {
        throw new RuntimeException("Currently DBase table is read-only");
    }

    public Object get(int row, int column) throws SQLException {
        this.loadRow(row);
        String value = this.getString(this.rowBuf, this.offsets[column - 1], this.offsets[column]).trim();
        switch (this.getColumnType(column)) {
            case 1: {
                return value;
            }
            case -1: {
                return null;
            }
            case 8: {
                return value.length() == 0 ? null : new Double(value);
            }
            case -5: {
                return value.length() == 0 ? null : new Long(value);
            }
            case -7: {
                return value.length() == 0 || value.equals("?") ? null : new Boolean("TtYy".indexOf(value) != -1);
            }
            case 91: {
                try {
                    return value.length() == 0 ? null : new Date(dateFormat.parse(value).getTime());
                }
                catch (ParseException e) {
                    throw new SQLException(e.toString());
                }
            }
        }
        throw new RuntimeException("unsupported field type");
    }

    public int getRowCount() {
        return this.recordCount;
    }

    public void addRow(Object[] row) {
        throw new RuntimeException("Currently DBase table is read-only");
    }

    public boolean rowDeleted(int row) {
        return false;
    }

    public void deleteRow(int row) {
        throw new RuntimeException("Currently DBase table is read-only");
    }
}

