/*
 * Decompiled with CFR 0.152.
 */
package org.kobjects.jdbc.format.csv;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.kobjects.io.LookAheadReader;
import org.kobjects.jdbc.Column;
import org.kobjects.jdbc.stream.ReaderResultSet;
import org.kobjects.jdbc.stream.WriterResultSet;

public class CsvReader
extends ReaderResultSet {
    static final Object EOL = new Object();
    static final Object EOF = new Object();
    protected LookAheadReader reader;
    protected char commentsChar;
    protected String nullValue;
    Vector row0;

    public CsvReader(String file, Properties properties) throws IOException, SQLException {
        this(new FileReader(file), "true".equals(((Hashtable)properties).get("titles")));
    }

    public CsvReader(Reader reader, boolean titleLine) throws IOException, SQLException {
        Object o;
        this.reader = new LookAheadReader(reader);
        if (!titleLine) {
            this.row0 = new Vector();
        }
        while ((o = this.readColumn(null)) != EOL && o != EOF) {
            if (!titleLine) {
                this.row0.addElement(o);
            }
            this.getColumnSet().addColumn(new Column(titleLine ? o.toString() : "col" + this.getColumnSet().getColumnCount() + 1, 12));
        }
    }

    protected CsvReader(LookAheadReader reader) {
        this.reader = reader;
    }

    protected Object[] readRow() throws SQLException, IOException {
        Object eol;
        Object[] result = new Object[this.getMetaData().getColumnCount()];
        if (this.row0 != null) {
            int i = 0;
            while (i < result.length) {
                result[i] = this.row0.elementAt(i);
                ++i;
            }
            this.row0 = null;
            return result;
        }
        int i = 0;
        while (i < this.getColumnSet().getColumnCount()) {
            Object val = this.readColumn(this.getColumnSet().getColumn(i + 1));
            if (val == EOL) break;
            if (i == 0 && val == EOF) {
                return null;
            }
            result[i] = val;
            ++i;
        }
        while ((eol = this.readColumn(null)) != EOL && eol != EOF) {
        }
        return result;
    }

    protected Object adjustType(String value, boolean wasQuoted, Column column) {
        if (column == null) {
            return value;
        }
        switch (column.getType()) {
            case 1: 
            case 12: {
                return value;
            }
            case -7: {
                return new Boolean(value);
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                return new Double(value);
            }
            case 6: {
                return new Float(value);
            }
            case 4: {
                return new Integer(value);
            }
        }
        throw new RuntimeException("unsupported field type:" + column.getType());
    }

    void skip() throws IOException {
        while (this.reader.peek(0) == 32 || this.reader.peek(0) == 9) {
            this.reader.read();
        }
    }

    Object readColumn(Column column) throws IOException {
        Object result;
        while (this.reader.peek(0) == this.commentsChar) {
            this.reader.readLine();
        }
        this.skip();
        int c = this.reader.peek(0);
        switch (c) {
            case 34: {
                Object result2 = this.adjustType(this.readQuoted(), true, column);
                this.skip();
                if (this.reader.peek(0) == 44) {
                    this.reader.read();
                }
                return result2;
            }
            case 13: {
                if (this.reader.peek(0) == 10) {
                    this.reader.read();
                }
            }
            case 10: {
                this.reader.read();
                return EOL;
            }
            case -1: {
                return EOF;
            }
            case 44: {
                this.reader.read();
                return null;
            }
        }
        String str = this.reader.readTo(",\n\r").trim();
        Object object = result = str.length() == 0 || str.equals(this.nullValue) ? null : this.adjustType(str, false, column);
        if (this.reader.peek(0) == 44) {
            this.reader.read();
        }
        return result;
    }

    String readQuoted() throws IOException {
        this.reader.read();
        String result = this.reader.readTo('\"');
        this.reader.read();
        if (this.reader.peek(0) != 34) {
            return result;
        }
        StringBuffer buf = new StringBuffer(result);
        do {
            buf.append(this.reader.read());
            buf.append(this.reader.readTo('\"'));
            this.reader.read();
        } while (this.reader.peek(0) == 34);
        return buf.toString();
    }

    public void close() throws SQLException {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new SQLException(e.toString());
        }
    }

    public WriterResultSet getWriterResultSet(Writer writer) throws SQLException {
        throw new RuntimeException("NYI");
    }
}

