/*
 * Decompiled with CFR 0.152.
 */
package org.kobjects.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.kobjects.jdbc.Column;

public class ColumnSet
implements ResultSetMetaData {
    private Hashtable names;
    private Vector columns = new Vector();
    private String name;
    private boolean locked;

    public ColumnSet() {
    }

    public ColumnSet(ResultSetMetaData meta) throws SQLException {
        int i = 1;
        while (i < meta.getColumnCount()) {
            this.addColumn(new Column(meta, i));
            ++i;
        }
    }

    public int addColumn(Column column) {
        if (this.locked) {
            throw new RuntimeException("ColumnSet is locked already!");
        }
        this.names = null;
        this.columns.addElement(column);
        column.lock(this);
        return this.columns.size();
    }

    public Column getColumn(int index) {
        return (Column)this.columns.elementAt(index - 1);
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        throw new SQLException("not supported!");
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        throw new SQLException("not supported!");
    }

    public boolean isSearchable(int column) throws SQLException {
        throw new SQLException("not supported!");
    }

    public boolean isCurrency(int column) throws SQLException {
        throw new SQLException("not supported!");
    }

    public int isNullable(int column) throws SQLException {
        throw new SQLException("not supported!");
    }

    public boolean isSigned(int column) throws SQLException {
        throw new SQLException("not supported!");
    }

    public void lock() {
        this.locked = true;
    }

    public int getColumnDisplaySize(int column) {
        return this.getColumn(column).getDisplaySize();
    }

    public String getColumnLabel(int column) throws SQLException {
        return this.getColumn(column).getLabel();
    }

    public String getColumnName(int column) throws SQLException {
        return this.getColumn(column).getName();
    }

    public String getSchemaName(int column) throws SQLException {
        throw new SQLException("not supported!");
    }

    public int getPrecision(int column) throws SQLException {
        return this.getColumn(column).getPrecision();
    }

    public int getScale(int column) throws SQLException {
        return this.getColumn(column).getScale();
    }

    public String getTableName(int column) throws SQLException {
        return this.name;
    }

    public String getCatalogName(int column) throws SQLException {
        throw new SQLException("not supported!");
    }

    public int getColumnType(int column) throws SQLException {
        return this.getColumn(column).getType();
    }

    public String getColumnTypeName(int column) throws SQLException {
        throw new SQLException("not supported!");
    }

    public boolean isReadOnly(int column) throws SQLException {
        throw new SQLException("not supported!");
    }

    public boolean isWritable(int column) throws SQLException {
        throw new SQLException("not supported!");
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        throw new SQLException("not supported!");
    }

    public String getColumnClassName(int column) throws SQLException {
        throw new SQLException("not supported!");
    }

    public int findColumn(String columnName) throws SQLException {
        Integer col;
        if (this.names == null) {
            this.names = new Hashtable();
            int i = 1;
            while (i <= this.getColumnCount()) {
                this.names.put(this.getColumn(i).getName(), new Integer(i));
                ++i;
            }
        }
        if ((col = (Integer)this.names.get(columnName)) == null) {
            throw new SQLException("Column '" + columnName + "' does not exist!");
        }
        return col;
    }
}

