/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.ps;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.freehep.graphics2d.PrintColor;
import org.freehep.graphics2d.TagString;
import org.freehep.graphics2d.font.CharTable;
import org.freehep.graphicsio.AbstractVectorGraphicsIO;
import org.freehep.graphicsio.ImageGraphics2D;
import org.freehep.graphicsio.MultiPageDocument;
import org.freehep.graphicsio.PageConstants;
import org.freehep.graphicsio.font.FontUtilities;
import org.freehep.graphicsio.ps.EPSIEncoder;
import org.freehep.graphicsio.ps.MappedColor;
import org.freehep.graphicsio.ps.PSFontTable;
import org.freehep.graphicsio.ps.PSPathConstructor;
import org.freehep.graphicsio.ps.PSStringStyler;
import org.freehep.graphicsio.raw.RawImageWriteParam;
import org.freehep.util.ScientificFormat;
import org.freehep.util.UserProperties;
import org.freehep.util.images.ImageUtilities;
import org.freehep.util.io.ASCII85OutputStream;
import org.freehep.util.io.FlateOutputStream;

public class PSGraphics2D
extends AbstractVectorGraphicsIO
implements MultiPageDocument,
FontUtilities.ShowString {
    private static final String rootKey = PSGraphics2D.class.getName();
    public static final String BACKGROUND = rootKey + "." + "Background";
    public static final String BACKGROUND_COLOR = rootKey + "." + "BackgroundColor";
    public static final String PAGE_SIZE = rootKey + "." + "PageSize";
    public static final String PAGE_MARGINS = rootKey + "." + "PageMargins";
    public static final String ORIENTATION = rootKey + "." + "Orientation";
    public static final String FIT_TO_PAGE = rootKey + "." + "FitToPage";
    public static final String EMBED_FONTS = rootKey + "." + "EmbedFonts";
    public static final String EMBED_FONTS_AS = rootKey + "." + "EmbedFontsAs";
    public static final String FOR = rootKey + "." + "For";
    public static final String TITLE = rootKey + "." + "Title";
    public static final String PREVIEW = rootKey + ".Preview";
    public static final String PREVIEW_BITS = rootKey + ".PreviewBits";
    public static final String WRITE_IMAGES_AS = rootKey + "." + "WriteImagesAs";
    private static final UserProperties defaultProperties = new UserProperties();
    public static final String version = "$Revision: 9330 $";
    public static final int LEVEL_2 = 2;
    public static final int LEVEL_3 = 3;
    private PSFontTable fontTable;
    protected OutputStream ros;
    protected PrintStream os;
    private boolean multiPage;
    private int currentPage;
    private int postscriptLevel = 3;
    private static String[][] psAlignments;
    private ScientificFormat scientific = new ScientificFormat(6, 9, false);

    public static Properties getDefaultProperties() {
        return defaultProperties;
    }

    public PSGraphics2D(File file, Dimension size) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), size);
    }

    public PSGraphics2D(File file, Component component) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), component);
    }

    public PSGraphics2D(OutputStream os, Dimension size) {
        super(size, false);
        this.init(os);
    }

    public PSGraphics2D(OutputStream os, Component component) {
        super(component, false);
        this.init(os);
    }

    private void init(OutputStream os) {
        this.ros = new BufferedOutputStream(os);
        this.initProperties((Properties)defaultProperties);
        this.fontTable = new PSFontTable(this.ros, this.getFontRenderContext());
        this.multiPage = false;
        this.currentPage = 0;
    }

    protected PSGraphics2D(PSGraphics2D graphics, boolean doRestoreOnDispose) {
        super((AbstractVectorGraphicsIO)graphics, doRestoreOnDispose);
        this.ros = graphics.ros;
        this.os = graphics.os;
        this.fontTable = graphics.fontTable;
        this.multiPage = graphics.multiPage;
        this.currentPage = graphics.currentPage;
    }

    public void setMultiPage(boolean multiPage) {
        this.multiPage = multiPage;
    }

    public boolean isMultiPage() {
        return this.multiPage;
    }

    public static void setClipEnabled(boolean enabled) {
        defaultProperties.setProperty(CLIP, enabled);
    }

    private Rectangle getBoundingBox() {
        Dimension pageSize = PageConstants.getSize((String)this.getProperty(PAGE_SIZE));
        Insets margins = this.getPropertyInsets(PAGE_MARGINS);
        boolean isPortrait = this.getProperty(ORIENTATION).equals("Portrait");
        double awidth = pageSize.width - margins.left - margins.right;
        double aheight = pageSize.height - margins.top - margins.bottom;
        Dimension size = this.getSize();
        double iwidth = isPortrait ? size.width : size.height;
        double iheight = isPortrait ? size.height : size.width;
        double sf = Math.min(awidth / iwidth, aheight / iheight);
        if (!this.isProperty(FIT_TO_PAGE)) {
            sf = Math.min(sf, 1.0);
        }
        double x0 = awidth / 2.0 + (double)margins.left - sf * iwidth / 2.0;
        double y0 = aheight / 2.0 + (double)margins.bottom - sf * iheight / 2.0;
        double x1 = x0 + sf * iwidth;
        double y1 = y0 + sf * iheight;
        int llx = (int)x0;
        int lly = (int)y0;
        int urx = (int)Math.ceil(x1);
        int ury = (int)Math.ceil(y1);
        return new Rectangle(llx, lly, urx - llx, ury - lly);
    }

    public void writeHeader() throws IOException {
        this.os = new PrintStream(this.ros, true);
        if (!this.isMultiPage()) {
            Dimension size = this.getSize();
            this.resetClip(new Rectangle(0, 0, size.width, size.height));
        }
        this.os.println("%!PS-Adobe-3.0" + (this.isMultiPage() ? "" : " EPSF-3.0"));
        if (!this.isMultiPage()) {
            Rectangle bbox = this.getBoundingBox();
            this.os.println("%%BoundingBox: " + bbox.x + " " + bbox.y + " " + (bbox.x + bbox.width) + " " + (bbox.y + bbox.height));
        }
        String producer = ((Object)((Object)this)).getClass().getName();
        if (!this.isDeviceIndependent()) {
            producer = producer + " " + version.substring(1, version.length() - 1);
        }
        this.os.println("%%Creator: " + this.getCreator());
        this.os.println("%%Producer: " + producer);
        this.os.println("%%For: " + this.getProperty(FOR));
        this.os.println("%%Title: " + this.getProperty(TITLE));
        if (!this.isDeviceIndependent()) {
            this.os.println("%%CreationDate: " + DateFormat.getDateTimeInstance(0, 0).format(new Date()));
        }
        this.os.println("%%LanguageLevel: " + this.postscriptLevel);
        this.os.println("%%EndComments");
        if (this.isProperty(PREVIEW) && this.getComponent() != null) {
            Rectangle size = this.getComponent().getBounds();
            BufferedImage image = new BufferedImage(size.width, size.height, 2);
            Graphics imageGraphics = image.getGraphics();
            this.getComponent().print(imageGraphics);
            EPSIEncoder encoder = new EPSIEncoder(image, this.ros, this.getPropertyInt(PREVIEW_BITS), this.getProperty(ORIENTATION).equals("Portrait"));
            encoder.encode();
        }
        this.writeProlog();
    }

    private void writeProlog() {
        this.os.println("%%BeginProlog");
        PSGraphics2D.copyResourceTo((Object)((Object)this), (String)"PSProlog.txt", (PrintStream)this.os);
        this.os.println("%%EndProlog");
        this.os.println();
        if (!this.isMultiPage()) {
            this.openPage(this.getSize(), null, this.getComponent());
        }
    }

    public void writeBackground() throws IOException {
        if (this.isProperty(BACKGROUND)) {
            this.setBackground(this.getPropertyColor(BACKGROUND_COLOR));
            this.clearRect(0.0, 0.0, this.getSize().width, this.getSize().height);
        } else {
            this.setBackground(this.getComponent() != null ? this.getComponent().getBackground() : Color.WHITE);
            this.clearRect(0.0, 0.0, this.getSize().width, this.getSize().height);
        }
    }

    public void writeTrailer() throws IOException {
        if (!this.isMultiPage()) {
            this.closePage();
        }
        this.os.println();
        this.os.println("%%Trailer");
        if (this.isMultiPage()) {
            this.os.println("%%Pages: " + this.currentPage);
        }
        this.os.println("%%EOF");
    }

    public void closeStream() throws IOException {
        this.ros.close();
        this.os.close();
    }

    public void openPage(Component component) throws IOException {
        this.openPage(component.getSize(), component.getName(), component);
    }

    public void openPage(Dimension size, String title) throws IOException {
        this.openPage(size, title, null);
    }

    private void openPage(Dimension size, String title, Component component) {
        if (size == null) {
            size = component.getSize();
        }
        ++this.currentPage;
        this.resetClip(new Rectangle(0, 0, size.width, size.height));
        Dimension pageSize = PageConstants.getSize((String)this.getProperty(PAGE_SIZE));
        Insets margins = this.getPropertyInsets(PAGE_MARGINS);
        String string = title = title == null ? "" + this.currentPage : "(" + title + ")";
        if (this.isMultiPage()) {
            this.os.println("%%Page: " + title + " " + this.currentPage);
        }
        this.os.println(this.isMultiPage() ? "%%BeginPageSetup" : "%%BeginSetup");
        this.os.println("save");
        this.os.println("procDict begin");
        this.os.println("printColorMap begin");
        this.os.println(pageSize.width + " " + pageSize.height + " setpagesize");
        this.os.println(margins.left + " " + margins.bottom + " " + margins.top + " " + margins.right + " setmargins");
        this.os.println("0 0 setorigin");
        this.os.println(size.width + " " + size.height + " setsize");
        this.os.println(this.isProperty(FIT_TO_PAGE) ? "fittopage" : "naturalsize");
        this.os.println(this.getProperty(ORIENTATION).equals("Portrait") ? "portrait" : "landscape");
        this.os.println("imagescale");
        this.os.println("cliptobounds");
        this.os.println("setbasematrix");
        this.os.println("/Helvetica 10 sf");
        this.os.println("defaultGraphicsState");
        this.os.println(this.isMultiPage() ? "%%EndPageSetup" : "%%EndSetup");
        this.os.println();
        try {
            this.writeGraphicsState();
            this.writeBackground();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void closePage() {
        this.os.println("end end restore showpage");
        if (this.isMultiPage()) {
            this.os.println("%%PageTrailer");
        }
    }

    public void setHeader(Font font, TagString left, TagString center, TagString right, int underlineThickness) {
    }

    public void setFooter(Font font, TagString left, TagString center, TagString right, int underlineThickness) {
    }

    public Graphics create() {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException e) {
            this.handleException(e);
        }
        return new PSGraphics2D(this, true);
    }

    public Graphics create(double x, double y, double width, double height) {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException e) {
            this.handleException(e);
        }
        PSGraphics2D graphics = new PSGraphics2D(this, true);
        graphics.translate(x, y);
        graphics.clipRect(0.0, 0.0, width, height);
        return graphics;
    }

    protected void writeGraphicsSave() throws IOException {
        this.os.println("q");
    }

    protected void writeGraphicsRestore() throws IOException {
        this.os.println("Q");
    }

    public void draw(Shape shape) {
        try {
            if (this.getStroke() instanceof BasicStroke) {
                this.writePath(shape);
                this.os.println("S");
            } else {
                boolean eofill = this.writePath(this.getStroke().createStrokedShape(shape));
                this.os.println(eofill ? "f*" : "f");
            }
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void fill(Shape shape) {
        try {
            boolean eofill = this.writePath(shape);
            this.os.println(eofill ? "f*" : "f");
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void fillAndDraw(Shape shape, Color fillColor) {
        try {
            this.setPSColor(fillColor, true);
            boolean eofill = this.writePath(shape);
            this.os.println(eofill ? "B*" : "B");
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.writeWarning(((Object)((Object)this)).getClass() + ": copyArea(int, int, int, int, int, int) not implemented.");
    }

    protected void writeImage(RenderedImage image, AffineTransform xform, Color bkg) throws IOException {
        byte[] imageBytes;
        String encode;
        if (bkg == null) {
            bkg = this.getBackground();
        }
        image = ImageUtilities.createRenderedImage((RenderedImage)image, (Color)bkg);
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        AffineTransform imageTransform = new AffineTransform((double)imageWidth, 0.0, 0.0, (double)imageHeight, 0.0, 0.0);
        xform.concatenate(imageTransform);
        this.os.println("gsave /DeviceRGB setcolorspace");
        this.transform(xform);
        this.os.println("<<");
        this.os.println("/ImageType 1");
        this.os.println("/Width " + imageWidth + "  /Height " + imageHeight);
        this.os.println("/BitsPerComponent 8");
        this.os.println("/Decode [0 1 0 1 0 1]");
        this.os.println("/ImageMatrix [" + imageWidth + " 0 0 " + imageHeight + " 0 0]");
        String writeAs = this.getProperty(WRITE_IMAGES_AS);
        byte[] flateBytes = null;
        if (writeAs.equals("ZLIB") || writeAs.equals("Smallest Size")) {
            ByteArrayOutputStream flate = new ByteArrayOutputStream();
            ASCII85OutputStream flate85 = new ASCII85OutputStream((OutputStream)flate);
            FlateOutputStream fos = new FlateOutputStream((OutputStream)flate85);
            UserProperties props = new UserProperties();
            props.setProperty(RawImageWriteParam.BACKGROUND, bkg);
            props.setProperty(RawImageWriteParam.CODE, "RGB");
            props.setProperty(RawImageWriteParam.PAD, 1);
            ImageGraphics2D.writeImage((RenderedImage)image, (String)"raw", (Properties)props, (OutputStream)fos);
            fos.close();
            flateBytes = flate.toByteArray();
        }
        byte[] jpgBytes = null;
        if (writeAs.equals("JPG") || writeAs.equals("Smallest Size")) {
            ByteArrayOutputStream jpg = new ByteArrayOutputStream();
            ASCII85OutputStream jpg85 = new ASCII85OutputStream((OutputStream)jpg);
            ImageGraphics2D.writeImage((RenderedImage)image, (String)"jpg", (Properties)new Properties(), (OutputStream)jpg85);
            jpg85.close();
            jpgBytes = jpg.toByteArray();
        }
        if (writeAs.equals("ZLIB")) {
            encode = "Flate";
            imageBytes = flateBytes;
        } else if (writeAs.equals("JPG")) {
            encode = "DCT";
            imageBytes = jpgBytes;
        } else {
            encode = (double)jpgBytes.length < 0.5 * (double)flateBytes.length ? "DCT" : "Flate";
            imageBytes = encode.equals("DCT") ? jpgBytes : flateBytes;
        }
        this.os.println("/DataSource currentfile /ASCII85Decode filter /" + encode + "Decode filter ");
        this.os.println(">> image");
        this.os.write(imageBytes);
        this.os.println("");
        this.os.println("grestore");
    }

    protected void writeString(String str, double x, double y) throws IOException {
        this.showCharacterCodes(str, x, y);
    }

    protected void writeTransform(AffineTransform tx) throws IOException {
        this.os.println("[ " + this.fixedPrecision(tx.getScaleX()) + " " + this.fixedPrecision(tx.getShearY()) + " " + this.fixedPrecision(tx.getShearX()) + " " + this.fixedPrecision(tx.getScaleY()) + " " + this.fixedPrecision(tx.getTranslateX()) + " " + this.fixedPrecision(tx.getTranslateY()) + " ] concat");
    }

    protected void writeSetTransform(AffineTransform tx) throws IOException {
        this.os.println("[ " + this.fixedPrecision(tx.getScaleX()) + " " + this.fixedPrecision(tx.getShearY()) + " " + this.fixedPrecision(tx.getShearX()) + " " + this.fixedPrecision(tx.getScaleY()) + " " + this.fixedPrecision(tx.getTranslateX()) + " " + this.fixedPrecision(tx.getTranslateY()) + " ] defaultmatrix matrix concatmatrix setmatrix");
    }

    protected void writeClip(Shape s) throws IOException {
        if (s == null || !this.isProperty(CLIP)) {
            return;
        }
        if (s instanceof Rectangle) {
            this.os.println(((Rectangle)s).x + " " + ((Rectangle)s).y + " " + ((Rectangle)s).width + " " + ((Rectangle)s).height + " rc");
        } else if (s instanceof Rectangle2D) {
            this.os.println(this.fixedPrecision(((Rectangle2D)s).getX()) + " " + this.fixedPrecision(((Rectangle2D)s).getY()) + " " + this.fixedPrecision(((Rectangle2D)s).getWidth()) + " " + this.fixedPrecision(((Rectangle2D)s).getHeight()) + " rc");
        } else {
            boolean eofill = this.writePath(s);
            this.os.println(eofill ? "W*" : "W");
        }
    }

    protected void writeSetClip(Shape s) throws IOException {
        this.os.println("cliprestore");
        this.writeClip(s);
    }

    private boolean writePath(Shape s) throws IOException {
        this.os.println("newpath");
        PSPathConstructor path = new PSPathConstructor(this.os, true, false);
        return path.addPath(s);
    }

    protected void writeWidth(float width) throws IOException {
        this.os.println(this.fixedPrecision(width) + " w");
    }

    protected void writeCap(int cap) throws IOException {
        switch (cap) {
            default: {
                this.os.println("0 J");
                break;
            }
            case 1: {
                this.os.println("1 J");
                break;
            }
            case 2: {
                this.os.println("2 J");
            }
        }
    }

    protected void writeJoin(int join) throws IOException {
        switch (join) {
            default: {
                this.os.println("0 j");
                break;
            }
            case 1: {
                this.os.println("1 j");
                break;
            }
            case 2: {
                this.os.println("2 j");
            }
        }
    }

    protected void writeMiterLimit(float limit) throws IOException {
        this.os.println(this.fixedPrecision(limit) + " M");
    }

    protected void writeDash(float[] dash, float phase) throws IOException {
        this.os.print("[ ");
        for (int i = 0; i < dash.length; ++i) {
            this.os.print(this.fixedPrecision(dash[i]) + " ");
        }
        this.os.println("] " + this.fixedPrecision(phase) + " d");
    }

    public void setPaintMode() {
        this.writeWarning(((Object)((Object)this)).getClass() + ": setPaintMode() not implemented.");
    }

    public void setXORMode(Color c1) {
        this.writeWarning(((Object)((Object)this)).getClass() + ": setXORMode(Color) not implemented.");
    }

    protected void writePaint(Color c) throws IOException {
        this.setPSColor(c, false);
    }

    protected void writePaint(GradientPaint paint) throws IOException {
        if (this.postscriptLevel >= 3) {
            float[] rgb1 = paint.getColor1().getRGBColorComponents(null);
            float[] rgb2 = paint.getColor2().getRGBColorComponents(null);
            Point2D p1 = paint.getPoint1();
            Point2D p2 = paint.getPoint2();
            this.os.println("<< /PatternType 2");
            this.os.println("   /Shading");
            this.os.println("   << /ShadingType 2");
            this.os.println("      /ColorSpace /DeviceRGB");
            this.os.println("      /Coords [" + p1.getX() + " " + p1.getY() + " " + p2.getX() + " " + p2.getY() + "]");
            this.os.println("      /Function");
            this.os.println("      << /FunctionType 2");
            this.os.println("         /Domain [0 1]");
            this.os.println("         /Range [0 1 0 1 0 1]");
            this.os.println("         /C0 [" + rgb1[0] + " " + rgb1[1] + " " + rgb1[2] + "]");
            this.os.println("         /C1 [" + rgb2[0] + " " + rgb2[1] + " " + rgb2[2] + "]");
            this.os.println("         /N 1");
            this.os.println("      >>");
            this.os.println("      /Extend [true true]");
            this.os.println("   >>");
            this.os.println(">>");
            this.os.println("matrix makepattern setpattern");
        } else {
            this.writeComment("Gradient fill not supported by ps level 2. Replacing with intermediate color.");
            this.setColor(PrintColor.mixColor((Color)paint.getColor1(), (Color)paint.getColor2()));
        }
    }

    protected void writePaint(TexturePaint paint) throws IOException {
        BufferedImage img = paint.getImage();
        this.os.println("<< /PatternType 1");
        this.os.println("   /PaintType 1");
        this.os.println("   /TilingType 1");
        this.os.println("   /BBox [0 0 " + img.getWidth() + " " + img.getHeight() + "]");
        this.os.println("   /XStep " + paint.getAnchorRect().getWidth());
        this.os.println("   /YStep " + paint.getAnchorRect().getHeight());
        this.os.println("   /PaintProc");
        this.os.println("   {");
        this.os.println("     begin");
        this.os.println("     /DeviceRGB setcolorspace");
        this.os.println("     0 0 translate");
        this.os.println("     " + img.getWidth() + " " + img.getHeight() + " scale");
        this.os.println("     <<");
        this.os.println("     /ImageType 1");
        this.os.println("     /Width " + img.getWidth());
        this.os.println("     /Height " + img.getWidth());
        this.os.println("     /BitsPerComponent 8");
        this.os.println("     /Decode [0 1 0 1 0 1]");
        this.os.println("     /ImageMatrix [" + img.getWidth() + " 0 0 " + img.getHeight() + " 0 0]");
        this.os.println("     /DataSource ( Z  Z  Z  Z  Z  Z  Z  Z Z ZZ ZZ ZZ ZZ ZZ ZZ ZZ Z)");
        this.os.println("     >> image");
        this.os.println("     end");
        this.os.println("   } bind");
        this.os.println(">>");
        this.os.println("matrix makepattern setpattern");
    }

    protected void writePaint(Paint p) throws IOException {
        this.writeWarning(((Object)((Object)this)).getClass() + ": writePaint(Paint) not implemented for " + p.getClass());
    }

    protected void writeFont(Font font) {
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        this.writeWarning(((Object)((Object)this)).getClass() + ": getDeviceConfiguration() not implemented.");
        return null;
    }

    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        this.writeWarning(((Object)((Object)this)).getClass() + ": hit(Rectangle, Shape, boolean) not implemented.");
        return false;
    }

    public void writeComment(String s) throws IOException {
        this.os.println("% " + s);
    }

    public String toString() {
        return "PSGraphics2D";
    }

    public void showString(Font font, String str) {
        StringBuffer result = new StringBuffer();
        Map<TextAttribute, ?> attributes = font.getAttributes();
        PSFontTable.normalize(attributes);
        String fontName = this.fontTable.fontReference(font, this.isProperty(EMBED_FONTS), this.getProperty(EMBED_FONTS_AS));
        result.append("/");
        result.append(fontName);
        result.append(" findfont ");
        result.append(font.getSize());
        result.append(" scalefont setfont");
        if (this.isProperty(EMBED_FONTS)) {
            result.append("\n");
            result.append(PSStringStyler.getEscaped(str));
            result.append(" show");
        } else {
            result.append(" ");
            result.append(PSStringStyler.getStyledString(attributes, str));
            result.append(" recshow");
        }
        this.os.println(result.toString());
    }

    private void showCharacterCodes(String str, double x, double y) throws IOException {
        this.os.println("q ");
        AffineTransform at = new AffineTransform(1.0, 0.0, 0.0, 1.0, x, y);
        at.concatenate(this.getFont().getTransform());
        at.scale(1.0, -1.0);
        this.writeTransform(at);
        this.os.println(this.fixedPrecision(0.0) + " " + this.fixedPrecision(0.0) + " moveto");
        if (this.isProperty(EMBED_FONTS)) {
            FontUtilities.showString((Font)this.getFont(), (String)str, (CharTable)this.fontTable.getEncodingTable(), (FontUtilities.ShowString)this);
        } else {
            this.showString(this.getFont(), str);
        }
        this.os.println("Q");
    }

    private void setPSColor(Color c, boolean fillColor) {
        if (c != null) {
            if (c instanceof MappedColor) {
                MappedColor mc = (MappedColor)c;
                if (!fillColor) {
                    if (mc.getBrightness() == 0) {
                        this.os.println(mc.getColorTag() + " vg&C");
                    } else {
                        this.os.println(mc.getColorTag() + " " + mc.getBrightness() + " darken vg&C");
                    }
                } else if (mc.getBrightness() == 0) {
                    this.os.println(mc.getColorTag() + " vg&DFC");
                } else {
                    this.os.println(mc.getColorTag() + " " + mc.getBrightness() + " darken vg&DFC");
                }
            } else {
                Color pc = this.getPrintColor(c);
                double red = (double)pc.getRed() / 255.0;
                double green = (double)pc.getGreen() / 255.0;
                double blue = (double)pc.getBlue() / 255.0;
                this.os.print(this.fixedPrecision(red) + " " + this.fixedPrecision(green) + " " + this.fixedPrecision(blue) + " ");
                this.os.println(fillColor ? "rg" : "RG");
            }
        }
    }

    public String fixedPrecision(double d) {
        return this.scientific.format(d);
    }

    static {
        defaultProperties.setProperty(BACKGROUND, false);
        defaultProperties.setProperty(BACKGROUND_COLOR, Color.GRAY);
        defaultProperties.setProperty(PAGE_SIZE, "International");
        defaultProperties.setProperty(PAGE_MARGINS, PageConstants.getMargins((String)"Small"));
        defaultProperties.setProperty(ORIENTATION, "Portrait");
        defaultProperties.setProperty(FIT_TO_PAGE, true);
        defaultProperties.setProperty(EMBED_FONTS, false);
        defaultProperties.setProperty(TEXT_AS_SHAPES, false);
        defaultProperties.setProperty(EMBED_FONTS_AS, "Type3");
        defaultProperties.setProperty(FOR, "");
        defaultProperties.setProperty(TITLE, "");
        defaultProperties.setProperty(PREVIEW, false);
        defaultProperties.setProperty(PREVIEW_BITS, 8);
        defaultProperties.setProperty(WRITE_IMAGES_AS, "Smallest Size");
        defaultProperties.setProperty(CLIP, true);
        defaultProperties.setProperty(TEXT_AS_SHAPES, true);
        psAlignments = new String[4][4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                PSGraphics2D.psAlignments[i][j] = "0";
            }
        }
        PSGraphics2D.psAlignments[1][1] = "0";
        PSGraphics2D.psAlignments[1][2] = "1";
        PSGraphics2D.psAlignments[1][0] = "2";
        PSGraphics2D.psAlignments[1][3] = "3";
        PSGraphics2D.psAlignments[3][1] = "4";
        PSGraphics2D.psAlignments[3][2] = "5";
        PSGraphics2D.psAlignments[3][0] = "6";
        PSGraphics2D.psAlignments[3][3] = "7";
        PSGraphics2D.psAlignments[2][1] = "8";
        PSGraphics2D.psAlignments[2][2] = "9";
        PSGraphics2D.psAlignments[2][0] = "10";
        PSGraphics2D.psAlignments[2][3] = "11";
    }
}

