/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.http;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Vector;
import org.apache.ant.http.Base64Encode;
import org.apache.ant.http.HttpAuthenticationStrategy;
import org.apache.ant.http.HttpBasicAuth;
import org.apache.ant.http.HttpRequestParameter;
import org.apache.ant.http.NullOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;

public abstract class HttpTask
extends Task {
    protected boolean failOnError = true;
    protected int blockSize = 64;
    protected String status;
    private String source;
    private File destFile;
    private boolean verbose = false;
    private boolean useTimestamp = false;
    private int authType = 0;
    private String username;
    private String password;
    private Vector params = new Vector();
    private Vector headers = new Vector();
    private boolean usecaches = false;
    private String destProperty = null;
    private boolean useResponseCode = true;
    public static final int AUTH_NONE = 0;
    public static final int AUTH_BASIC = 1;
    public static final int AUTH_DIGEST = 2;

    public void setUseCaches(boolean usecaches) {
        this.usecaches = usecaches;
    }

    public void setUseResponseCode(boolean useResponseCode) {
        this.useResponseCode = useResponseCode;
    }

    public void setURL(String u) {
        this.source = u;
    }

    public void setDestFile(File destFile) {
        this.destFile = destFile;
    }

    public void setDestinationProperty(String name) {
        this.destProperty = name;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setFailOnError(boolean b) {
        this.failOnError = b;
    }

    public void setUseTimestamp(boolean usetimestamp) {
        this.useTimestamp = usetimestamp;
    }

    public void setAuthtype(AuthMethodType type) {
        this.authType = type.getIndex();
    }

    public void setUsername(String username) {
        this.username = username;
        if (this.authType == 0) {
            this.authType = 1;
        }
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(int blocksize) {
        this.blockSize = blocksize;
    }

    public boolean getUseCaches() {
        return this.usecaches;
    }

    public boolean getFailOnError() {
        return this.failOnError;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getURL() {
        return this.source;
    }

    public Vector getRequestParameters() {
        return this.params;
    }

    public String getStatus() {
        return this.status;
    }

    public String getDestinationProperty() {
        return this.destProperty;
    }

    public File getDestFile() {
        return this.destFile;
    }

    public void noteSuccess() {
        if (this.status != null && this.status.length() > 0) {
            this.getProject().setProperty(this.status, "true");
        }
    }

    public void execute() {
        block29: {
            this.verifyArguments();
            URL url = this.buildURL();
            try {
                int statusCode;
                int length;
                HttpAuthenticationStrategy authStrategy;
                URLConnection connection = url.openConnection();
                connection.setUseCaches(this.getUseCaches());
                long localTimestamp = this.getTimestamp();
                if (localTimestamp != 0L) {
                    if (this.verbose) {
                        Date t = new Date(localTimestamp);
                        this.log("local file date : " + t.toString());
                    }
                    connection.setIfModifiedSince(localTimestamp);
                }
                if ((authStrategy = this.getAuthStrategy()) != null) {
                    authStrategy.setAuthenticationHeader(connection, null, this.username, this.password);
                }
                int i = 0;
                while (i < this.headers.size()) {
                    HttpRequestParameter header = (HttpRequestParameter)((Object)this.headers.get(i));
                    connection.setRequestProperty(header.getName(), header.getValue());
                    ++i;
                }
                String method = this.getRequestMethod();
                HttpURLConnection httpConnection = null;
                if (connection instanceof HttpURLConnection) {
                    httpConnection = (HttpURLConnection)connection;
                    httpConnection.setRequestMethod(method);
                }
                this.log("making " + method + " to " + url);
                connection = this.doConnect(connection);
                if (!this.onConnected(connection)) {
                    return;
                }
                if (connection instanceof HttpURLConnection) {
                    httpConnection = (HttpURLConnection)connection;
                }
                if (httpConnection != null && localTimestamp != 0L && this.getResponseCode(httpConnection) == 304) {
                    this.log("Local file is up to date - so nothing was downloaded");
                    this.noteSuccess();
                    return;
                }
                InputStream is = this.getInputStream(connection);
                if (is == null) {
                    this.log("Can't get " + url, 0);
                    if (this.getFailOnError()) {
                        return;
                    }
                    throw new BuildException("Can't reach URL");
                }
                OutputStream out = null;
                if (this.destFile != null) {
                    this.log("Saving output to " + this.destFile, 4);
                    out = new FileOutputStream(this.destFile);
                } else if (this.destProperty != null) {
                    this.log("Saving output to property " + this.destProperty, 4);
                    out = new ByteArrayOutputStream(this.blockSize * 1024);
                } else {
                    out = new NullOutputStream();
                }
                int contentLength = connection.getHeaderFieldInt("Content-Length", -1);
                int bytesRead = 0;
                byte[] buffer = new byte[this.blockSize * 1024];
                while ((length = is.read(buffer)) >= 0 && (contentLength == -1 || bytesRead < contentLength)) {
                    bytesRead += length;
                    out.write(buffer, 0, length);
                    if (!this.verbose) continue;
                    this.showProgressChar('.');
                }
                if (this.verbose) {
                    this.showProgressChar('\n');
                }
                if (out instanceof ByteArrayOutputStream) {
                    this.getProject().setProperty(this.destProperty, out.toString());
                }
                out.flush();
                out.close();
                is.close();
                is = null;
                out = null;
                if (!this.onDownloadFinished(connection)) {
                    return;
                }
                if (this.useTimestamp) {
                    long remoteTimestamp = connection.getLastModified();
                    if (this.verbose) {
                        Date t = new Date(remoteTimestamp);
                        this.log("last modified = " + t.toString() + (remoteTimestamp == 0L ? " - using current time instead" : ""));
                    }
                    if (remoteTimestamp != 0L) {
                        this.destFile.setLastModified(remoteTimestamp);
                    }
                }
                String failureString = null;
                if (contentLength > -1 && bytesRead != contentLength) {
                    failureString = "Incomplete download -Expected " + contentLength + "received " + bytesRead + " bytes";
                } else if (httpConnection != null && this.useResponseCode && ((statusCode = httpConnection.getResponseCode()) < 200 || statusCode > 299)) {
                    failureString = "Server error code " + statusCode + " received";
                }
                if (failureString == null) {
                    this.noteSuccess();
                } else {
                    if (this.failOnError) {
                        throw new BuildException(failureString);
                    }
                    this.log(failureString, 0);
                }
            }
            catch (IOException ioe) {
                this.log("Error performing " + this.getRequestMethod() + " on " + url + " : " + ioe.toString(), 0);
                if (!this.failOnError) break block29;
                throw new BuildException((Throwable)ioe);
            }
        }
    }

    protected void showProgressChar(char c) {
        System.out.write(c);
    }

    public void addParam(HttpRequestParameter param) {
        this.params.add(param);
    }

    public void addHeader(HttpRequestParameter header) {
        this.headers.add(header);
    }

    protected abstract String getRequestMethod();

    protected long getTimestamp() {
        long timestamp = 0L;
        timestamp = this.useTimestamp && this.destFile != null && this.destFile.exists() ? this.destFile.lastModified() : 0L;
        return timestamp;
    }

    protected String getAuthenticationString() {
        if (this.authType == 1 && this.username != null) {
            this.password = this.password == null ? "" : this.password;
            String encodeStr = String.valueOf(this.username) + ":" + this.password;
            Base64Encode encoder = new Base64Encode();
            char[] encodedPass = encoder.encodeBase64(encodeStr.getBytes());
            String authStr = "BASIC " + new String(encodedPass);
            return authStr;
        }
        return null;
    }

    protected void verifyArguments() throws BuildException {
        if (this.getURL() == null) {
            throw new BuildException("target URL missing");
        }
        if (this.destFile != null && this.destFile.exists()) {
            if (this.destFile.isDirectory()) {
                throw new BuildException("The specified destination is a directory");
            }
            if (!this.destFile.canWrite()) {
                throw new BuildException("Can't write to " + this.destFile.getAbsolutePath());
            }
        }
        if (this.authType != 0 && this.username == null) {
            throw new BuildException("no username defined to use with authorisation");
        }
    }

    protected URL buildURL() throws BuildException {
        String urlbase = this.getURL();
        try {
            if (this.areParamsAddedToUrl()) {
                urlbase = this.parameterizeURL();
            }
            return new URL(urlbase);
        }
        catch (MalformedURLException e) {
            throw new BuildException("Invalid URL");
        }
    }

    protected String parameterizeURL() throws BuildException {
        if (this.params.size() == 0) {
            return this.getURL();
        }
        StringBuffer buf = new StringBuffer(this.getURL());
        buf.append(this.source.indexOf(63) == -1 ? (char)'?' : '&');
        int i = 0;
        while (i < this.params.size()) {
            if (i > 0) {
                buf.append('&');
            }
            HttpRequestParameter param = (HttpRequestParameter)((Object)this.params.get(i));
            buf.append(param.toString());
            ++i;
        }
        return buf.toString();
    }

    protected boolean areParamsAddedToUrl() {
        return true;
    }

    protected HttpAuthenticationStrategy getAuthStrategy() {
        HttpBasicAuth strategy = null;
        switch (this.authType) {
            case 1: {
                strategy = new HttpBasicAuth();
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new BuildException("Authentication method " + this.authType + " not supported");
            }
        }
        return strategy;
    }

    protected URLConnection makeConnectionWithAuthHandling(URLConnection connection) throws BuildException, IOException {
        HttpURLConnection httpConnection;
        this.log("Connecting to " + connection.toString(), 4);
        connection.connect();
        URLConnection returnConnection = connection;
        this.log("connected", 4);
        if (connection instanceof HttpURLConnection && this.getResponseCode(httpConnection = (HttpURLConnection)connection) == 401 && this.authType == 2) {
            this.log("Digest authentication needed but not yet supported", 4);
        }
        return returnConnection;
    }

    void probeConnection(HttpURLConnection connection) {
        connection.getHeaderFieldKey(0);
    }

    protected int getResponseCode(HttpURLConnection connection) throws IOException {
        FileNotFoundException swallowed = null;
        boolean caught = false;
        int response = 0;
        int attempts = 0;
        while (attempts < 5) {
            try {
                response = connection.getResponseCode();
                caught = true;
                break;
            }
            catch (FileNotFoundException ex) {
                this.log("Swallowed FileNotFoundException in getResponseCode", 3);
                this.log(ex.toString(), 4);
                swallowed = ex;
                ++attempts;
            }
        }
        if (!caught && swallowed != null) {
            throw swallowed;
        }
        return response;
    }

    protected InputStream getInputStream(URLConnection connection) throws IOException {
        FileNotFoundException swallowed = null;
        InputStream instream = null;
        int attempts = 0;
        while (attempts < 5) {
            try {
                instream = connection.getInputStream();
                break;
            }
            catch (FileNotFoundException ex) {
                this.log("Swallowed IO exception in getInputStream", 3);
                this.log(ex.toString(), 4);
                swallowed = ex;
                ++attempts;
            }
        }
        if (instream == null && swallowed != null) {
            throw swallowed;
        }
        return instream;
    }

    protected URLConnection doConnect(URLConnection connection) throws BuildException, IOException {
        return this.makeConnectionWithAuthHandling(connection);
    }

    protected URLConnection doConnectWithUpload(URLConnection connection, String contentType, int contentLength, InputStream content) throws IOException {
        this.log("uploading " + contentLength + " bytes of type " + contentType, 3);
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Length", String.valueOf(contentLength));
        connection.setRequestProperty("Content-Type", contentType);
        connection = this.makeConnectionWithAuthHandling(connection);
        OutputStream toServer = connection.getOutputStream();
        int buffersize = this.blockSize * 1024;
        if (contentLength < buffersize) {
            buffersize = contentLength;
        }
        byte[] buffer = new byte[buffersize];
        int remaining = contentLength;
        while (remaining > 0) {
            int read = content.read(buffer);
            this.log("block of " + read, 4);
            toServer.write(buffer, 0, read);
            remaining -= read;
            if (!this.verbose) continue;
            this.showProgressChar('^');
        }
        if (this.verbose) {
            this.showProgressChar('\n');
        }
        this.log("upload completed", 4);
        return connection;
    }

    protected boolean onConnected(URLConnection connection) throws BuildException {
        return true;
    }

    protected boolean onDownloadFinished(URLConnection connection) throws BuildException {
        return true;
    }

    public static class AuthMethodType
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"none", "basic"};
        }
    }
}

