/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.http;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.LogLevel;
import org.apache.tools.ant.util.TaskLogger;

public class HttpPut
extends Task {
    File uploadFile;
    String targetUrl;
    String username;
    String password;
    private static final char[] base64Array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    public void execute() throws BuildException {
        TaskLogger logger = new TaskLogger((Task)this);
        try {
            URL url = new URL(this.targetUrl);
            URLConnection urlConnection = url.openConnection();
            HttpURLConnection httpConnection = null;
            if (urlConnection instanceof HttpURLConnection) {
                try {
                    httpConnection = (HttpURLConnection)urlConnection;
                    if (this.username != null) {
                        httpConnection.setRequestProperty("Authorization", HttpPut.userNamePasswordBase64(this.username, this.password));
                    }
                    httpConnection.setRequestMethod("PUT");
                    httpConnection.setDoInput(true);
                    httpConnection.setDoOutput(true);
                    int fileSize = (int)this.uploadFile.length();
                    FileInputStream in = new FileInputStream(this.uploadFile);
                    OutputStream out = httpConnection.getOutputStream();
                    this.copyStreamSynchronously(in, out, true, fileSize, logger);
                    InputStream httpIn = httpConnection.getInputStream();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(httpIn));
                    String line = reader.readLine();
                    while (line != null) {
                        this.log(line, LogLevel.INFO.getLevel());
                        line = reader.readLine();
                    }
                    httpIn.close();
                    logger.info("HTTP Put finished successfully: Uploaded " + this.uploadFile.length());
                }
                catch (IOException e) {
                    logger.info("Server responded " + httpConnection.getResponseCode() + ": " + httpConnection.getResponseMessage());
                    logger.error("IO Error: " + e.getLocalizedMessage());
                }
            }
        }
        catch (MalformedURLException e) {
            logger.error("Wrong URL: " + e.getLocalizedMessage());
        }
        catch (IOException e) {
            logger.error("IO Error: " + e.getLocalizedMessage());
        }
        super.execute();
    }

    public static String userNamePasswordBase64(String username, String password) {
        return "Basic " + HttpPut.base64Encode(String.valueOf(username) + ":" + password);
    }

    public void copyStreamSynchronously(InputStream in, OutputStream out, boolean closeOutputStream, int bytesToCopy, TaskLogger logger) throws IOException {
        int bytesFinished = 0;
        int percentFinished = 0;
        byte[] buffer = new byte[1024];
        try {
            int length;
            while ((length = in.read(buffer)) != -1) {
                out.write(buffer, 0, length);
                out.flush();
                if ((bytesFinished += length) * 100 / bytesToCopy <= percentFinished) continue;
                percentFinished = bytesFinished * 100 / bytesToCopy;
                String result = "[" + "...........................................................................................................".substring(0, percentFinished) + "                                                                                                       ".substring(0, 100 - percentFinished) + "]";
                logger.info(result);
            }
            out.flush();
        }
        finally {
            if (closeOutputStream && out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String base64Encode(String string) {
        String encodedString = "";
        byte[] bytes = string.getBytes();
        int i = 0;
        int pad = 0;
        while (i < bytes.length) {
            byte b3;
            byte b2;
            byte b1 = bytes[i++];
            if (i >= bytes.length) {
                b2 = 0;
                b3 = 0;
                pad = 2;
            } else {
                b2 = bytes[i++];
                if (i >= bytes.length) {
                    b3 = 0;
                    pad = 1;
                } else {
                    b3 = bytes[i++];
                }
            }
            byte c1 = (byte)(b1 >> 2);
            byte c2 = (byte)((b1 & 3) << 4 | b2 >> 4);
            byte c3 = (byte)((b2 & 0xF) << 2 | b3 >> 6);
            byte c4 = (byte)(b3 & 0x3F);
            encodedString = String.valueOf(encodedString) + base64Array[c1];
            encodedString = String.valueOf(encodedString) + base64Array[c2];
            switch (pad) {
                case 0: {
                    encodedString = String.valueOf(encodedString) + base64Array[c3];
                    encodedString = String.valueOf(encodedString) + base64Array[c4];
                    break;
                }
                case 1: {
                    encodedString = String.valueOf(encodedString) + base64Array[c3];
                    encodedString = String.valueOf(encodedString) + "=";
                    break;
                }
                case 2: {
                    encodedString = String.valueOf(encodedString) + "==";
                }
            }
        }
        return encodedString;
    }

    public File getUploadFile() {
        return this.uploadFile;
    }

    public void setUploadFile(File uploadFile) {
        this.uploadFile = uploadFile;
    }

    public String getTargetUrl() {
        return this.targetUrl;
    }

    public void setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

