/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLConnection;
import java.util.Vector;
import org.apache.ant.http.ContentGuesser;
import org.apache.ant.http.HttpRequestParameter;
import org.apache.ant.http.HttpTask;
import org.apache.tools.ant.BuildException;

public class HttpPost
extends HttpTask {
    protected File postFile = null;
    private String contentType;

    public void setUploadFile(File postFile) {
        this.postFile = postFile;
    }

    public File getUploadFile() {
        return this.postFile;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    @Override
    protected boolean areParamsAddedToUrl() {
        return false;
    }

    @Override
    protected URLConnection doConnect(URLConnection connection) throws BuildException, IOException {
        if (this.postFile == null) {
            return this.doConnectFormPost(connection);
        }
        return this.doConnectFilePost(connection);
    }

    protected URLConnection doConnectFormPost(URLConnection connection) throws BuildException, IOException {
        this.log("Posting data as a form", 3);
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(256);
        PrintWriter out = new PrintWriter(byteStream);
        this.writePostData(out);
        out.flush();
        out.close();
        byte[] data = byteStream.toByteArray();
        return this.doConnectWithUpload(connection, "application/x-www-form-urlencoded", byteStream.size(), new ByteArrayInputStream(data));
    }

    protected URLConnection doConnectFilePost(URLConnection connection) throws BuildException, IOException {
        int size = (int)this.postFile.length();
        this.log("Posting file " + this.postFile, 3);
        FileInputStream instream = new FileInputStream(this.postFile);
        String type = this.contentType;
        if (type == null) {
            type = ContentGuesser.guessContentType(this.postFile.getName());
        }
        return this.doConnectWithUpload(connection, type, size, instream);
    }

    protected void writePostData(PrintWriter out) {
        Vector params = this.getRequestParameters();
        int i = 0;
        while (i < params.size()) {
            if (i > 0) {
                out.print('&');
            }
            HttpRequestParameter param = (HttpRequestParameter)((Object)params.get(i));
            out.print(param.toString());
            this.log("parameter : " + param.toString(), 4);
            ++i;
        }
    }

    @Override
    public String getRequestMethod() {
        return "POST";
    }
}

