/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.http;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class Hostname
extends Task {
    private String property;
    private boolean failonerror = true;
    private boolean address = false;

    public void setFailOnError(boolean failonerror) {
        this.failonerror = failonerror;
    }

    public void setAddress(boolean address) {
        this.address = address;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void execute() throws BuildException {
        if (this.property == null) {
            throw new BuildException("Property attribute must be defined");
        }
        Exception exception = null;
        try {
            String result = this.address ? this.getAddress() : this.getHostname();
            this.project.setNewProperty(this.property, result);
        }
        catch (UnknownHostException e) {
            exception = e;
        }
        catch (SecurityException e) {
            exception = e;
        }
        if (exception != null) {
            if (this.failonerror) {
                throw new BuildException("resolving hostname", (Throwable)exception);
            }
            this.log("failed to resolve local hostname", 0);
        }
    }

    public String getAddress() throws SecurityException, UnknownHostException {
        return Hostname.getLocalHostAddress().getHostAddress();
    }

    public String getHostname() throws SecurityException, UnknownHostException {
        return Hostname.getLocalHostAddress().getHostName();
    }

    public static InetAddress getLocalHostAddress() throws UnknownHostException {
        return InetAddress.getLocalHost();
    }
}

